/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.openide.TopManager;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.text.Line;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;

public class IOManager {
    public static final int DEBUGGER_OUT = 1;
    public static final int PROCESS_OUT = 2;
    public static final int STATUS_OUT = 4;
    public static final int ALL_OUT = 7;
    public static final int STD_OUT = 1;
    public static final int ERR_OUT = 2;
    private static Hashtable debuggerToProcesIO = new Hashtable();
    private static Hashtable debuggerToDebuggerIO = new Hashtable();
    private static AbstractDebugger currentDebugger;
    protected InputOutput processIO = null;
    protected InputOutput debuggerIO = null;
    private AbstractDebugger debugger;
    private OutputWriter processOut;
    private OutputWriter debuggerOut;
    private String name;
    private Thread inputThread = null;
    private Thread outputThread = null;
    private Thread errorThread = null;
    private Hashtable lines = new Hashtable();
    private Listener listener = new Listener();
    private static DListener dListener;

    public IOManager(AbstractDebugger abstractDebugger) {
        this.debugger = abstractDebugger;
        InputOutput inputOutput = TopManager.getDefault().getIO("Debugger Console");
        this.debuggerOut = inputOutput.getOut();
        this.processIO = TopManager.getDefault().getIO("Process Output");
        this.processOut = this.processIO.getOut();
        ((TopComponent)inputOutput).hide();
        debuggerToDebuggerIO.put(abstractDebugger, inputOutput);
        debuggerToProcesIO.put(abstractDebugger, this.processIO);
        try {
            final CoreDebugger coreDebugger = (CoreDebugger)TopManager.getDefault().getDebugger();
            if (dListener == null) {
                dListener = new DListener();
                coreDebugger.addPropertyChangeListener(dListener);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (currentDebugger == null) {
                        currentDebugger = IOManager.this.debugger;
                        return;
                    }
                    InputOutput inputOutput = (InputOutput)debuggerToProcesIO.get(currentDebugger);
                    if (inputOutput != null) {
                        if (coreDebugger.getDebuggers().length < 2) {
                            inputOutput.closeInputOutput();
                            debuggerToProcesIO.remove(currentDebugger);
                            System.out.println("IOManager.init Tab Closed " + currentDebugger);
                        } else {
                            inputOutput.setOutputVisible(false);
                        }
                    }
                    if ((inputOutput = (InputOutput)debuggerToDebuggerIO.get(currentDebugger)) != null) {
                        if (coreDebugger.getDebuggers().length < 2) {
                            inputOutput.closeInputOutput();
                            debuggerToDebuggerIO.remove(currentDebugger);
                        } else {
                            inputOutput.setOutputVisible(false);
                        }
                    }
                    currentDebugger = IOManager.this.debugger;
                }
            });
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    public void select() {
        this.processIO.select();
    }

    public void print(final String string, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((n & 2) != 0) {
                    IOManager.this.processOut.print(string);
                }
                if ((n & 1) != 0) {
                    IOManager.this.debuggerOut.print(string);
                }
                if ((n & 4) != 0) {
                    TopManager.getDefault().setStatusText(string);
                }
            }
        });
    }

    public void println(String string) {
        this.println(string, 1);
    }

    public void println(String string, int n) {
        this.println(string, n, null);
    }

    public void println(final String string, final int n, final Line line) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if ((n & 2) != 0) {
                        if (line != null) {
                            IOManager.this.processOut.println(string, (OutputListener)IOManager.this.listener);
                            IOManager.this.lines.put(string, line);
                        } else {
                            IOManager.this.processOut.println(string);
                        }
                    }
                    if ((n & 1) != 0) {
                        if (line != null) {
                            IOManager.this.debuggerOut.println(string, (OutputListener)IOManager.this.listener);
                            IOManager.this.lines.put(string, line);
                        } else {
                            IOManager.this.debuggerOut.println(string);
                        }
                    }
                    if ((n & 4) != 0) {
                        TopManager.getDefault().setStatusText(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void showOutput(Process process, int n, int n2) {
        if (process == null) {
            throw new NullPointerException();
        }
        if ((n | 1) != 0) {
            this.outputThread = new CopyMaker("Debugger output writer thread", new InputStreamReader(process.getInputStream()), (Writer)((n2 & 2) != 0 ? this.processOut : this.debuggerOut), false);
            this.outputThread.start();
        }
        if ((n | 2) != 0) {
            this.errorThread = new CopyMaker("Debugger error writer thread", new InputStreamReader(process.getErrorStream()), (Writer)((n2 & 2) != 0 ? this.processOut : this.debuggerOut), false);
            this.errorThread.start();
        }
    }

    public void connectInput(Process process) {
        if (process == null) {
            throw new NullPointerException();
        }
        if (this.processIO == null) {
            return;
        }
        this.processIO.setInputVisible(true);
        this.processIO.flushReader();
        this.inputThread = new CopyMaker("Debugger input reader thread", this.processIO.getIn(), new OutputStreamWriter(process.getOutputStream()), true);
        this.inputThread.start();
    }

    public void stop() {
        if (this.errorThread != null) {
            this.errorThread.interrupt();
            this.errorThread = null;
        }
        if (this.outputThread != null) {
            this.outputThread.interrupt();
            this.outputThread = null;
        }
        if (this.inputThread != null) {
            this.inputThread.interrupt();
            this.inputThread = null;
        }
        try {
            CoreDebugger coreDebugger = (CoreDebugger)TopManager.getDefault().getDebugger();
            if (coreDebugger.getDebuggers().length > 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InputOutput inputOutput = (InputOutput)debuggerToProcesIO.get(IOManager.this.debugger);
                        if (inputOutput != null) {
                            inputOutput.closeInputOutput();
                        }
                        if ((inputOutput = (InputOutput)debuggerToDebuggerIO.get(IOManager.this.debugger)) != null) {
                            inputOutput.closeInputOutput();
                        }
                        debuggerToProcesIO.remove(IOManager.this.debugger);
                        debuggerToDebuggerIO.remove(IOManager.this.debugger);
                    }
                });
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    private static void switchOutput() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    InputOutput inputOutput;
                    AbstractDebugger abstractDebugger = ((CoreDebugger)TopManager.getDefault().getDebugger()).getCurrentDebugger();
                    if (currentDebugger != null && currentDebugger != abstractDebugger && abstractDebugger != null) {
                        inputOutput = (InputOutput)debuggerToProcesIO.get(currentDebugger);
                        if (inputOutput != null) {
                            inputOutput.setOutputVisible(false);
                        }
                        if ((inputOutput = (InputOutput)debuggerToDebuggerIO.get(currentDebugger)) != null) {
                            inputOutput.setOutputVisible(false);
                        }
                        currentDebugger = null;
                    }
                    if (abstractDebugger != null) {
                        inputOutput = (InputOutput)debuggerToDebuggerIO.get(abstractDebugger);
                        if (inputOutput != null) {
                            inputOutput.setOutputVisible(true);
                        }
                        if ((inputOutput = (InputOutput)debuggerToProcesIO.get(abstractDebugger)) != null) {
                            inputOutput.setOutputVisible(true);
                        }
                        currentDebugger = abstractDebugger;
                    }
                }
                catch (DebuggerNotFoundException debuggerNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    private static class DListener
    implements PropertyChangeListener {
        private DListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName() != "currentDebugger") {
                return;
            }
            IOManager.switchOutput();
        }
    }

    private static class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;

        CopyMaker(String string, Reader reader, Writer writer, boolean bl) {
            super(string);
            this.os = writer;
            this.is = reader;
            this.autoflush = bl;
            this.setPriority(1);
        }

        public void run() {
            char[] cArray = new char[256];
            try {
                int n;
                while ((n = this.read(this.is, cArray, 0, 256)) > 0) {
                    this.os.write(cArray, 0, n);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private int read(Reader reader, char[] cArray, int n, int n2) throws InterruptedException, IOException {
            if (Utilities.getOperatingSystem() != 1024 && Utilities.getOperatingSystem() != 8192) {
                while (!reader.ready()) {
                    Thread.sleep(100L);
                }
            }
            return reader.read(cArray, n, n2);
        }
    }

    private class Listener
    implements OutputListener {
        private Listener() {
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            String string = outputEvent.getLine();
            Line line = (Line)IOManager.this.lines.get(string);
            if (line == null) {
                return;
            }
            line.show(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            IOManager.this.lines = new Hashtable();
        }
    }
}

