/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackRoot;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesRoot;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.SecondaryDebuggerSupport;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.actions.CreateVariableAction;
import org.netbeans.modules.debugger.support.actions.RunToCursorAction;
import org.netbeans.modules.debugger.support.actions.SuspendResumeSupport;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.debugger.support.java.JavaProjectSettings;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.TopManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public abstract class JavaDebugger
extends SecondaryDebuggerSupport
implements ThreadsRoot,
ValidatorHolder,
SuspendResumeSupport,
VariablesRoot,
CallStackRoot {
    static final long serialVersionUID = 2791304615739651906L;
    public static final State STATE_RUNNING = new StateSupport(32);
    public static final State STATE_STARTING = new StateSupport(0);
    private static ResourceBundle bundle;
    private transient boolean generalIOName = true;
    private transient Validator validator = new ValidatorImpl();
    private transient Listener listener;
    private transient CoreDebugger coreDebugger;
    boolean showMessages = false;
    boolean followedByEditor = true;
    private transient IOManager io;
    private transient HashMap stackAnnotations = new HashMap();
    private transient DebuggerAnnotation currentPC = new DebuggerAnnotation.CurrentPC();
    private RequestProcessor.Task updateUITask = null;
    private CallStackFilter csFilter;
    private VariablesFilter filter;
    private JavaThread markedThread = null;
    private static String errMsgPattern;
    private transient int markedCallStackFrame;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateVariableAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaProjectSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$RunToCursorAction;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;

    protected static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger));
        }
        return bundle.getString(string);
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        super.startDebugger(debuggerInfo);
        this.io = new IOManager(this);
        this.io.println(JavaDebugger.getString("CTL_Debugger_starting"), 4);
        this.coreDebugger = (CoreDebugger)TopManager.getDefault().getDebugger();
        this.listener = new Listener();
        this.coreDebugger.addPropertyChangeListener(this.listener);
        ((CreateVariableAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction))).changeEnabled(true);
    }

    public synchronized void finishDebugger() throws DebuggerException {
        JavaThreadGroup javaThreadGroup;
        if (this.getState() == 1) {
            return;
        }
        if (this.io != null) {
            this.io.stop();
        }
        if ((javaThreadGroup = (JavaThreadGroup)this.getThreadsRoot()) != null) {
            javaThreadGroup.removeAll();
        }
        this.setCurrentThread(null);
        this.setState(1);
        ((CreateVariableAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction))).changeEnabled(false);
        this.validator.clear();
        this.updateUI();
        this.setCurrentLine(null);
        TopManager.getDefault().getDebugger().removePropertyChangeListener((PropertyChangeListener)this.listener);
        this.listener = null;
        this.clearCallStackAnnotations();
    }

    public void traceInto() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(3);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void traceOver() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(2);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void go() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(5);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void stepOut() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(4);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void runToCursor(Line line) {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(10);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void pause() {
        ((JavaThreadGroup)this.getThreadsRoot()).setSuspended(true);
        this.setState(4);
    }

    public void goToCalledMethod() {
        this.updateCurrentStackPosition();
        if (this.markedThread != null && this.markedCallStackFrame > 0) {
            this.markedThread.setCurrentCallStackFrameIndex(--this.markedCallStackFrame);
            JavaDebugger.showCallStackLocation(this.markedThread.getCallStack()[this.markedCallStackFrame]);
            this.updateStoppedState();
        }
    }

    public void goToCallingMethod() {
        this.updateCurrentStackPosition();
        if (this.markedThread != null && this.markedCallStackFrame < this.markedThread.getStackDepth() - 1) {
            this.markedThread.setCurrentCallStackFrameIndex(++this.markedCallStackFrame);
            JavaDebugger.showCallStackLocation(this.markedThread.getCallStack()[this.markedCallStackFrame]);
            this.updateStoppedState();
        }
    }

    public void setCurrentLine(Line line) {
        if (this.coreDebugger.getCurrentDebugger() == this) {
            if (line != null) {
                Utils.showInEditor(line);
                this.currentPC.attachLine(line);
            } else {
                this.currentPC.detachLine();
            }
        }
        super.setCurrentLine(line);
    }

    public void annotateCallStack() {
        HashMap hashMap = this.stackAnnotations;
        synchronized (hashMap) {
            Line line;
            JavaThread javaThread = (JavaThread)this.getCurrentThread();
            Location[] locationArray = javaThread != null ? javaThread.getCallStack() : new Location[]{};
            HashMap<Line, DebuggerAnnotation> hashMap2 = new HashMap<Line, DebuggerAnnotation>();
            int n = 1;
            while (n < locationArray.length) {
                line = locationArray[n].getLine();
                if (line != null) {
                    DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)this.stackAnnotations.remove(line));
                    if (debuggerAnnotation == null) {
                        debuggerAnnotation = new DebuggerAnnotation.CallSite();
                        DebuggerAnnotation debuggerAnnotation2 = hashMap2.put(line, debuggerAnnotation);
                        if (debuggerAnnotation2 == null) {
                            debuggerAnnotation.attachLine(line);
                        } else {
                            hashMap2.put(line, debuggerAnnotation2);
                        }
                    } else {
                        hashMap2.put(line, debuggerAnnotation);
                    }
                }
                ++n;
            }
            line = this.stackAnnotations.entrySet().iterator();
            while (line.hasNext()) {
                ((DebuggerAnnotation)((Object)((Map.Entry)line.next()).getValue())).detachLine();
            }
            this.stackAnnotations = hashMap2;
        }
    }

    public void clearCallStackAnnotations() {
        HashMap hashMap = this.stackAnnotations;
        synchronized (hashMap) {
            Iterator iterator = this.stackAnnotations.entrySet().iterator();
            while (iterator.hasNext()) {
                ((DebuggerAnnotation)((Object)iterator.next().getValue())).detachLine();
            }
            this.stackAnnotations.clear();
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public abstract AbstractThread getCurrentThread();

    public abstract void setCurrentThread(AbstractThread var1);

    public boolean compile(DebuggerInfo debuggerInfo) {
        JavaDebuggerSettings javaDebuggerSettings = (JavaDebuggerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
        if (!javaDebuggerSettings.getRunCompilation()) {
            return true;
        }
        String string = debuggerInfo.getClassName();
        if (string == null) {
            return true;
        }
        ClassElement classElement = ClassElement.forName((String)string);
        if (classElement == null) {
            return true;
        }
        HashSet<CompilerCookie> hashSet = new HashSet<CompilerCookie>();
        CompilerCookie compilerCookie = (CompilerCookie)classElement.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = JavaDebugger.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (compilerCookie == null) {
            return true;
        }
        hashSet.add(compilerCookie);
        return AbstractCompileAction.compile(Collections.enumeration(hashSet), (String)"");
    }

    protected void setState(int n) {
        super.setState(n);
        this.updateCurrentStackPosition();
        switch (n) {
            case 1: {
                this.setDebuggerState(SecondaryDebuggerSupport.STATE_NOT_RUNNING);
                break;
            }
            case 3: {
                this.updateRunningState();
                break;
            }
            case 2: {
                this.setDebuggerState(STATE_STARTING);
                break;
            }
            case 4: {
                this.updateStoppedState();
            }
        }
    }

    public String getProcessName(DebuggerInfo debuggerInfo) {
        String string;
        if (debuggerInfo instanceof AbstractDebuggerInfo && (string = ((AbstractDebuggerInfo)debuggerInfo).getProcessName()) != null) {
            return string;
        }
        return debuggerInfo.getStopClassName() != null ? debuggerInfo.getStopClassName() : debuggerInfo.getClassName();
    }

    public abstract String getLocationName(DebuggerInfo var1);

    protected void updateUI() {
        if (this.updateUITask != null) {
            this.updateUITask.cancel();
        }
        this.updateUITask = RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                JavaDebugger.this.updateUINow();
            }
        }, (int)500, (int)1);
    }

    protected void updateUINow() {
        if (this.getCurrentThread() == null) {
            this.clearCallStackAnnotations();
        } else {
            this.annotateCallStack();
        }
        this.getValidator().validate();
    }

    public boolean canBeCurrent(Line line, boolean bl) {
        return line.canBeMarkedCurrent(bl ? 1 : this.getLastAction(), this.getCurrentLine());
    }

    public CallStackFilter getCallStackFilter() {
        if (this.csFilter != null) {
            return this.csFilter;
        }
        JavaProjectSettings javaProjectSettings = (JavaProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings), (boolean)true);
        return javaProjectSettings.getCallStackFilter();
    }

    public void setCallStackFilter(CallStackFilter callStackFilter) {
        if (callStackFilter == this.csFilter) {
            return;
        }
        if (callStackFilter != null && callStackFilter.equals(this.csFilter)) {
            return;
        }
        CallStackFilter callStackFilter2 = this.csFilter;
        this.csFilter = callStackFilter;
        this.firePropertyChange("callStackFilter", callStackFilter2, callStackFilter);
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        JavaProjectSettings javaProjectSettings = (JavaProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings), (boolean)true);
        return javaProjectSettings.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
        this.firePropertyChange("variablesFilter", variablesFilter2, variablesFilter);
    }

    public String getInfo() {
        return null;
    }

    protected void updateStoppedState() {
        Node[] nodeArray;
        int n = 64;
        JavaThread javaThread = (JavaThread)this.getCurrentThread();
        if (javaThread != null && javaThread.isSuspended()) {
            n |= 7;
            if (this.markedCallStackFrame > 0) {
                n |= 0x100;
            }
            if (this.markedCallStackFrame < javaThread.getStackDepth() - 1) {
                n |= 0x80;
            }
        }
        if ((nodeArray = ((RunToCursorAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$actions$RunToCursorAction == null ? (class$org$netbeans$modules$debugger$support$actions$RunToCursorAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.RunToCursorAction")) : class$org$netbeans$modules$debugger$support$actions$RunToCursorAction))).getActivatedNodes()) != null && nodeArray.length == 1 && null != nodeArray[0].getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = JavaDebugger.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie)) {
            n |= 0x10;
        }
        if (this.getStoppedStateForFix()) {
            n |= 0x400;
        }
        if (this.getPopTopmostFrameState()) {
            n |= 0x200;
        }
        this.setDebuggerState(new StateSupport(n));
    }

    protected void updateRunningState() {
        this.setDebuggerState(STATE_RUNNING);
    }

    protected boolean getStoppedStateForFix() {
        return false;
    }

    protected boolean getPopTopmostFrameState() {
        return false;
    }

    public IOManager getIOManager() {
        return this.io;
    }

    protected void updateCurrentStackPosition() {
        if (this.getState() != 4) {
            this.markedThread = null;
            return;
        }
        JavaThread javaThread = (JavaThread)this.getCurrentThread();
        if (javaThread != this.markedThread) {
            this.markedThread = javaThread;
            if (this.markedThread != null) {
                this.markedCallStackFrame = 0;
                this.markedThread.setCurrentCallStackFrameIndex(0);
            }
        }
    }

    private static void showCallStackLocation(Location location) {
        Line line = location.getLine();
        if (line != null) {
            line.show(1);
        } else {
            if (errMsgPattern == null) {
                errMsgPattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger), (String)"MSG_Call_stack_location_not_available");
            }
            TopManager.getDefault().setStatusText(MessageFormat.format(errMsgPattern, location.getLocationName()));
        }
    }

    public abstract ThreadsProducer getThreadsRoot();

    public abstract void setSuspended(boolean var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() != "currentDebugger") {
                return;
            }
            if (JavaDebugger.this.coreDebugger.getCurrentDebugger() == JavaDebugger.this) {
                Line line = JavaDebugger.this.getCurrentLine();
                if (line != null) {
                    Utils.showInEditor(line);
                    JavaDebugger.this.currentPC.attachLine(line);
                }
            } else {
                JavaDebugger.this.currentPC.detachLine();
            }
        }
    }
}

