/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.java.CompactCallStackFilter;
import org.netbeans.modules.debugger.support.java.DNFilter;
import org.netbeans.modules.debugger.support.java.HashSetFilter;
import org.netbeans.modules.debugger.support.java.HashtableFilter;
import org.netbeans.modules.debugger.support.java.IntFilter;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaVariablesFilter;
import org.netbeans.modules.debugger.support.java.LinkedListFilter;
import org.netbeans.modules.debugger.support.java.ListFilter;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;

public class JavaProjectSettings
extends ContextSystemOption {
    static final long serialVersionUID = 811103321325025600L;
    public static final String PROP_VARIABLES_FILTER = "variablesFilter";
    public static final String PROP_CALL_STACK_FILTER = "callStackFilter";
    public static final String PROP_VARIABLES_NAME_RESOLVER = "variablesNameResolver";
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaProjectSettings;

    public String displayName() {
        return JavaDebugger.getString("CTL_JavaProjectSettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaProjectSettings.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings);
    }

    public boolean isGlobal() {
        return false;
    }

    public VariablesFilter getVariablesFilter() {
        VariablesFilter variablesFilter = (VariablesFilter)this.getProperty(PROP_VARIABLES_FILTER);
        if (variablesFilter == null) {
            variablesFilter = JavaProjectSettings.createDefaultFilter();
        }
        this.putProperty(PROP_VARIABLES_FILTER, variablesFilter, false);
        return variablesFilter;
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        this.putProperty(PROP_VARIABLES_FILTER, variablesFilter, true);
    }

    public CallStackFilter getCallStackFilter() {
        CallStackFilter callStackFilter = (CallStackFilter)this.getProperty(PROP_CALL_STACK_FILTER);
        if (callStackFilter == null) {
            callStackFilter = JavaProjectSettings.createDefaultCSFilter();
        }
        this.putProperty(PROP_CALL_STACK_FILTER, callStackFilter, false);
        return callStackFilter;
    }

    public void setCallStackFilter(CallStackFilter callStackFilter) {
        this.putProperty(PROP_CALL_STACK_FILTER, callStackFilter, true);
    }

    private static CallStackFilter createDefaultCSFilter() {
        return new CompactCallStackFilter();
    }

    private static VariablesFilter createDefaultFilter() {
        ModifiersFilter modifiersFilter = new ModifiersFilter("{value}");
        JavaVariablesFilter javaVariablesFilter = new JavaVariablesFilter(modifiersFilter);
        javaVariablesFilter.registerTag("name", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 6196237682769007810L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "?";
                }
                return abstractVariable.getVariableName();
            }
        });
        javaVariablesFilter.registerTag("value", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = -6543236533654358077L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "null";
                }
                return abstractVariable.getAsText();
            }
        });
        javaVariablesFilter.registerTag("type", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 8599811372521647355L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                return ((JavaVariable)abstractVariable).getInnerType();
            }
        });
        javaVariablesFilter.registerTag("stype", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = -2283968919278295226L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                String string = ((JavaVariable)abstractVariable).getInnerType();
                if (string == null) {
                    return "";
                }
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    return string;
                }
                return string.substring(n + 1);
            }
        });
        javaVariablesFilter.registerTag("fieldType", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 8711487137836659574L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                return abstractVariable.getType();
            }
        });
        javaVariablesFilter.registerTag("sFieldType", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 1121035879829872469L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                String string = abstractVariable.getType();
                if (string == null) {
                    return "";
                }
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    return string;
                }
                return string.substring(n + 1);
            }
        });
        javaVariablesFilter.registerTag("toString", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 7036768814835670393L;

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "null";
                }
                return ((JavaVariable)abstractVariable).toStringValue();
            }
        });
        javaVariablesFilter.registerTag("arrayLength", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = -1064948502033927341L;

            public String resolve(AbstractVariable abstractVariable) {
                return "Length=" + ((JavaVariable)abstractVariable).getSize();
            }
        });
        javaVariablesFilter.register("int", new IntFilter("{value}"));
        javaVariablesFilter.register("long", new IntFilter("{value}"));
        javaVariablesFilter.register("short", new IntFilter("{value}"));
        javaVariablesFilter.register("byte", new IntFilter("{value}"));
        javaVariablesFilter.register("java.lang.String", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.StringBuffer", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Integer", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Char", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Boolean", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Double", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Short", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Float", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Byte", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Long", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.lang.Class", new DNFilter("{toString}"));
        javaVariablesFilter.register("java.util.HashMap$Entry", new DNFilter("({key.stype}) {key.value} => ({value.stype}) {value.value}"));
        javaVariablesFilter.register("java.util.Hashtable$Entry", new DNFilter("({key.stype}) {key.value} => ({value.stype}) {value.value}"));
        javaVariablesFilter.register("java.util.Vector", new ListFilter("{value}", new String[]{"elementData"}, true, false, true));
        javaVariablesFilter.register("java.util.Stack", new ListFilter("{value}", new String[]{"elementData"}, true, false, false));
        javaVariablesFilter.register("java.util.ArrayList", new ListFilter("{value}", new String[]{"elementData"}, true, false, true));
        javaVariablesFilter.register("java.beans.PropertyChangeSupport", new ListFilter("{value}", new String[]{"listeners", "elementData"}, true, true, false));
        javaVariablesFilter.register("java.util.HashMap", new HashtableFilter("{value}"));
        javaVariablesFilter.register("java.util.Hashtable", new HashtableFilter("{value}"));
        javaVariablesFilter.register("java.util.HashSet", new HashSetFilter("{value}"));
        javaVariablesFilter.register("java.util.LinkedList", new LinkedListFilter("{value}"));
        return javaVariablesFilter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

