/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.text.Line;

public abstract class JavaThread
extends AbstractThread
implements Location,
VariablesProducer,
CallStackProducer,
ModifiersFilter.Filterable {
    public static final String PROP_ADITIONAL_THREAD_INFO = "aditionalThreadInfo";
    public static final String PROP_CALL_STACK = "callStack";
    protected JavaDebugger debugger;
    private boolean current = false;
    private PropertyChangeSupport pcs;
    private JavaThreadGroup parentThreadGroup;
    protected VariablesFilter filter;
    protected CallStackFilter csFilter;
    private int currentCallStackFrameIndex;

    protected JavaThread(JavaDebugger javaDebugger, JavaThreadGroup javaThreadGroup) {
        this.parentThreadGroup = javaThreadGroup;
        this.debugger = javaDebugger;
        this.currentCallStackFrameIndex = -1;
        this.pcs = new PropertyChangeSupport(this);
    }

    public final JavaDebugger getDebugger() {
        return this.debugger;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean bl) {
        this.current = bl;
        AbstractThread abstractThread = this.debugger.getCurrentThread();
        if (!bl) {
            if (abstractThread != null && abstractThread.equals(this)) {
                this.debugger.setCurrentThread(null);
            }
            if (this.getParentThreadGroup() != null) {
                this.getParentThreadGroup().setCurrent(false);
            }
            this.debugger.setCurrentLine(null);
            return;
        }
        if (abstractThread != null && abstractThread != this) {
            abstractThread.setCurrent(false);
        }
        this.debugger.setState(this.isSuspended() ? 4 : 3);
        this.debugger.setCurrentThread(this);
        this.debugger.getValidator().validate();
        try {
            ((CoreDebugger)TopManager.getDefault().getDebugger()).setCurrentDebugger(this.getDebugger());
        }
        catch (DebuggerException debuggerException) {
            debuggerException.printStackTrace();
        }
        int n = this.getLineNumber();
        if (n >= 0) {
            Line line = this.getLine();
            if (line != null) {
                this.debugger.setCurrentLine(line);
            } else {
                this.debugger.setCurrentLine(null);
            }
        } else {
            this.debugger.setCurrentLine(null);
            Location[] locationArray = this.getCallStack();
            int n2 = locationArray.length;
            int n3 = 1;
            while (n3 < n2) {
                if (Utils.showInEditor(locationArray[n3].getLine()) != null) break;
                ++n3;
            }
        }
        if (this.getParentThreadGroup() != null) {
            this.getParentThreadGroup().setCurrent(true);
        }
    }

    protected void updateAnnotationsAndDisplayLocation() {
        this.debugger.setCurrentLine(null);
        this.debugger.annotateCallStack();
        int n = this.getLineNumber();
        if (n >= 0) {
            Line line = this.getLine();
            if (line != null) {
                this.debugger.setCurrentLine(line);
            }
        } else {
            Location[] locationArray = this.getCallStack();
            int n2 = locationArray.length;
            int n3 = 1;
            while (n3 < n2) {
                if (Utils.showInEditor(locationArray[n3].getLine()) != null) break;
                ++n3;
            }
        }
    }

    public int getCurrentCallStackFrameIndex() {
        return this.currentCallStackFrameIndex;
    }

    public void setCurrentCallStackFrameIndex(int n) {
        if (n != this.currentCallStackFrameIndex) {
            int n2 = this.currentCallStackFrameIndex;
            this.currentCallStackFrameIndex = n;
            this.debugger.getValidator().validate();
            this.firePropertyChange("currentCallstackFrameIndex", new Integer(n2), new Integer(this.currentCallStackFrameIndex));
        }
    }

    public Line getLine() {
        String string = this.getSourceName();
        if (string != null) {
            return Utils.getLineForSource(this.getClassName(), this.getSourceName(), this.getLineNumber());
        }
        return Utils.getLine(this.getClassName(), this.getLineNumber());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public abstract boolean isSuspended();

    public void setSuspended(boolean bl) throws DebuggerException {
        if (this.isCurrent()) {
            if (bl) {
                this.setCurrent(true);
                this.debugger.setState(4);
            } else {
                this.debugger.setCurrentLine(null);
                this.debugger.clearCallStackAnnotations();
                this.debugger.setState(3);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaThread.this.firePropertyChange(JavaThread.PROP_CALL_STACK, null, null);
            }
        });
    }

    public abstract void refreshStack();

    public JavaThreadGroup getParentThreadGroup() {
        return this.parentThreadGroup;
    }

    public abstract int getLineNumber();

    public abstract String getState();

    public abstract String getClassName();

    public abstract String getMethod();

    public abstract int getStackDepth();

    public abstract void stop() throws DebuggerException;

    public abstract String getSourceName();

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public boolean isLeaf() {
        return false;
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
        this.pcs.firePropertyChange("variablesFilter", variablesFilter2, variablesFilter);
    }

    public CallStackFilter getCallStackFilter() {
        if (this.csFilter != null) {
            return this.csFilter;
        }
        return this.debugger.getCallStackFilter();
    }

    public void setCallStackFilter(CallStackFilter callStackFilter) {
        if (callStackFilter == this.csFilter) {
            return;
        }
        if (callStackFilter != null && callStackFilter.equals(this.csFilter)) {
            return;
        }
        CallStackFilter callStackFilter2 = this.csFilter;
        this.csFilter = callStackFilter;
        this.pcs.firePropertyChange("callStackFilter", callStackFilter2, callStackFilter);
    }

    public String getLocationName() {
        CallStackFrame[] callStackFrameArray = (CallStackFrame[])this.getCallStack();
        if (callStackFrameArray.length < 1) {
            return "";
        }
        return callStackFrameArray[0].getClassName() + '.' + callStackFrameArray[0].getMethodName() + " : " + callStackFrameArray[0].getLineNumber();
    }

    public String toString() {
        try {
            return "The Thread: " + this.getName() + " (" + super.toString() + ")";
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public abstract AbstractVariable[] getVariables();

    public abstract String getInfo();

    public abstract Location[] getCallStack();

    public abstract JavaVariable[] filterVariables(ModifiersFilter var1, int var2, int var3);
}

