/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.util.ResourceBundle;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.nodes.LocationNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CallStackLineNode
extends LocationNode {
    static final long serialVersionUID = -490111283333957792L;
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode;

    public CallStackLineNode(CallStackFrame callStackFrame, CallStackProducer callStackProducer, int n, boolean bl) {
        super(callStackFrame, callStackProducer, n, bl);
    }

    protected void finalize() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerCallStackLineNode");
    }

    protected void createProperties() {
        PropertySupport.Reflection reflection;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "className", CallStackLineNode.getLocalizedString("PROP_call_stack_class_name"), CallStackLineNode.getLocalizedString("HINT_call_stack_class_name"), "getCallStackFrameClassName", null));
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "methodName", CallStackLineNode.getLocalizedString("PROP_call_stack_method_name"), CallStackLineNode.getLocalizedString("HINT_call_stack_method_name"), "getCallStackFrameMethodName", null));
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "lineNumber", CallStackLineNode.getLocalizedString("PROP_call_stack_line_number"), CallStackLineNode.getLocalizedString("HINT_call_stack_line_number"), "getCallStackFrameLineNumber", null));
        try {
            reflection = new PropertySupport.Reflection((Object)this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "getLocation", "setLocation");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException.getMessage());
        }
        reflection.setName("location");
        reflection.setDisplayName(CallStackLineNode.getLocalizedString("PROP_location"));
        reflection.setShortDescription(CallStackLineNode.getLocalizedString("HINT_location"));
        try {
            reflection.setPropertyEditorClass(Class.forName("org.netbeans.modules.debugger.support.util.LinkEditor"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
        set.put((Node.Property)reflection);
        this.setSheet(sheet);
    }

    protected void updateName() {
        CallStackFrame callStackFrame = (CallStackFrame)this.location;
        String string = callStackFrame.getClassName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        string = string + "." + callStackFrame.getMethodName();
        int n2 = callStackFrame.getLineNumber();
        if (this.showSubNodes && n2 > 0) {
            string = string + ":" + n2;
        }
        this.setDisplayName(string);
        this.setName(string);
    }

    public String getCallStackFrameClassName() {
        return ((CallStackFrame)this.location).getClassName();
    }

    public String getCallStackFrameMethodName() {
        return ((CallStackFrame)this.location).getMethodName();
    }

    public String getCallStackFrameLineNumber() {
        int n = ((CallStackFrame)this.location).getLineNumber();
        if (n < 0) {
            return "";
        }
        return "" + n;
    }

    public String getLocation() {
        try {
            String string;
            int n;
            String string2 = ((CallStackFrame)this.location).getSourceName();
            if (string2.endsWith(".java")) {
                string2 = string2.substring(0, string2.length() - 5);
            }
            if ((n = string2.lastIndexOf(46)) < 0 && (n = (string = ((CallStackFrame)this.location).getClassName()).lastIndexOf(46)) > 0) {
                string2 = string.substring(0, n + 1) + string2;
            }
            if ((string = this.getCallStackFrameLineNumber()).length() < 1) {
                return string2 + ".java";
            }
            return string2 + ".java:" + string;
        }
        catch (DebuggerException debuggerException) {
            return CallStackLineNode.getLocalizedString("MSG_Not_available");
        }
    }

    public void setLocation(String string) {
    }

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode = CallStackLineNode.class$("org.netbeans.modules.debugger.support.java.nodes.CallStackLineNode")) : class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode));
        }
        return bundle.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

