/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.modules.debugger.support.java.JavaClass;

class PackageContent {
    private String name;
    private boolean changed;
    private Hashtable classes = new Hashtable();
    private Hashtable packages = new Hashtable();

    public PackageContent(String string) {
        this.name = string;
        this.changed = true;
    }

    public void add(JavaClass javaClass) {
        this.add(javaClass, null);
    }

    private void add(JavaClass javaClass, String string) {
        if (string == null) {
            string = javaClass.getName();
        }
        if (string.indexOf(36) > -1) {
            return;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Element element = (Element)this.classes.get(javaClass);
            if (element == null) {
                this.classes.put(javaClass, new Element(javaClass));
                this.changed = true;
            } else {
                element.confirmed = true;
            }
        } else {
            String string2 = string.substring(0, n);
            PackageContent packageContent = (PackageContent)this.packages.get(string2);
            if (packageContent == null) {
                packageContent = new PackageContent(this.name.concat(".").concat(string2));
                this.packages.put(string2, packageContent);
                this.changed = true;
            }
            packageContent.add(javaClass, string.substring(n + 1));
        }
    }

    public String getName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public String getFullName() {
        return this.name;
    }

    public PackageContent getSubContent(String string) {
        return (PackageContent)this.packages.get(string);
    }

    public boolean isEmpty() {
        return this.packages.size() == 0 && this.classes.size() == 0;
    }

    public Object[] getContent() {
        Object[] objectArray = new Object[this.classes.size() + this.packages.size()];
        int n = 0;
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = enumeration.nextElement();
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = ((Element)enumeration.nextElement()).clazz;
        }
        return objectArray;
    }

    public void reorganize() {
        Object object;
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            object = (PackageContent)enumeration.nextElement();
            ((PackageContent)object).reorganize();
            if (!((PackageContent)object).isEmpty()) continue;
            this.packages.remove(((PackageContent)object).getName());
            this.changed = true;
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            object = (Element)enumeration.nextElement();
            if (!((Element)object).newOne && !((Element)object).confirmed) {
                this.classes.remove(((Element)object).clazz);
                this.changed = true;
                continue;
            }
            ((Element)object).newOne = false;
            ((Element)object).confirmed = false;
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public void clearChangedFlag() {
        this.changed = false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PackageContent)) {
            return false;
        }
        return this.name.equals(((PackageContent)object).getFullName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private class Element {
        public JavaClass clazz;
        public boolean confirmed;
        public boolean newOne;

        public Element(JavaClass javaClass) {
            this.clazz = javaClass;
            this.confirmed = false;
            this.newOne = true;
        }
    }
}

