/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.nodes.BreakpointsRootNode;
import org.netbeans.modules.debugger.support.nodes.CopyPasteSupport;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public final class BreakpointNode
extends AbstractNode
implements GoToSourceCookie {
    static final long serialVersionUID = -8680621542479107034L;
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_CLASS_NAME = "className";
    public static final String PROP_METHOD_NAME = "methodName";
    private final CoreBreakpoint breakpoint;
    private Debugger debugger = null;
    private BreakpointGroup group = null;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DeleteAllAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToSourceAction;

    public BreakpointNode(CoreBreakpoint coreBreakpoint) {
        super(Children.LEAF);
        this.breakpoint = coreBreakpoint;
        this.init();
    }

    public BreakpointNode(CoreBreakpoint coreBreakpoint, BreakpointGroup breakpointGroup) {
        super((Children)new BreakpointsRootNode.BreakpointGroupChildren(breakpointGroup));
        this.breakpoint = coreBreakpoint;
        this.group = breakpointGroup;
        this.init();
    }

    private void init() {
        try {
            this.debugger = TopManager.getDefault().getDebugger();
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        this.getCookieSet().add((Node.Cookie)this);
        this.changeEvent();
        this.breakpoint.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string != null && (string.equals("event") || string.equals("actions"))) {
                    BreakpointNode.this.changeEvent();
                } else {
                    BreakpointNode.this.propertyChanged(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointNode");
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        CoreBreakpoint.Event event = this.breakpoint.getEvent(this.debugger);
        if (event != null) {
            set.put(event.getProperties());
        }
        set.put(Utils.createProperty(this.breakpoint, Boolean.TYPE, "enabled", DebuggerNode.getLocalizedString("PROP_breakpoint_enabled"), DebuggerNode.getLocalizedString("HINT_breakpoint_enabled"), "isEnabled", "setEnabled"));
        set.put(Utils.createProperty(this.breakpoint, Boolean.TYPE, "valid", DebuggerNode.getLocalizedString("PROP_breakpoint_valid"), DebuggerNode.getLocalizedString("HINT_breakpoint_valid"), "isValid", null));
        CoreBreakpoint.Action[] actionArray = this.breakpoint.getActions();
        if (actionArray != null) {
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                set.put(actionArray[n2].getProperties());
                ++n2;
            }
        }
        sheet.put(set);
        this.setSheet(sheet);
    }

    public SystemAction[] getContextActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.CreateBreakpointGroupAction")) : class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.EnableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.DisableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DeleteAllAction == null ? (class$org$netbeans$modules$debugger$support$actions$DeleteAllAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.DeleteAllAction")) : class$org$netbeans$modules$debugger$support$actions$DeleteAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BreakpointNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public SystemAction[] getActions() {
        if (this.breakpoint.getLine() == null) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BreakpointNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BreakpointNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BreakpointNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BreakpointNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.breakpoint.remove();
        super.destroy();
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction));
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCut() {
        ExTransferable.Single single = NodeTransfer.transferable((Node)this, (int)4);
        ExTransferable exTransferable = ExTransferable.create((Transferable)single);
        exTransferable.put(NodeTransfer.createPaste((NodeTransfer.Paste)new CopyPasteSupport.BreakpointPaste(this.breakpoint, true)));
        return exTransferable;
    }

    public void goToSource() {
        Line line = this.breakpoint.getLine();
        if (line == null) {
            return;
        }
        line.show(2);
    }

    public boolean canGoToSource() {
        return this.breakpoint.getLine() != null;
    }

    Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    void changeEvent() {
        CoreBreakpoint.Event event = this.breakpoint.getEvent(this.debugger);
        if (event == null) {
            return;
        }
        String string = event.getDisplayName();
        this.setName(string);
        this.setDisplayName(string);
        string = event.getIconBase();
        if (string == null) {
            string = ICON_BASE;
        }
        this.setIconBase(string);
        this.createProperties();
    }

    void propertyChanged(String string, Object object, Object object2) {
        CoreBreakpoint.Event event = this.breakpoint.getEvent(this.debugger);
        if (event == null) {
            return;
        }
        String string2 = event.getDisplayName();
        this.setName(string2);
        this.setDisplayName(string2);
        string2 = event.getIconBase();
        if (string2 == null) {
            string2 = ICON_BASE;
        }
        this.setIconBase(string2);
        this.firePropertyChange(string, object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

