/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LocationNode;
import org.netbeans.modules.debugger.support.nodes.ThreadNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CallStackNode
extends AbstractNode
implements ThreadNode.Refreshable {
    static final long serialVersionUID = -8259352660663524178L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/CallStack";
    private static ResourceBundle bundle;
    private CallStackProducer producer;
    private CallStackListener callStackListener;
    private int index = 0;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$CallStackNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$CallStackNode == null ? (class$org$netbeans$modules$debugger$support$nodes$CallStackNode = CallStackNode.class$("org.netbeans.modules.debugger.support.nodes.CallStackNode")) : class$org$netbeans$modules$debugger$support$nodes$CallStackNode));
        }
        return bundle.getString(string);
    }

    public CallStackNode(AbstractThread abstractThread, AbstractDebugger abstractDebugger) {
        super((Children)new CallStackChildren());
        this.producer = (CallStackProducer)((Object)abstractThread);
        String string = CallStackNode.getLocalizedString("CTL_CallStack");
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(ICON_BASE);
        this.callStackListener = new CallStackListener(this);
        abstractThread.addPropertyChangeListener(this.callStackListener);
    }

    public CallStackNode(Location location, CallStackProducer callStackProducer, int n, boolean bl) {
        super((Children)new CallStackChildren());
        this.producer = (CallStackProducer)((Object)location);
        this.index = n;
        String string = location.getLocationName();
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(ICON_BASE);
        this.callStackListener = new CallStackListener(this);
        this.producer.addPropertyChangeListener(this.callStackListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerCallStackNode");
    }

    public void refresh() {
        ((CallStackChildren)this.getChildren()).changeChildren();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CallStackListener
    implements PropertyChangeListener {
        private WeakReference node;
        private CallStackProducer producer;

        CallStackListener(CallStackNode callStackNode) {
            this.node = new WeakReference<CallStackNode>(callStackNode);
            this.producer = callStackNode.producer;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CallStackNode callStackNode = (CallStackNode)this.node.get();
            if (callStackNode == null) {
                this.producer.removePropertyChangeListener(this);
                return;
            }
            if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("callstack")) {
                ((CallStackChildren)callStackNode.getChildren()).changeChildren();
            }
        }
    }

    private static final class CallStackChildren
    extends Children.Keys {
        private boolean init = false;
        private ArrayList keys = new ArrayList();

        private CallStackChildren() {
        }

        protected void addNotify() {
            this.init = true;
            Location[] locationArray = ((CallStackNode)this.getNode()).producer.getCallStack();
            int n = locationArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.keys.add(0, locationArray[n - n2 - 1]);
                ++n2;
            }
            this.setKeys(this.keys);
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, ((CallStackNode)this.getNode()).producer, new Integer(((CallStackNode)this.getNode()).index + this.keys.indexOf(object)), Boolean.TRUE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void changeChildren() {
            if (!this.init) {
                return;
            }
            Location[] locationArray = ((CallStackNode)this.getNode()).producer.getCallStack();
            Node[] nodeArray = this.getNodes();
            int n = locationArray.length;
            int n2 = nodeArray.length;
            int n3 = Math.min(n, n2);
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeArray[n2 - n4 - 1];
                if (node instanceof LocationNode) {
                    ((LocationNode)node).updateLocation(locationArray[n - n4 - 1]);
                }
                ++n4;
            }
            n4 = n3;
            while (n4 < n) {
                this.keys.add(0, locationArray[n - n4 - 1]);
                ++n4;
            }
            n4 = n3;
            while (n4 < n2) {
                this.keys.remove(n2 - n4 - 1);
                ++n4;
            }
            this.setKeys(this.keys);
        }
    }
}

