/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CallStackRootNode
extends AbstractNode {
    static final long serialVersionUID = -8259352660663524178L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/CallStack";
    private static ResourceBundle bundle;
    private AbstractThread thread;
    private ThreadsRoot debugger;
    private CallStackListener callStackListener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode = CallStackRootNode.class$("org.netbeans.modules.debugger.support.nodes.CallStackRootNode")) : class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode));
        }
        return bundle.getString(string);
    }

    public CallStackRootNode() {
        this(false);
    }

    public CallStackRootNode(boolean bl) {
        super((Children)new CallStackChildren());
        String string = null;
        if (bl) {
            string = DebuggerNode.getLocalizedString("PROP_callstack_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_callstack_column_name"));
        } else {
            string = CallStackRootNode.getLocalizedString("CTL_CallStack");
        }
        this.setDisplayName(string);
        this.setName("CallStackRootNode");
        this.setIconBase(ICON_BASE);
        try {
            this.debugger = (ThreadsRoot)TopManager.getDefault().getDebugger();
            this.callStackListener = new CallStackListener(this);
            this.thread = this.debugger.getCurrentThread();
            if (this.thread != null) {
                this.thread.addPropertyChangeListener(this.callStackListener);
            }
            ((AbstractDebugger)((Object)this.debugger)).addPropertyChangeListener(this.callStackListener);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerCallStackRootNode");
    }

    public Node.Handle getHandle() {
        return new CallStackHandle();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CallStackHandle
    implements Node.Handle {
        static final long serialVersionUID = -45182213487259891L;

        private CallStackHandle() {
        }

        public Node getNode() {
            return new CallStackRootNode();
        }
    }

    private static class CallStackListener
    implements PropertyChangeListener {
        private WeakReference node;

        CallStackListener(CallStackRootNode callStackRootNode) {
            this.node = new WeakReference<CallStackRootNode>(callStackRootNode);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CallStackRootNode callStackRootNode = (CallStackRootNode)((Object)this.node.get());
            if (callStackRootNode == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("currentThread")) {
                if (callStackRootNode.thread != null) {
                    callStackRootNode.thread.removePropertyChangeListener(this);
                }
                callStackRootNode.thread = callStackRootNode.debugger.getCurrentThread();
                if (callStackRootNode.thread != null) {
                    callStackRootNode.thread.addPropertyChangeListener(this);
                }
                ((CallStackChildren)callStackRootNode.getChildren()).changeChildren();
            } else if (string.equals("callstack")) {
                ((CallStackChildren)callStackRootNode.getChildren()).changeChildren();
            }
        }
    }

    private static final class CallStackChildren
    extends Children.Keys {
        private boolean init = false;
        private ArrayList keys = new ArrayList();

        private CallStackChildren() {
        }

        protected void addNotify() {
            this.init = true;
            if (((CallStackRootNode)this.getNode()).thread == null) {
                return;
            }
            CallStackProducer callStackProducer = (CallStackProducer)((Object)((CallStackRootNode)this.getNode()).thread);
            Location[] locationArray = callStackProducer.getCallStackFilter().filterCallStack(callStackProducer);
            int n = locationArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.keys.add(0, locationArray[n - n2 - 1]);
                ++n2;
            }
            if (this.keys.size() > 0) {
                this.setKeys(this.keys);
            }
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, ((CallStackRootNode)this.getNode()).thread, new Integer(this.keys.indexOf(object)), Boolean.FALSE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        public void changeChildren() {
            if (!this.init) {
                return;
            }
            AbstractThread abstractThread = ((CallStackRootNode)this.getNode()).thread;
            if (abstractThread == null || !(abstractThread instanceof CallStackProducer)) {
                this.setKeys(Collections.EMPTY_SET);
                this.keys = new ArrayList();
                return;
            }
            Location[] locationArray = ((CallStackProducer)((Object)abstractThread)).getCallStackFilter().filterCallStack((CallStackProducer)((Object)abstractThread));
            Node[] nodeArray = this.getNodes();
            int n = locationArray.length;
            int n2 = nodeArray.length;
            this.keys.clear();
            this.keys.ensureCapacity(n);
            int n3 = 0;
            while (n3 < n) {
                this.keys.add(locationArray[n3]);
                ++n3;
            }
            this.setKeys(this.keys);
        }
    }
}

