/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.support.actions.SessionCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class SessionNode
extends AbstractNode
implements SessionCookie,
SwitchOnCookie {
    static final long serialVersionUID = -4736315827522307464L;
    public static final String PROP_SESSION_NAME = "sessionName";
    public static final String PROP_LOCATION_NAME = "locationName";
    public static final String PROP_STATE = "state";
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/sessionsView/Session";
    private static final String ICON_BASE_CURRENT = "org/netbeans/modules/debugger/resources/sessionsView/CurrentSession";
    private static SystemAction[] staticActions;
    private final AbstractDebugger debugger;
    private EnterpriseDebugger coreDebugger = null;
    private Listener listener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FinishSessionAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;

    public SessionNode(AbstractDebugger abstractDebugger) {
        super(Children.LEAF);
        this.debugger = abstractDebugger;
        this.update();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.listener = new Listener(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerSessionNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction = SessionNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnSessionAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FinishSessionAction == null ? (class$org$netbeans$modules$debugger$support$actions$FinishSessionAction = SessionNode.class$("org.netbeans.modules.debugger.support.actions.FinishSessionAction")) : class$org$netbeans$modules$debugger$support$actions$FinishSessionAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = SessionNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = SessionNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction = SessionNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnSessionAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction));
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = SessionNode.class$("java.lang.String")) : class$java$lang$String, PROP_SESSION_NAME, DebuggerNode.getLocalizedString("PROP_session_name"), DebuggerNode.getLocalizedString("HINT_session_name"), "getProcessName", null));
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = SessionNode.class$("java.lang.String")) : class$java$lang$String, "location", DebuggerNode.getLocalizedString("PROP_location_name"), DebuggerNode.getLocalizedString("HINT_location_name"), "getLocationName", null));
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = SessionNode.class$("java.lang.String")) : class$java$lang$String, "sessionState", DebuggerNode.getLocalizedString("PROP_state"), DebuggerNode.getLocalizedString("HINT_state"), "getState", null));
        this.setSheet(sheet);
    }

    public void destroy() throws IOException {
        super.destroy();
        this.listener.destroy();
        this.listener = null;
        this.coreDebugger = null;
    }

    public boolean isCurrent() {
        return this.getCoreDebugger().getCurrentDebugger() == this.debugger;
    }

    public boolean canSetCurrent() {
        return !this.isCurrent();
    }

    public void setCurrent() {
        this.getCoreDebugger().setCurrentDebugger(this.debugger);
    }

    private EnterpriseDebugger getCoreDebugger() {
        if (this.coreDebugger != null) {
            return this.coreDebugger;
        }
        try {
            this.coreDebugger = (EnterpriseDebugger)TopManager.getDefault().getDebugger();
            return this.coreDebugger;
        }
        catch (DebuggerException debuggerException) {
            return null;
        }
    }

    public String getProcessName() {
        DebuggerInfo debuggerInfo = this.debugger.getDebuggerInfo();
        return debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getProcessName() : "";
    }

    public String getLocationName() {
        DebuggerInfo debuggerInfo = this.debugger.getDebuggerInfo();
        return debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getLocationName() : "localhost";
    }

    public void finish() {
        try {
            this.getCoreDebugger().setSessionPersistent(this.debugger, false);
            this.debugger.finishDebugger();
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    private void update() {
        this.setIconBase(this.isCurrent() ? ICON_BASE_CURRENT : ICON_BASE);
        DebuggerInfo debuggerInfo = this.debugger.getDebuggerInfo();
        if (debuggerInfo == null) {
            return;
        }
        if (!(debuggerInfo instanceof AbstractDebuggerInfo)) {
            return;
        }
        String string = ((AbstractDebuggerInfo)debuggerInfo).getProcessName();
        this.setDisplayName(string);
        this.setName(string);
    }

    public String getState() {
        switch (this.debugger.getState()) {
            case 2: {
                return DebuggerNode.getLocalizedString("CTL_Starting");
            }
            case 3: {
                return DebuggerNode.getLocalizedString("CTL_Running");
            }
            case 4: {
                if (this.debugger.getLastAction() == 1) {
                    return DebuggerNode.getLocalizedString("CTL_Stopped_on_breakpoint");
                }
                return DebuggerNode.getLocalizedString("CTL_Stopped");
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference node;
        private CoreDebugger coreDebugger;
        private AbstractDebugger debugger;

        Listener(SessionNode sessionNode) {
            this.node = new WeakReference<SessionNode>(sessionNode);
            this.coreDebugger = sessionNode.getCoreDebugger();
            this.coreDebugger.addPropertyChangeListener(this);
            this.debugger = sessionNode.debugger;
            this.debugger.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "currentDebugger" || propertyChangeEvent.getPropertyName() == SessionNode.PROP_STATE) {
                SessionNode sessionNode = this.getSessionNode();
                if (sessionNode == null) {
                    return;
                }
                sessionNode.update();
            }
        }

        private SessionNode getSessionNode() {
            SessionNode sessionNode = (SessionNode)this.node.get();
            if (sessionNode == null) {
                this.destroy();
            }
            return sessionNode;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            this.coreDebugger.removePropertyChangeListener(this);
        }
    }
}

