/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.TopManager;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public final class SessionThreadRootNode
extends AbstractNode {
    static final long serialVersionUID = -4736310787523747464L;
    private static final String THREAD_GROUP_ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/AllInOne";

    public SessionThreadRootNode() {
        this(false);
    }

    public SessionThreadRootNode(boolean bl) {
        super((Children)new SessionRootChildren());
        String string = null;
        if (bl) {
            string = DebuggerNode.getLocalizedString("PROP_allinone_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_allinone_column_name"));
        } else {
            string = DebuggerNode.getLocalizedString("CTL_All_in_one_view");
        }
        this.setDisplayName(string);
        this.setName("SessionThreadRootNode");
        this.setIconBase(THREAD_GROUP_ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadsRootNode");
    }

    public Node.Handle getHandle() {
        return new SessionsHandle();
    }

    private static class SessionsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4935665488987259653L;

        private SessionsHandle() {
        }

        public Node getNode() {
            return new SessionThreadRootNode();
        }
    }

    private static final class SessionRootChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private CoreDebugger coreDebugger;
        private AbstractDebugger[] debuggers;

        private SessionRootChildren() {
        }

        protected Node[] createNodes(Object object) {
            ThreadsProducer threadsProducer = null;
            if (object instanceof ThreadsRoot) {
                threadsProducer = ((ThreadsRoot)object).getThreadsRoot();
            }
            Node node = null;
            if (threadsProducer != null) {
                node = DebuggerNode.createNode(threadsProducer, new Object[]{threadsProducer, object});
            }
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            try {
                this.coreDebugger = (EnterpriseDebugger)TopManager.getDefault().getDebugger();
            }
            catch (DebuggerNotFoundException debuggerNotFoundException) {
                // empty catch block
            }
            this.coreDebugger.addPropertyChangeListener(this);
            this.update();
        }

        protected void removeNotify() {
            this.coreDebugger.removePropertyChangeListener(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null) {
                return;
            }
            if (!propertyChangeEvent.getPropertyName().equals("debuggers")) {
                return;
            }
            this.update();
        }

        private void update() {
            Object[] objectArray = this.coreDebugger.getDebuggers();
            this.setKeys(objectArray);
        }
    }
}

