/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ThreadsRootNode
extends AbstractNode {
    static final long serialVersionUID = -8123352660663524178L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode = ThreadsRootNode.class$("org.netbeans.modules.debugger.support.nodes.ThreadsRootNode")) : class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode));
        }
        return bundle.getString(string);
    }

    public ThreadsRootNode() {
        this(false);
    }

    public ThreadsRootNode(boolean bl) {
        super((Children)new CallStackChildren());
        String string = null;
        if (bl) {
            string = DebuggerNode.getLocalizedString("PROP_threads_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_threads_column_name"));
        } else {
            string = ThreadsRootNode.getLocalizedString("CTL_ThreadRootNode");
        }
        this.setDisplayName(string);
        this.setName("ThreadsRootNode");
        this.setIconBase(ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadsRootNode");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CallStackListener
    implements PropertyChangeListener,
    ThreadListener {
        private WeakReference ch;
        private CoreDebugger debugger;
        private ThreadsProducer threadsProducer;

        CallStackListener(CallStackChildren callStackChildren) {
            this.ch = new WeakReference<CallStackChildren>(callStackChildren);
            this.debugger = callStackChildren.debugger;
            this.debugger.addPropertyChangeListener(this);
            this.refreshAll(callStackChildren);
        }

        private CallStackChildren getCh() {
            CallStackChildren callStackChildren = (CallStackChildren)((Object)this.ch.get());
            if (callStackChildren == null) {
                this.destroy();
                return null;
            }
            return callStackChildren;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.threadsProducer != null) {
                this.threadsProducer.removeThreadListener(this);
            }
            this.debugger = null;
            this.threadsProducer = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CallStackChildren callStackChildren = this.getCh();
            if (callStackChildren == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("currentDebugger")) {
                this.refreshAll(callStackChildren);
            }
        }

        public void threadCreated(AbstractThread abstractThread) {
            CallStackChildren callStackChildren = this.getCh();
            if (callStackChildren == null) {
                return;
            }
            callStackChildren.refreshKeys(this.threadsProducer.getThreads());
        }

        public void threadDeath(AbstractThread abstractThread) {
            CallStackChildren callStackChildren = this.getCh();
            if (callStackChildren == null) {
                return;
            }
            callStackChildren.refreshKeys(this.threadsProducer.getThreads());
        }

        void refreshAll(CallStackChildren callStackChildren) {
            AbstractDebugger abstractDebugger = this.debugger.getCurrentDebugger();
            if (abstractDebugger != null && abstractDebugger instanceof ThreadsRoot) {
                ThreadsProducer threadsProducer = ((ThreadsRoot)((Object)abstractDebugger)).getThreadsRoot();
                if (threadsProducer != this.threadsProducer || !threadsProducer.equals(this.threadsProducer)) {
                    if (this.threadsProducer != null) {
                        this.threadsProducer.removeThreadListener(this);
                    }
                    threadsProducer.addThreadListener(this);
                    this.threadsProducer = threadsProducer;
                }
                callStackChildren.refreshKeys(this.threadsProducer.getThreads());
            } else {
                if (this.threadsProducer != null) {
                    this.threadsProducer.removeThreadListener(this);
                }
                this.threadsProducer = null;
                callStackChildren.refreshKeys(new Object[0]);
            }
        }
    }

    private static final class CallStackChildren
    extends Children.Keys {
        private boolean init = false;
        private ArrayList keys = new ArrayList();
        private CoreDebugger debugger;

        private CallStackChildren() {
        }

        protected void addNotify() {
            this.init = true;
            try {
                this.debugger = (CoreDebugger)TopManager.getDefault().getDebugger();
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            new CallStackListener(this);
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, this.debugger.getCurrentDebugger(), Boolean.FALSE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void refreshKeys(Object[] objectArray) {
            if (!this.init) {
                return;
            }
            this.setKeys(objectArray);
        }
    }
}

