/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openide.TopManager;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static int processorCount = 0;
    private static long counter = 0L;
    final SortedSet waiting = new TreeSet(new TimeComp());
    private ProcessorThread thread;
    private String name;
    private static Debug debug;

    public RequestProcessor() {
    }

    public RequestProcessor(String string) {
        this.name = string;
    }

    protected void finalize() {
        this.stop();
    }

    public Task post(Runnable runnable) {
        return this.post(runnable, 0, 1);
    }

    public Task post(Runnable runnable, int n) {
        return this.post(runnable, n, 1);
    }

    public Task post(Runnable runnable, int n, int n2) {
        Task task;
        SortedSet sortedSet = this.waiting;
        synchronized (sortedSet) {
            task = new Task(runnable, n, n2);
            this.waiting.add(task.createHolder());
            this.checkTimerQueue();
        }
        if (debug != null && this == DEFAULT) {
            debug.notifyPost(task);
        }
        return task;
    }

    public Task create(Runnable runnable) {
        return new Task(runnable, 0L, 1);
    }

    public boolean isRequestProcessorThread() {
        return Thread.currentThread().equals(this.thread);
    }

    public void stop() {
        SortedSet sortedSet = this.waiting;
        synchronized (sortedSet) {
            if (this.thread != null) {
                this.thread.stopProcessing();
                this.thread = null;
            }
        }
    }

    public static Task postRequest(Runnable runnable) {
        return DEFAULT.post(runnable);
    }

    public static Task postRequest(Runnable runnable, int n) {
        return DEFAULT.post(runnable, n);
    }

    public static Task postRequest(Runnable runnable, int n, int n2) {
        return DEFAULT.post(runnable, n, n2);
    }

    public static Task createRequest(Runnable runnable) {
        return DEFAULT.create(runnable);
    }

    void checkTimerQueue() {
        if (this.thread == null) {
            this.thread = new ProcessorThread(this.name, this);
            this.thread.start();
        } else {
            if (this.waiting.size() == 0) {
                return;
            }
            this.waiting.notify();
        }
    }

    static ThreadGroup getTopLevelThreadGroup() {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup.getParent() != null) {
                    threadGroup = threadGroup.getParent();
                }
                return threadGroup;
            }
        };
        return (ThreadGroup)AccessController.doPrivileged(privilegedAction);
    }

    static {
        if (System.getProperty("netbeans.debug.requests") != null) {
            debug = new Debug();
        } else {
            TopManager topManager = TopManager.getDefault();
            if (topManager != null) {
                topManager.getWindowManager().getMainWindow().addKeyListener(new Debug());
            }
        }
    }

    private static class Debug
    implements KeyListener {
        private Debug() {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if ((keyEvent.getModifiers() & 2) != 0 && (keyEvent.getModifiers() & 8) != 0 && keyEvent.getKeyCode() == 121) {
                RequestProcessor.debug = this;
                this.printRequestProcessor();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void printRequestProcessor() {
            ProcessorThread processorThread = DEFAULT.thread;
            if (processorThread != null) {
                System.err.println("Content of " + processorThread + " sleep for: " + processorThread.sleep + " ago: " + (System.currentTimeMillis() - processorThread.at));
            } else {
                System.err.println("Content of " + processorThread);
            }
            LinkedList linkedList = new LinkedList(DEFAULT.waiting);
            this.print(linkedList);
            if (processorThread != null) {
                System.err.println("Pending requests");
                this.print(new LinkedList(processorThread.pending));
            }
        }

        private void print(Collection collection) {
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Holder holder = (Holder)iterator.next();
                Task task = holder.task;
                System.err.print("  ");
                System.err.print(++n);
                System.err.print(". ");
                System.err.println(task);
            }
        }

        public void notifySleep(int n) {
            ProcessorThread processorThread = DEFAULT.thread;
            System.err.println("Sleeping for " + n + " " + processorThread);
        }

        public void notifyPost(Task task) {
            ProcessorThread processorThread = DEFAULT.thread;
            System.err.println("Post: " + task + " to " + processorThread);
            this.printRequestProcessor();
        }

        public void notifyRun(Task task, Holder holder) {
            ProcessorThread processorThread = DEFAULT.thread;
            System.err.println("Run: " + task + " to " + processorThread + " because of holder: " + holder);
        }
    }

    private static final class PriorityComp
    implements Comparator {
        private PriorityComp() {
        }

        public int compare(Object object, Object object2) {
            Holder holder = (Holder)object;
            Holder holder2 = (Holder)object2;
            if (holder.priority == holder2.priority) {
                Task task = holder.task;
                Task task2 = holder2.task;
                if (holder.task == holder2.task) {
                    return 0;
                }
                long l = System.identityHashCode(task) - System.identityHashCode(task2);
                if (l == 0L) {
                    l = holder.task.id - holder2.task.id;
                }
                return l > 0L ? 1 : -1;
            }
            if (holder.priority < holder2.priority) {
                return 1;
            }
            return -1;
        }
    }

    private static final class TimeComp
    implements Comparator {
        private TimeComp() {
        }

        public int compare(Object object, Object object2) {
            Holder holder = (Holder)object;
            Holder holder2 = (Holder)object2;
            if (holder.time == holder2.time) {
                Task task = holder.task;
                Task task2 = holder2.task;
                if (holder.task == holder2.task) {
                    return 0;
                }
                long l = System.identityHashCode(task) - System.identityHashCode(task2);
                if (l == 0L) {
                    l = holder.task.id - holder2.task.id;
                }
                return l > 0L ? 1 : -1;
            }
            if (holder.time > holder2.time) {
                return 1;
            }
            return -1;
        }
    }

    private static final class ProcessorThread
    extends Thread {
        private TreeSet pending = new TreeSet(new PriorityComp());
        private Reference requestProcessor;
        private boolean stop;
        private int priority;
        Object sleep;
        long at;

        public ProcessorThread(String string, RequestProcessor requestProcessor) {
            super(RequestProcessor.getTopLevelThreadGroup(), string == null ? "Debugger Request Processor" : string);
            this.setDaemon(true);
            this.priority = this.getPriority();
            this.requestProcessor = new WeakReference<RequestProcessor>(requestProcessor);
        }

        public void stopProcessing() {
            this.stop = true;
            this.interrupt();
        }

        private long waitingToPending() {
            RequestProcessor requestProcessor = (RequestProcessor)this.requestProcessor.get();
            if (requestProcessor == null || requestProcessor.waiting.isEmpty()) {
                return 0L;
            }
            Iterator iterator = requestProcessor.waiting.iterator();
            while (iterator.hasNext()) {
                Holder holder = (Holder)iterator.next();
                if (holder.task == null) {
                    iterator.remove();
                    continue;
                }
                long l = holder.time - System.currentTimeMillis();
                if (l > 0L) {
                    return l;
                }
                iterator.remove();
                this.pending.add(holder);
            }
            return 0L;
        }

        private Object synch() {
            RequestProcessor requestProcessor = (RequestProcessor)this.requestProcessor.get();
            if (requestProcessor == null) {
                throw new IllegalStateException();
            }
            return requestProcessor.waiting;
        }

        public void run() {
            int n = this.getPriority();
            while (!this.stop) {
                Task task;
                Holder holder;
                Object object = this.synch();
                synchronized (object) {
                    Iterator iterator;
                    while (true) {
                        holder = null;
                        task = null;
                        iterator = null;
                        long l = this.waitingToPending();
                        if (!this.pending.isEmpty()) break;
                        try {
                            if (debug != null && this.requestProcessor.get() == DEFAULT) {
                                debug.notifySleep((int)l);
                            }
                            this.synch().wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.stop) {
                                return;
                            }
                            throw new InternalError();
                        }
                    }
                    iterator = this.pending.iterator();
                    holder = (Holder)iterator.next();
                    iterator.remove();
                    task = holder.task;
                    if (task == null) {
                        continue;
                    }
                    task.holder = null;
                }
                int n2 = task.getPriority();
                if (n != n2) {
                    n = n2;
                    this.setPriority(n);
                }
                try {
                    if (debug != null && this.requestProcessor.get() == DEFAULT) {
                        System.err.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
                        debug.notifyRun(task, holder);
                        holder.printStackTrace();
                    }
                    task.run();
                    if (debug == null || this.requestProcessor.get() != DEFAULT) continue;
                    System.err.println("Task finished: " + task);
                    debug.printRequestProcessor();
                    System.err.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    if (System.getProperty("netbeans.debug.exceptions") == null) continue;
                    System.err.println("Request processor thread exception!");
                    throwable.printStackTrace();
                }
            }
        }
    }

    public final class Task
    extends org.netbeans.modules.debugger.support.util.Task {
        long time;
        int priority;
        Holder holder;
        private long id;

        Task(Runnable runnable, long l, int n) {
            super(runnable);
            this.time = System.currentTimeMillis() + l;
            this.priority = n;
            this.id = counter++;
        }

        Holder createHolder() {
            if (this.holder != null) {
                this.holder.task = null;
            }
            this.holder = new Holder(this);
            return this.holder;
        }

        public int getDelay() {
            long l = this.time - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        public void schedule(int n) {
            SortedSet sortedSet = RequestProcessor.this.waiting;
            synchronized (sortedSet) {
                this.time = System.currentTimeMillis() + (long)n;
                RequestProcessor.this.waiting.add(this.createHolder());
                RequestProcessor.this.checkTimerQueue();
            }
        }

        public boolean cancel() {
            SortedSet sortedSet = RequestProcessor.this.waiting;
            synchronized (sortedSet) {
                if (this.holder != null) {
                    this.holder.task = null;
                    this.holder = null;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int n) {
            if (this.priority != n) {
                if (n < 1) {
                    n = 1;
                }
                if (n > 10) {
                    n = 10;
                }
                SortedSet sortedSet = RequestProcessor.this.waiting;
                synchronized (sortedSet) {
                    this.priority = n;
                    if (this.holder != null) {
                        RequestProcessor.this.waiting.add(this.createHolder());
                        RequestProcessor.this.checkTimerQueue();
                    }
                }
            }
        }

        void waitFinishedImpl() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl = false;
                SortedSet sortedSet = RequestProcessor.this.waiting;
                synchronized (sortedSet) {
                    if (this.holder != null) {
                        this.holder.task = null;
                        this.holder = null;
                        bl = true;
                    }
                }
                if (bl) {
                    this.run();
                }
            } else {
                super.waitFinishedImpl();
            }
        }

        public String toString() {
            return super.toString() + " [" + (this.time - System.currentTimeMillis()) + ", " + this.priority + ']';
        }
    }

    private final class Holder {
        public Task task;
        public int priority;
        public long time;

        public void printStackTrace() {
        }

        public Holder(Task task) {
            this.task = task;
            this.priority = task.priority;
            this.time = task.time;
        }

        public String toString() {
            Task task = this.task;
            return task == null ? "null" : task.toString();
        }
    }
}

