/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.xml.core.lib.Convertors;
import org.netbeans.modules.xml.spi.model.GrammarQuery;
import org.netbeans.modules.xml.spi.model.GrammarResult;
import org.netbeans.modules.xml.spi.model.HintContext;
import org.netbeans.modules.xml.text.completion.AttributeResultItem;
import org.netbeans.modules.xml.text.completion.DefaultContext;
import org.netbeans.modules.xml.text.completion.ElementResultItem;
import org.netbeans.modules.xml.text.completion.EmptyQuery;
import org.netbeans.modules.xml.text.completion.EntityRefResultItem;
import org.netbeans.modules.xml.text.completion.Util;
import org.netbeans.modules.xml.text.completion.ValueResultItem;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.modules.xml.text.completion.dtd.DTDGrammar;
import org.netbeans.modules.xml.text.completion.dtd.DTDParser;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.openide.TopManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLCompletionQuery
implements CompletionQuery,
XMLTokenIDs {
    static final String DOCUMENT_GRAMMAR_BINDING_PROP = "doc-bind-query";
    private DefaultContext ctx = new DefaultContext();
    private BaseDocument doc;
    private XMLSyntaxSupport sup;
    private boolean boundary;
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport;
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$syntax$dom$StartTag;
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag;

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Called from non-AWT thread: " + Thread.currentThread().getName());
        }
        this.doc = (BaseDocument)component.getDocument();
        this.sup = (XMLSyntaxSupport)support.get(class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport == null ? (class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport")) : class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport);
        if (this.sup == null) {
            return null;
        }
        try {
            TokenItem token = null;
            token = this.sup.getPreviousToken(offset);
            if (token == null) {
                return null;
            }
            this.boundary = token.getOffset() + token.getImage().length() == offset;
            int itemOffset = token.getOffset();
            String preText = "";
            int erase = 0;
            int eraseRight = 0;
            int id = token.getTokenID().getNumericID();
            if (!this.boundary) {
                preText = token.getImage().substring(0, offset - token.getOffset());
                if ("".equals(preText)) {
                    throw new IllegalStateException("Cannot get token prefix at " + offset);
                }
                switch (id) {
                    case 4: 
                    case 5: 
                    case 11: {
                        int i = token.getImage().length();
                        int tail = i - (offset - itemOffset);
                        offset += tail;
                        eraseRight = tail;
                    }
                }
            } else {
                switch (id) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 11: 
                    case 15: {
                        preText = token.getImage();
                    }
                }
            }
            switch (id) {
                case 4: 
                case 11: {
                    erase = preText.length() - 1 + eraseRight;
                    break;
                }
                case 5: {
                    erase = preText.length() + eraseRight;
                }
            }
            SyntaxElement element = this.sup.getElementChain(offset);
            if (element == null) {
                throw new IllegalStateException("There exists a token therefore a syntax element must exist at " + offset + ", too.");
            }
            if (element instanceof SyntaxNode) {
                List list = this.query((SyntaxNode)element, token, preText);
                if (list != null && !list.isEmpty()) {
                    String debugMsg = Boolean.getBoolean("netbeans.debug.xml") ? " " + offset + "-" + erase : "";
                    String title = Util.THIS.getString("MSG_result", new Object[]{preText}) + debugMsg;
                    return new CompletionQuery.DefaultResult(component, title, list, offset - erase, erase);
                }
                if (preText.endsWith("</") && token.getTokenID() == XMLTokenIDs.TEXT && (list = XMLCompletionQuery.findStartTag((SyntaxNode)element)) != null && list.size() == 1) {
                    ElementResultItem item = (ElementResultItem)list.get(0);
                    item.substituteText(component, offset, 0, 0);
                }
                return null;
            }
            if (token.getTokenID() == XMLTokenIDs.PI_CONTENT && preText.endsWith("encoding=")) {
                ArrayList<XMLResultItem> encodings = new ArrayList<XMLResultItem>(2);
                encodings.add(new XMLResultItem("\"UTF-8\""));
                encodings.add(new XMLResultItem("\"UTF-16\""));
                return new CompletionQuery.DefaultResult(component, Util.THIS.getString("MSG_encoding_comp"), encodings, offset, 0);
            }
            return null;
        }
        catch (BadLocationException e) {
            Util.THIS.debug(e);
            return null;
        }
    }

    private List query(SyntaxNode element, TokenItem token, String text) {
        int id = token.getTokenID().getNumericID();
        switch (id) {
            case 1: {
                if (text.endsWith("<")) {
                    this.ctx.init(element, "");
                    return this.queryElements();
                }
                if (text.startsWith("&")) {
                    this.ctx.init(element, text.substring(1));
                    return this.queryEntities();
                }
                this.ctx.init(element, text);
                return this.queryValues();
            }
            case 4: {
                if ((class$org$netbeans$modules$xml$text$syntax$dom$StartTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$StartTag = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.dom.StartTag")) : class$org$netbeans$modules$xml$text$syntax$dom$StartTag).equals(element.getClass()) || (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.dom.EmptyTag")) : class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag).equals(element.getClass())) {
                    if (text.equals("")) {
                        if (token.getImage().endsWith(">")) {
                            this.ctx.init(element, text);
                            return this.queryValues();
                        }
                        this.ctx.init(element, text);
                        return this.queryElements();
                    }
                    if (text.endsWith("/>")) {
                        this.ctx.init(element, "");
                        return this.queryValues();
                    }
                    if (text.endsWith(">")) {
                        this.ctx.init(element, "");
                        return this.queryValues();
                    }
                    if (text.startsWith("</")) {
                        this.ctx.init(element, text.substring(2));
                        return this.queryElements();
                    }
                    if (!text.startsWith("<")) break;
                    this.ctx.init(element, text.substring(1));
                    return this.queryElements();
                }
                if (!"".equals(text) || !token.getImage().endsWith(">")) break;
                this.ctx.init(element, text);
                return this.queryValues();
            }
            case 7: {
                if (text.endsWith("&")) {
                    this.ctx.init(element, "");
                    return this.queryEntities();
                }
                if ("".equals(text)) {
                    String image = token.getImage();
                    char ch = image.charAt(image.length() - 1);
                    if (ch == '\'' || ch == '\"') {
                        if (image.charAt(0) == ch && image.length() > 1) {
                            return null;
                        }
                        boolean closing = false;
                        TokenItem prev = token.getPrevious();
                        while (prev != null) {
                            int tid = prev.getTokenID().getNumericID();
                            if (tid == 7) {
                                closing = true;
                                break;
                            }
                            if (tid != 11) break;
                            prev = prev.getPrevious();
                        }
                        if (closing) break;
                        this.ctx.init(element, text);
                        return this.queryValues();
                    }
                    this.ctx.init(element, text);
                    return this.queryValues();
                }
                this.ctx.init(element, text);
                return this.queryValues();
            }
            case 6: {
                if (!"".equals(text) || !"=".equals(token.getImage())) break;
                this.ctx.init(element, "");
                return this.queryValues();
            }
            case 2: {
                if ((class$org$netbeans$modules$xml$text$syntax$dom$StartTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$StartTag = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.dom.StartTag")) : class$org$netbeans$modules$xml$text$syntax$dom$StartTag).equals(element.getClass()) || (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.dom.EmptyTag")) : class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag).equals(element.getClass())) {
                    this.ctx.initVirtualAttr((Element)((Object)element), "");
                    return this.queryAttributes();
                }
                return null;
            }
            case 5: {
                if (!(class$org$netbeans$modules$xml$text$syntax$dom$StartTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$StartTag = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.dom.StartTag")) : class$org$netbeans$modules$xml$text$syntax$dom$StartTag).equals(element.getClass()) && !(class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.dom.EmptyTag")) : class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag).equals(element.getClass())) break;
                this.ctx.initVirtualAttr((Element)((Object)element), text);
                return this.queryAttributes();
            }
            case 11: {
                if (text.startsWith("&#")) {
                    return null;
                }
                if (text.endsWith(";")) {
                    this.ctx.init(element, "");
                    return this.queryValues();
                }
                if (text.startsWith("&")) {
                    this.ctx.init(element, text.substring(1));
                    return this.queryEntities();
                }
                if (!"".equals(text) || !token.getImage().endsWith(";")) break;
                this.ctx.init(element, text);
                return this.queryValues();
            }
        }
        return null;
    }

    private List queryEntities() {
        Enumeration res = this.getPerformer().queryEntities(this.ctx.getCurrentPrefix());
        return this.translateEntityRefs(res);
    }

    private List queryElements() {
        Enumeration res = this.getPerformer().queryElements((HintContext)this.ctx);
        return this.translateElements(res);
    }

    private List queryAttributes() {
        Enumeration res = this.getPerformer().queryAttributes((HintContext)this.ctx);
        return this.translateAttributes(res);
    }

    private List queryValues() {
        Enumeration res = this.getPerformer().queryValues((HintContext)this.ctx);
        return this.translateValues(res);
    }

    private List queryNotations() {
        Enumeration res = this.getPerformer().queryNotations(this.ctx.getCurrentPrefix());
        return null;
    }

    private List translateEntityRefs(Enumeration refs) {
        ArrayList<EntityRefResultItem> result = new ArrayList<EntityRefResultItem>(133);
        while (refs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)refs.nextElement();
            EntityRefResultItem ref = new EntityRefResultItem(next);
            result.add(ref);
        }
        return result;
    }

    private List translateElements(Enumeration els) {
        ArrayList<ElementResultItem> result = new ArrayList<ElementResultItem>(13);
        while (els.hasMoreElements()) {
            GrammarResult next = (GrammarResult)els.nextElement();
            ElementResultItem ei = new ElementResultItem(next);
            result.add(ei);
        }
        return result;
    }

    private List translateAttributes(Enumeration attrs) {
        ArrayList<AttributeResultItem> result = new ArrayList<AttributeResultItem>(13);
        while (attrs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)attrs.nextElement();
            AttributeResultItem attr = new AttributeResultItem(next, !this.boundary);
            result.add(attr);
        }
        return result;
    }

    private List translateValues(Enumeration values) {
        ArrayList<ValueResultItem> result = new ArrayList<ValueResultItem>(3);
        while (values.hasMoreElements()) {
            GrammarResult next = (GrammarResult)values.nextElement();
            ValueResultItem val = new ValueResultItem(next);
            result.add(val);
        }
        return result;
    }

    private static List findStartTag(SyntaxNode text) {
        Node parent;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("XMLCompletionQuery.findStartTag: text=" + text);
        }
        if ((parent = text.getParentNode()) == null) {
            return Collections.EMPTY_LIST;
        }
        String name = parent.getNodeName();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    name=" + name);
        }
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ElementResultItem res = new ElementResultItem(name);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    result=" + res);
        }
        ArrayList<ElementResultItem> list = new ArrayList<ElementResultItem>(1);
        list.add(res);
        return list;
    }

    protected GrammarQuery getPerformer() {
        GrammarCache desc = (GrammarCache)this.doc.getProperty(DOCUMENT_GRAMMAR_BINDING_PROP);
        if (desc == null) {
            desc = new GrammarCache();
            desc.attach((Document)this.doc, this.sup);
            this.doc.putProperty(DOCUMENT_GRAMMAR_BINDING_PROP, desc);
        }
        return desc.getGrammar(300);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GrammarCache {
        private long timestamp = System.currentTimeMillis();
        private int delay = 0;
        private int state = 3;
        static final int VALID = 1;
        static final int LOADING = 2;
        static final int INVALID = 3;
        private GrammarQuery grammar;
        private static final RequestProcessor.Task EMPTY_LOADER = RequestProcessor.createRequest((Runnable)Task.EMPTY);
        private RequestProcessor.Task loader = EMPTY_LOADER;
        private Document doc;

        GrammarCache() {
        }

        public synchronized GrammarQuery getGrammar(int timeout) {
            switch (this.state) {
                case 1: {
                    return this.grammar;
                }
                case 3: {
                    this.state = 2;
                    this.loadGrammar();
                }
                case 2: {
                    this.waitLoaded(timeout);
                    if (this.grammar == null) break;
                    return this.grammar;
                }
            }
            return EmptyQuery.INSTANCE;
        }

        public void attach(Document doc, XMLSyntaxSupport sup) {
            this.doc = doc;
            doc.addDocumentListener(new DocumentListener(this, sup){
                private final /* synthetic */ XMLSyntaxSupport val$sup;
                private final /* synthetic */ GrammarCache this$0;
                {
                    this.this$0 = this$0;
                    this.val$sup = val$sup;
                }

                public void insertUpdate(DocumentEvent e) {
                    try {
                        SyntaxElement el = this.val$sup.getElementChain(e.getOffset() + 1);
                        if (this.isDoctype(el)) {
                            this.this$0.invalidateGrammar();
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                    try {
                        if (e.getOffset() >= e.getDocument().getLength()) {
                            return;
                        }
                        SyntaxElement el = this.val$sup.getElementChain(e.getOffset() + 1);
                        if (this.isDoctype(el)) {
                            this.this$0.invalidateGrammar();
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }

                public void changedUpdate(DocumentEvent e) {
                }

                private boolean isDoctype(SyntaxElement el) {
                    return el instanceof SyntaxElement.Declaration;
                }
            });
        }

        public synchronized void invalidateGrammar() {
            this.loader.cancel();
            this.loader = EMPTY_LOADER;
            if (this.state == 2 || this.state == 1) {
                this.notifyProgress((Task)this.loader, Util.THIS.getString("MSG_loading_cancel"));
            }
            this.delay = System.currentTimeMillis() - this.timestamp < 1000L ? 500 : 0;
            this.timestamp = System.currentTimeMillis();
            this.state = 3;
        }

        private synchronized void grammarLoaded(Task loader, GrammarQuery grammar) {
            try {
                if (this.loader != loader) {
                    Object var5_3 = null;
                    this.notifyAll();
                    return;
                }
                String status = grammar != null ? Util.THIS.getString("MSG_loading_done") : Util.THIS.getString("MSG_loading_failed");
                this.grammar = grammar == null ? EmptyQuery.INSTANCE : grammar;
                this.state = 1;
                this.notifyProgress(loader, status);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.notifyAll();
                throw throwable;
            }
            Object var5_4 = null;
            this.notifyAll();
        }

        private void notifyProgress(Task loader, String msg) {
            if (this.loader != loader) {
                return;
            }
            TopManager.getDefault().setStatusText(msg);
        }

        private void loadGrammar() {
            RequestProcessor rp = new RequestProcessor("tmp/XML grammar fetching");
            class LoaderTask
            extends Task {
                private RequestProcessor.Task self;
                private final /* synthetic */ GrammarCache this$0;

                LoaderTask(GrammarCache this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    DTDGrammar loaded = null;
                    try {
                        String status = Util.THIS.getString("MSG_loading");
                        GrammarCache.access$000(this.this$0, (Task)this.self, status);
                        InputSource in = Convertors.documentToInputSource((Document)GrammarCache.access$100(this.this$0));
                        loaded = new DTDParser().parse(in);
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        GrammarCache.access$200(this.this$0, (Task)this.self, loaded);
                        this.notifyFinished();
                        throw throwable;
                    }
                    GrammarCache.access$200(this.this$0, (Task)this.self, loaded);
                    this.notifyFinished();
                }
            }
            LoaderTask task = new LoaderTask(this);
            this.loader = rp.create((Runnable)((Object)task));
            task.self = this.loader;
            this.loader.schedule(this.delay);
        }

        private void waitLoaded(int timeout) {
            try {
                if (this.state == 2) {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        static /* synthetic */ void access$000(GrammarCache x0, Task x1, String x2) {
            x0.notifyProgress(x1, x2);
        }

        static /* synthetic */ Document access$100(GrammarCache x0) {
            return x0.doc;
        }

        static /* synthetic */ void access$200(GrammarCache x0, Task x1, GrammarQuery x2) {
            x0.grammarLoaded(x1, x2);
        }
    }
}

