/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion.dtd;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.modules.xml.spi.model.GrammarQuery;
import org.netbeans.modules.xml.spi.model.GrammarResult;
import org.netbeans.modules.xml.spi.model.HintContext;
import org.netbeans.modules.xml.text.completion.dtd.ContentModel;
import org.netbeans.modules.xml.text.syntax.dom.AbstractNode;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class DTDGrammar
implements GrammarQuery {
    Map elementDecls;
    Map attrDecls;
    Map contentModels;
    Set entities;
    Set notations;

    DTDGrammar(Map elementDecls, Map contentModels, Map attrDecls, Set entities, Set notations) {
        this.elementDecls = elementDecls;
        this.attrDecls = attrDecls;
        this.entities = entities;
        this.notations = notations;
        this.contentModels = contentModels;
    }

    public Enumeration queryEntities(String prefix) {
        if (this.entities == null) {
            return EmptyEnumeration.EMPTY;
        }
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = this.entities.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.put((Object)new MyEntityReference(next));
        }
        if ("lt".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("lt"));
        }
        if ("gt".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("gt"));
        }
        if ("apos".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("apos"));
        }
        if ("quot".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("quot"));
        }
        if ("amp".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("amp"));
        }
        return list;
    }

    public Enumeration queryAttributes(HintContext ctx) {
        if (this.attrDecls == null) {
            return EmptyEnumeration.EMPTY;
        }
        Element el = ((Attr)ctx).getOwnerElement();
        NamedNodeMap existingAttributes = el.getAttributes();
        if (el == null) {
            return EmptyEnumeration.EMPTY;
        }
        Set possibleAttributes = (Set)this.attrDecls.get(el.getTagName());
        if (possibleAttributes == null) {
            return EmptyEnumeration.EMPTY;
        }
        String prefix = ctx.getCurrentPrefix();
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = possibleAttributes.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix) || existingAttributes.getNamedItem(next) != null) continue;
            list.put((Object)new MyAttr(next));
        }
        return list;
    }

    public Enumeration queryElements(HintContext ctx) {
        Set elements;
        if (this.elementDecls == null) {
            return EmptyEnumeration.EMPTY;
        }
        Node node = ctx.getParentNode();
        if (node instanceof Element) {
            Element el = (Element)node;
            if (el == null) {
                return EmptyEnumeration.EMPTY;
            }
            ContentModel model = (ContentModel)this.contentModels.get(el.getTagName());
            if (model != null) {
                Enumeration en = model.whatCanFollow(new PreviousEnumeration(el, (Node)ctx));
                if (en == null) {
                    return EmptyEnumeration.EMPTY;
                }
                return en;
            }
            elements = (Set)this.elementDecls.get(el.getTagName());
        } else if (node instanceof Document) {
            elements = this.elementDecls.keySet();
        } else {
            return EmptyEnumeration.EMPTY;
        }
        if (elements == null) {
            return EmptyEnumeration.EMPTY;
        }
        String prefix = ctx.getCurrentPrefix();
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.put((Object)new MyElement(next));
        }
        return list;
    }

    public Enumeration queryNotations(String prefix) {
        if (this.notations == null) {
            return EmptyEnumeration.EMPTY;
        }
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = this.notations.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.put((Object)new MyNotation(next));
        }
        return list;
    }

    public Enumeration queryValues(HintContext ctx) {
        return EmptyEnumeration.EMPTY;
    }

    public String toString() {
        return "DTDGrammar:\nelements: " + this.elementDecls.keySet() + "\nattributes:" + this.attrDecls.keySet() + "";
    }

    private static class MyNotation
    extends AbstractResultNode
    implements Notation {
        private String name;

        MyNotation(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 12;
        }

        public String getNodeName() {
            return this.name;
        }
    }

    private static class MyAttr
    extends AbstractResultNode
    implements Attr {
        private String name;

        MyAttr(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return null;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;

        MyElement(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static class MyEntityReference
    extends AbstractResultNode
    implements EntityReference {
        private String name;

        MyEntityReference(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 5;
        }

        public String getNodeName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return null;
        }

        public String getDescription() {
            return this.getNodeName() + " desc";
        }

        public String getText() {
            return this.getNodeName();
        }

        public String getDisplayName() {
            return this.getNodeName() + " disp";
        }
    }

    private static class PreviousEnumeration
    implements Enumeration {
        private final Node parent;
        private final Node last;
        private Node next;

        PreviousEnumeration(Node parent, Node last) {
            this.parent = parent;
            this.last = last;
            this.next = parent.getFirstChild();
            while (this.next != null) {
                if (this.next.getNodeType() == 1) break;
                this.next = this.next.getNextSibling();
            }
            if (this.next == last) {
                this.next = null;
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        /*
         * Unable to fully structure code
         */
        public Object nextElement() {
            block5: {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                try {
                    var1_1 = this.next;
                    var3_2 = null;
                    ** while (this.next != null)
                }
                catch (Throwable var2_4) {
                    var3_3 = null;
                    ** while (this.next != null)
                }
lbl-1000:
                // 1 sources

                {
                    this.next = this.next.getNextSibling();
                    if (this.next.getNodeType() == 1) break;
                    continue;
                }
lbl11:
                // 2 sources

                if (this.next != this.last) ** GOTO lbl13
                this.next = null;
lbl13:
                // 2 sources

                return var1_1;
lbl-1000:
                // 1 sources

                {
                    this.next = this.next.getNextSibling();
                    if (this.next.getNodeType() == 1) break;
                    continue;
                }
lbl21:
                // 2 sources

                if (this.next != this.last) break block5;
                this.next = null;
            }
            throw var2_4;
        }
    }
}

