/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion.dtd;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.text.completion.dtd.DTDGrammar;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DTDParser {
    static final String SAX_PROPERTY = "http://xml.org/sax/properties/";
    static final String DECL_HANDLER = "declaration-handler";

    public DTDGrammar parse(InputSource in) {
        Handler handler = new Handler();
        try {
            EntityResolver res;
            XMLReader parser = XMLUtil.createXMLReader((boolean)true);
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.setDTDHandler(handler);
            UserCatalog catalog = UserCatalog.getDefault();
            EntityResolver entityResolver = res = catalog == null ? null : catalog.getEntityResolver();
            if (res != null) {
                parser.setEntityResolver(res);
            }
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            parser.parse(in);
            throw new IllegalStateException("How we can get here?");
        }
        catch (Stop stop) {
            return handler.getDTDGrammar();
        }
        catch (SAXException ex) {
            if (Boolean.getBoolean("netbeans.debug.xml") || Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex.printStackTrace();
                if (ex.getException() instanceof RuntimeException) {
                    ex.getException().printStackTrace();
                }
            }
            return handler.getDTDGrammar();
        }
        catch (IOException ex) {
            if (Boolean.getBoolean("netbeans.debug.xml")) {
                ex.printStackTrace();
            }
            return handler.getDTDGrammar();
        }
    }

    private class Stop
    extends SAXException {
        private static final long serialVersionUID = -6466279601744402792L;

        Stop() {
            super("STOP");
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class Handler
    extends DefaultHandler
    implements DeclHandler {
        private Map attrs = new HashMap();
        private Map elements = new HashMap();
        private Map models = new HashMap();
        private Set notations = new TreeSet();
        private Set entities = new TreeSet();
        private Set anys = new HashSet();
        private DTDGrammar dtd = new DTDGrammar(this.elements, this.models, this.attrs, this.entities, this.notations);

        Handler() {
        }

        DTDGrammar getDTDGrammar() {
            Iterator it = this.anys.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                this.elements.put(name, this.elements.keySet());
            }
            return this.dtd;
        }

        public void elementDecl(String name, String model) throws SAXException {
            if ("ANY".equals(model)) {
                this.anys.add(name);
                this.elements.put(name, Collections.EMPTY_SET);
                return;
            }
            if ("EMPTY".equals(model)) {
                this.elements.put(name, Collections.EMPTY_SET);
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(model, " \t\n|,()?+*");
            TreeSet<String> modelset = new TreeSet<String>();
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken().trim();
                if ("#PCDATA".equals(next)) continue;
                modelset.add(next);
            }
            this.elements.put(name, modelset);
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            if (name.startsWith("%")) {
                return;
            }
            this.entities.add(name);
        }

        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
            TreeSet<String> set = (TreeSet<String>)this.attrs.get(eName);
            if (set == null) {
                set = new TreeSet<String>();
                this.attrs.put(eName, set);
            }
            set.add(aName);
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
            if (name.startsWith("%")) {
                return;
            }
            this.entities.add(name);
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.notations.add(name);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            throw new Stop();
        }
    }
}

