/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.CommentImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.ProcessingInstructionImpl;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.modules.xml.text.syntax.dom.TextImpl;
import org.openide.TopManager;

public class XMLSyntaxSupport
extends ExtSyntaxSupport
implements XMLTokenIDs {
    private Reference reference = new SoftReference<Object>(null);
    private String systemId = null;
    private String publicId = null;

    public XMLSyntaxSupport(BaseDocument doc) {
        super(doc);
    }

    public TokenItem getPreviousToken(int offset) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        TokenItem item = null;
        int step = 11;
        int len = this.getDocument().getLength();
        if (offset > len) {
            throw new BadLocationException("Offset " + offset + " cannot be higher that document length " + len + " .", offset);
        }
        int from = Math.min(len, offset);
        int to = Math.min(len, offset);
        while (item == null) {
            if ((from = Math.max(from - step, 0)) == 0) {
                to = Math.min(to + step, len);
            }
            item = this.getTokenChain(from, to);
            if (from != 0 || to != len || item != null) continue;
            throw new IllegalStateException("Token at " + offset + " cannot be located!\nInspected range:[" + from + ", " + to + "].");
        }
        while (item.getOffset() + item.getImage().length() < offset) {
            TokenItem next = item.getNext();
            if (next == null) {
                if (item.getOffset() + item.getImage().length() >= len) {
                    return item;
                }
                throw new IllegalStateException("Token at " + offset + " cannot be located!\nPrevious token: " + item);
            }
            item = next;
        }
        return item;
    }

    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        TokenItem item = this.getPreviousToken(offset);
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        TokenItem first = item;
        if (id == XMLTokenIDs.CHARACTER) {
            while (id == XMLTokenIDs.CHARACTER) {
                if ((item = item.getPrevious()) == null) break;
                id = item.getTokenID();
                first = item;
            }
            if (id != XMLTokenIDs.VALUE && id != XMLTokenIDs.TEXT && id != XMLTokenIDs.CDATA_SECTION) {
                return this.createElement(first);
            }
        }
        if (id == XMLTokenIDs.WS || id == XMLTokenIDs.ARGUMENT || id == XMLTokenIDs.OPERATOR || id == XMLTokenIDs.VALUE) {
            while (!((id = (item = item.getPrevious()).getTokenID()) == XMLTokenIDs.TAG || id == XMLTokenIDs.DECLARATION && item.getImage().trim().length() > 0 || this.isInPI(id, false))) {
            }
        }
        if (id == XMLTokenIDs.TEXT || id == XMLTokenIDs.CDATA_SECTION) {
            while (id == XMLTokenIDs.TEXT || id == XMLTokenIDs.CHARACTER || id == XMLTokenIDs.CDATA_SECTION) {
                first = item;
                if ((item = item.getPrevious()) == null) break;
                id = item.getTokenID();
            }
            return this.createElement(first);
        }
        if (id == XMLTokenIDs.TAG) {
            if (item.getImage().startsWith("<")) {
                return this.createElement(item);
            }
            while ((id = (item = item.getPrevious()).getTokenID()) != XMLTokenIDs.TAG) {
            }
            return this.createElement(item);
        }
        if (id == XMLTokenIDs.ERROR) {
            return new SyntaxElement.Error(this, item, XMLSyntaxSupport.getTokenEnd(item));
        }
        if (id == XMLTokenIDs.BLOCK_COMMENT) {
            while (id == XMLTokenIDs.BLOCK_COMMENT && !item.getImage().startsWith("<!--")) {
                first = item;
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.createElement(first);
        }
        if (id == XMLTokenIDs.DECLARATION) {
            while (true) {
                first = item;
                if (id == XMLTokenIDs.DECLARATION && item.getImage().startsWith("<!") || (item = item.getPrevious()) == null) break;
                id = item.getTokenID();
            }
            return this.createElement(first);
        }
        if (this.isInPI(id, false)) {
            while ((id = (item = item.getPrevious()).getTokenID()) != XMLTokenIDs.PI_START) {
            }
        }
        if (id == XMLTokenIDs.PI_START) {
            return this.createElement(item);
        }
        return null;
    }

    private boolean isInPI(TokenID id, boolean includeWS) {
        return id == XMLTokenIDs.PI_TARGET || id == XMLTokenIDs.PI_CONTENT || id == XMLTokenIDs.PI_END || includeWS && id == XMLTokenIDs.WS;
    }

    public SyntaxElement createElement(TokenItem item) throws BadLocationException {
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        TokenItem first = item;
        int lastOffset = XMLSyntaxSupport.getTokenEnd(item);
        switch (id.getNumericID()) {
            case 8: {
                while (id == XMLTokenIDs.BLOCK_COMMENT) {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                return new CommentImpl(this, first, lastOffset);
            }
            case 10: {
                while (id == XMLTokenIDs.DECLARATION || id == XMLTokenIDs.VALUE) {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                return new SyntaxElement.Declaration(this, first, lastOffset);
            }
            case 3: {
                return new SyntaxElement.Error(this, first, lastOffset);
            }
            case 1: 
            case 11: 
            case 17: {
                while (id == XMLTokenIDs.TEXT || id == XMLTokenIDs.CHARACTER || id == XMLTokenIDs.CDATA_SECTION) {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                return new TextImpl(this, first, lastOffset);
            }
            case 4: {
                String text = item.getImage();
                if (text.startsWith("</")) {
                    String name = text.substring(2);
                    id = (item = item.getNext()) == null ? null : item.getTokenID();
                    while (id == XMLTokenIDs.WS) {
                        lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                        TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
                    }
                    if (id == XMLTokenIDs.TAG && item.getImage().equals(">")) {
                        return new EndTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name);
                    }
                    return new EndTag(this, first, lastOffset, name);
                }
                String name = text.substring(1);
                ArrayList<String> attrs = new ArrayList<String>();
                id = (item = item.getNext()) == null ? null : item.getTokenID();
                while (id == XMLTokenIDs.WS || id == XMLTokenIDs.ARGUMENT || id == XMLTokenIDs.OPERATOR || id == XMLTokenIDs.VALUE || id == XMLTokenIDs.CHARACTER) {
                    if (id == XMLTokenIDs.ARGUMENT) {
                        attrs.add(item.getImage());
                    }
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                    if ((item = item.getNext()) == null) break;
                    id = item.getTokenID();
                }
                if (id == XMLTokenIDs.TAG && (item.getImage().equals("/>") || item.getImage().equals(">") || item.getImage().equals("?>"))) {
                    if (item.getImage().equals("/>")) {
                        return new EmptyTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name, attrs);
                    }
                    if (item.getImage().equals("?>")) {
                        return new EmptyTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name, attrs);
                    }
                    return new StartTag(this, first, XMLSyntaxSupport.getTokenEnd(item), name, attrs);
                }
                return new StartTag(this, first, lastOffset, name, attrs);
            }
            case 13: {
                do {
                    lastOffset = XMLSyntaxSupport.getTokenEnd(item);
                } while ((item = item.getNext()) != null && this.isInPI(id = item.getTokenID(), true));
                return new ProcessingInstructionImpl(this, first, lastOffset);
            }
        }
        throw new BadLocationException("Cannot create SyntaxElement at " + item, item.getOffset());
    }

    public SyntaxElement.Declaration getDeclarationElement() {
        int offset = 5;
        SyntaxElement elem = null;
        try {
            while (!((elem = this.getElementChain(offset)) instanceof SyntaxElement.Declaration) && elem != null) {
                offset += elem.getElementLength() + 1;
            }
        }
        catch (BadLocationException ble) {
            TopManager.getDefault().notifyException((Throwable)ble);
        }
        return elem != null ? (SyntaxElement.Declaration)elem : null;
    }

    public String getEndTag(int offset) throws BadLocationException {
        SyntaxElement elem = this.getElementChain(offset);
        if (elem != null) {
            elem = elem.getPrevious();
        } else if (offset > 0) {
            elem = this.getElementChain(offset - 1);
        } else {
            return "";
        }
        int counter = 0;
        while (elem != null) {
            block9: {
                block11: {
                    block10: {
                        if (elem instanceof EmptyTag) break block9;
                        if (!(elem instanceof StartTag)) break block10;
                        ++counter;
                        break block11;
                    }
                    if (!(elem instanceof EndTag)) break block9;
                    --counter;
                }
                if (counter == 1) {
                    String name = ((StartTag)elem).getTagName();
                    return name;
                }
            }
            elem = elem.getPrevious();
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public List getPreviousLevelTags(int offset) throws BadLocationException {
        block12: {
            block11: {
                result = new ArrayList<String>();
                stack = new Stack<String>();
                children = new Vector<String>();
                elem = this.getElementChain(offset);
                if (elem == null) break block11;
                elem = elem.getPrevious();
                ** GOTO lbl43
            }
            if (offset <= 0) break block12;
            elem = this.getElementChain(offset - 1);
            if (true) ** GOTO lbl43
        }
        return result;
        do {
            if (elem instanceof EndTag) {
                stack.push(((EndTag)elem).getTagName());
            } else if (elem instanceof EmptyTag) {
                if (stack.size() == 0) {
                    children.add(((EmptyTag)elem).getTagName());
                }
            } else if (elem instanceof Tag) {
                name = ((Tag)elem).getTagName();
                if (stack.empty()) {
                    result.add(name);
                    k = children.size();
                    while (k > 0) {
                        result.add((String)children.get(k - 1));
                        --k;
                    }
                    return result;
                }
                if (stack.peek().equals(name)) {
                    if (stack.size() == 1) {
                        children.add(name);
                    }
                    stack.pop();
                }
            }
            elem = elem.getPrevious();
lbl43:
            // 3 sources

        } while (elem != null);
        result.clear();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List getFollowingLevelTags(int offset) throws BadLocationException {
        Stack<String> stack = new Stack<String>();
        Vector<String> children = new Vector<String>();
        SyntaxElement elem = this.getElementChain(offset);
        if (elem != null) {
            elem = elem.getNext();
        } else {
            if (offset <= 0) {
                return new ArrayList();
            }
            elem = this.getElementChain(offset - 1);
        }
        while (elem != null) {
            if (elem instanceof EmptyTag) {
                if (stack.size() == 0) {
                    children.add(((EmptyTag)elem).getTagName());
                }
            } else if (elem instanceof Tag) {
                stack.push(((Tag)elem).getTagName());
            } else if (elem instanceof EndTag) {
                String name = ((EndTag)elem).getTagName();
                if (stack.empty()) {
                    return children;
                }
                if (stack.peek().equals(name)) {
                    if (stack.size() == 1) {
                        children.add(name);
                    }
                    stack.pop();
                }
            }
            elem = elem.getNext();
        }
        children.clear();
        return children;
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        if (!visible) {
            int retVal = 1;
            switch (typedText.charAt(typedText.length() - 1)) {
                case '/': {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    try {
                        String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                        if (!txtBeforeSpace.equals("</")) break;
                        retVal = 0;
                    }
                    catch (BadLocationException e) {}
                    break;
                }
                case '&': 
                case '<': {
                    retVal = 0;
                }
            }
            return retVal;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }

    static int getTokenEnd(TokenItem item) {
        return item.getOffset() + item.getImage().length();
    }
}

