/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.engine;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xml.core.actions.InputOutputReporter;
import org.netbeans.modules.xml.tools.lib.FileUtilities;
import org.netbeans.modules.xml.tools.lib.GuiUtil;
import org.netbeans.modules.xsl.engine.TransformServlet;
import org.netbeans.modules.xsl.engine.Util;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.xml.sax.SAXException;

public class TransformPerformer {
    private InputOutputReporter cookieObserver = null;
    private Node[] nodes;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$api$xml$cookies$TransformableCookie;

    public TransformPerformer(Node[] nodes) {
        this.nodes = nodes;
    }

    public void perform() {
        if (this.nodes.length == 2) {
            DataObject do1 = (DataObject)this.nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TransformPerformer.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            boolean xslt1 = TransformUtil.isXSLTransformation(do1);
            DataObject do2 = (DataObject)this.nodes[1].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TransformPerformer.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            boolean xslt2 = TransformUtil.isXSLTransformation(do2);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformAction.performAction:");
                Util.THIS.debug("    do1 [" + xslt1 + "] = " + do1);
                Util.THIS.debug("    do2 [" + xslt2 + "] = " + do2);
            }
            if (xslt1 != xslt2) {
                DataObject xslDO;
                DataObject xmlDO;
                TransformableCookie transformable;
                if (xslt1) {
                    transformable = (TransformableCookie)this.nodes[1].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? (class$org$netbeans$api$xml$cookies$TransformableCookie = TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie")) : class$org$netbeans$api$xml$cookies$TransformableCookie);
                    xmlDO = do2;
                    xslDO = do1;
                } else {
                    transformable = (TransformableCookie)this.nodes[0].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? (class$org$netbeans$api$xml$cookies$TransformableCookie = TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie")) : class$org$netbeans$api$xml$cookies$TransformableCookie);
                    xmlDO = do1;
                    xslDO = do2;
                }
                DoublePerformer performer = new DoublePerformer(transformable, xmlDO, xslDO);
                performer.perform();
            } else {
                TransformableCookie transformable1 = (TransformableCookie)this.nodes[0].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? (class$org$netbeans$api$xml$cookies$TransformableCookie = TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie")) : class$org$netbeans$api$xml$cookies$TransformableCookie);
                SinglePerformer performer = new SinglePerformer(transformable1, do1, xslt1);
                performer.perform();
                TransformableCookie transformable2 = (TransformableCookie)this.nodes[1].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? (class$org$netbeans$api$xml$cookies$TransformableCookie = TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie")) : class$org$netbeans$api$xml$cookies$TransformableCookie);
                performer = new SinglePerformer(transformable2, do2, xslt2);
                performer.perform();
            }
        } else {
            int i = 0;
            while (i < this.nodes.length) {
                DataObject dataObject = (DataObject)this.nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? TransformPerformer.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                TransformableCookie transformable = null;
                boolean xslt = TransformUtil.isXSLTransformation(dataObject);
                if (!xslt) {
                    transformable = (TransformableCookie)this.nodes[i].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie") : class$org$netbeans$api$xml$cookies$TransformableCookie);
                }
                SinglePerformer performer = new SinglePerformer(transformable, dataObject, xslt);
                performer.perform();
                ++i;
            }
        }
        if (this.cookieObserver != null) {
            this.cookieObserver.message(Util.THIS.getString("MSG_transformation_2"));
            this.cookieObserver.moveToFront();
        }
    }

    private InputOutputReporter getCookieObserver() {
        if (this.cookieObserver == null) {
            String label = Util.THIS.getString("PROP_transformation_io_name");
            this.cookieObserver = new InputOutputReporter(label);
        }
        return this.cookieObserver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DoublePerformer
    extends AbstractPerformer {
        public DoublePerformer(TransformableCookie transformable, DataObject xmlDO, DataObject xslDO) {
            super(transformable);
            this.xmlDO = xmlDO;
            this.xslDO = xslDO;
        }

        protected void init() throws IOException {
            this.baseFO = this.xmlDO.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
        }

        protected void storeData() {
            this.updateHistory(this.xmlDO, false);
            this.updateHistory(this.xslDO, true);
        }
    }

    private class SinglePerformer
    extends AbstractPerformer {
        private DataObject dataObject;
        private boolean xslt;

        public SinglePerformer(TransformableCookie transformable, DataObject dataObject, boolean xslt) {
            super(transformable);
            this.dataObject = dataObject;
            this.xslt = xslt;
        }

        protected void init() throws IOException {
            this.baseFO = this.dataObject.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
            if (this.xslt) {
                this.xmlDO = null;
                this.xmlStylesheetSource = null;
                this.xslDO = this.dataObject;
            } else {
                this.xmlDO = this.dataObject;
                this.xmlStylesheetSource = TransformUtil.getAssociatedStylesheet(this.baseURL);
                this.xslDO = null;
            }
        }

        protected void storeData() {
            this.updateHistory(this.dataObject, this.xslt);
        }
    }

    private abstract class AbstractPerformer
    implements ActionListener {
        private TransformableCookie transformableCookie;
        protected DataObject xmlDO;
        protected Source xmlStylesheetSource;
        protected DataObject xslDO;
        protected FileObject baseFO;
        protected URL baseURL;
        private Source xmlSource;
        private Source xslSource;
        private FileObject resultFO;
        private TransformPanel transformPanel;
        private DialogDescriptor dialogDescriptor;
        private Dialog dialog;
        private TransformPanel.Data data;
        static /* synthetic */ Class class$org$netbeans$modules$xsl$actions$TransformAction;

        public AbstractPerformer(TransformableCookie transformable) {
            this.transformableCookie = transformable;
        }

        public final void perform() {
            try {
                this.init();
                this.showDialog();
            }
            catch (IOException exc) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug(exc);
                }
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 2);
                TopManager.getDefault().notify((NotifyDescriptor)nd);
            }
        }

        protected abstract void init() throws IOException;

        protected abstract void storeData();

        private void showDialog() throws IOException {
            String xmlStylesheetName = null;
            if (this.xmlStylesheetSource != null) {
                xmlStylesheetName = this.xmlStylesheetSource.getSystemId();
            }
            this.transformPanel = new TransformPanel(this.xmlDO, xmlStylesheetName, this.xslDO);
            DialogDescriptor transformDD = new DialogDescriptor((Object)this.transformPanel, Util.THIS.getString("NAME_transform_panel_title"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(class$org$netbeans$modules$xsl$actions$TransformAction == null ? (class$org$netbeans$modules$xsl$actions$TransformAction = AbstractPerformer.class$("org.netbeans.modules.xsl.actions.TransformAction")) : class$org$netbeans$modules$xsl$actions$TransformAction), null);
            transformDD.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
            transformDD.setButtonListener((ActionListener)this);
            this.dialog = TopManager.getDefault().createDialog(transformDD);
            this.dialog.show();
        }

        protected void prepareData() throws IOException, FileStateInvalidException, MalformedURLException, ParserConfigurationException, SAXException {
            this.data = this.transformPanel.getData();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPerformer...performTransformation");
                Util.THIS.debug("    transformable = " + this.transformableCookie);
                Util.THIS.debug("    baseFileObject = " + this.baseFO);
                Util.THIS.debug("    data = " + this.data);
            }
            this.xmlSource = TransformUtil.createSource(this.baseURL, this.data.getInput());
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    xmlSource = " + this.xmlSource.getSystemId());
            }
            this.xslSource = this.data.getXSL() != null ? TransformUtil.createSource(this.baseURL, this.data.getXSL()) : this.xmlStylesheetSource;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    xslSource = " + this.xslSource.getSystemId());
            }
            if (this.data.getOutput() != null) {
                String fileName = this.data.getOutput().toString().replace('\\', '/');
                this.resultFO = FileUtilities.createFileObject(this.baseFO.getParent(), fileName, this.data.isOverwriteOutput());
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    resultFO = " + this.resultFO);
                }
            }
        }

        protected void updateHistory(DataObject dataObject, boolean xslt) {
            FileObject fileObject = dataObject.getPrimaryFile();
            TransformHistory history = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (history == null) {
                history = new TransformHistory();
            }
            if (xslt) {
                history.addXML(this.data.getInput(), this.data.getOutput());
            } else {
                history.addXSL(this.data.getXSL(), this.data.getOutput());
            }
            history.setOverwriteOutput(this.data.isOverwriteOutput());
            history.setProcessOutput(this.data.getProcessOutput());
            try {
                fileObject.setAttribute("org.netbeans.modules.xsl.settings.TransformHistory", (Object)history);
            }
            catch (IOException exc) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exc);
            }
        }

        private void previewOutput() throws MalformedURLException, UnknownHostException {
            TransformServlet.prepare(this.transformableCookie, this.xmlSource, this.xslSource);
            this.showURL(TransformServlet.getServletURL());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void fileOutput() throws IOException, FileStateInvalidException, TransformerException {
            FileLock fileLock;
            block10: {
                OutputStream outputStream = null;
                fileLock = null;
                try {
                    block9: {
                        try {
                            fileLock = this.resultFO.lock();
                            outputStream = this.resultFO.getOutputStream(fileLock);
                            StreamResult outputResult = new StreamResult(outputStream);
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("    resultFO = " + this.resultFO);
                                Util.THIS.debug("    outputResult = " + outputResult);
                            }
                            String xmlName = this.data.getInput();
                            String xslName = this.data.getXSL();
                            TransformPerformer.this.getCookieObserver().message(Util.THIS.getString("MSG_transformation_1", xmlName, xslName));
                            TransformUtil.transform(this.xmlSource, this.transformableCookie, this.xslSource, outputResult, (CookieObserver)TransformPerformer.this.getCookieObserver());
                            if (this.data.getProcessOutput() == 1) {
                                GuiUtil.performDefaultAction(this.resultFO);
                                GuiUtil.performDefaultAction(this.resultFO);
                                break block9;
                            }
                            if (this.data.getProcessOutput() == 2) {
                                this.showURL(this.resultFO.getURL());
                            }
                        }
                        catch (FileAlreadyLockedException exc) {
                            throw (FileAlreadyLockedException)TopManager.getDefault().getErrorManager().annotate((Throwable)exc, Util.THIS.getString("ERR_FileAlreadyLockedException_output"));
                        }
                    }
                    Object var7_7 = null;
                    if (outputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock == null) throw throwable;
                    fileLock.releaseLock();
                    throw throwable;
                }
                outputStream.close();
            }
            if (fileLock == null) return;
            fileLock.releaseLock();
        }

        private void showURL(URL url) {
            TopManager.getDefault().showUrl(url);
            GuiUtil.setStatusText(Util.THIS.getString("MSG_opening_browser"));
        }

        public final void actionPerformed(ActionEvent e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformPerformer::AbstractPerformer] actionPerformed: " + e);
                Util.THIS.debug("    ActionEvent.getSource(): " + e.getSource());
            }
            if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                try {
                    this.prepareData();
                    if (this.data.getOutput() != null && this.resultFO == null) {
                        return;
                    }
                    this.dialog.dispose();
                    this.storeData();
                    if (this.data.getOutput() == null) {
                        this.previewOutput();
                    } else {
                        this.fileOutput();
                    }
                }
                catch (TransformerException exc) {
                }
                catch (Exception exc) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug(exc);
                    }
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)exc);
                }
            }
        }

        protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
            URL fileURL = null;
            File file = FileUtil.toFile((FileObject)fileObject);
            fileURL = file != null ? file.toURL() : fileObject.getURL();
            return fileURL;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

