/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.engine;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.modules.xsl.engine.Util;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.execution.NbfsURLConnection;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HttpServer;
import org.xml.sax.SAXParseException;

public class TransformServlet
extends HttpServlet {
    private static final long serialVersionUID = 1632869007241230624L;
    private static TransformableCookie transformable;
    private static Source xmlSource;
    private static Source xslSource;
    static /* synthetic */ Class class$org$netbeans$modules$xsl$engine$TransformServlet;
    static /* synthetic */ Class class$org$netbeans$api$xml$cookies$XMLProcessorDetail;

    public static void prepare(TransformableCookie trans, Source xml, Source xsl) {
        transformable = trans;
        xmlSource = xml;
        xslSource = xsl;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        xmlSource = null;
        xslSource = null;
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        StreamResult outputResult = new StreamResult(out);
        Observer notifier = new Observer();
        try {
            try {
                String guessOutputExt = TransformUtil.guessOutputExt(xslSource);
                String mimeType = FileUtil.getMIMEType((String)guessOutputExt);
                if (mimeType != null) {
                    response.setContentType(mimeType);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("[TransformServlet] Response MIME Type: '" + mimeType + "'");
                    Util.THIS.debug("    xmlSource.getSystemId() = " + xmlSource.getSystemId());
                    Util.THIS.debug("    transformable = " + transformable);
                    Util.THIS.debug("    xslSource.getSystemId() = " + xslSource.getSystemId());
                }
                TransformUtil.transform(xmlSource, transformable, xslSource, outputResult, notifier);
            }
            catch (Exception exc) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    EXCEPTION!!!: " + exc.getClass().getName(), exc);
                }
                CookieMessage message = null;
                if (!(exc instanceof TransformerException)) {
                    message = exc instanceof SAXParseException ? new CookieMessage(TransformUtil.unwrapException(exc).getLocalizedMessage(), 3, (Object)new DefaultXMLProcessorDetail((SAXParseException)exc)) : new CookieMessage(exc.getLocalizedMessage(), 3);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    message  = " + message);
                    Util.THIS.debug("    notifier = " + notifier);
                }
                if (message != null) {
                    notifier.receive(message);
                }
                response.setContentType("text/html");
                out.println("<html><head>");
                out.println("    <title>" + Util.THIS.getString("MSG_error_html_title") + "</title>");
                out.println("    <style>" + Util.THIS.getString("MSG_error_html_style") + "</style>");
                out.println("</head><body>");
                out.println("    <h2>" + Util.THIS.getString("MSG_error_page_title") + "</h2>");
                out.println("    <p>" + Util.THIS.getString("MSG_error_page_message") + "</p>");
                out.println("    <hr size=\"1\" noshade=\"\" />\n" + this.generateReport(notifier.getList()) + "<hr size=\"1\" noshade=\"\" />");
                out.println("    <p>" + Util.THIS.getString("MSG_error_bottom_message") + "</p>");
                out.println("</body></html>");
                Object var9_11 = null;
                out.close();
            }
            Object var9_10 = null;
            out.close();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            out.close();
            throw throwable;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "XSL Transformation Preview Servlet";
    }

    public static URL getServletURL() throws MalformedURLException, UnknownHostException {
        URL base = HttpServer.getResourceRoot();
        URL root = new URL(base.getProtocol(), base.getHost(), base.getPort(), "/servlet/" + (class$org$netbeans$modules$xsl$engine$TransformServlet == null ? (class$org$netbeans$modules$xsl$engine$TransformServlet = TransformServlet.class$("org.netbeans.modules.xsl.engine.TransformServlet")) : class$org$netbeans$modules$xsl$engine$TransformServlet).getName() + "/");
        return root;
    }

    private String generateReport(List msgList) {
        StringBuffer sb;
        block5: {
            sb = new StringBuffer();
            try {
                Iterator it = msgList.iterator();
                while (it.hasNext()) {
                    String systemId;
                    CookieMessage msg = (CookieMessage)it.next();
                    XMLProcessorDetail detail = (XMLProcessorDetail)msg.getDetail(class$org$netbeans$api$xml$cookies$XMLProcessorDetail == null ? TransformServlet.class$("org.netbeans.api.xml.cookies.XMLProcessorDetail") : class$org$netbeans$api$xml$cookies$XMLProcessorDetail);
                    sb.append("    &nbsp;&nbsp;&nbsp;&nbsp;<font class=\"").append(this.levelName(msg.getLevel())).append("\">").append(msg.getMessage()).append("</font>");
                    if (detail == null || (systemId = this.preferFileName(detail.getSystemId())) == null) continue;
                    sb.append("&nbsp;(<font class=\"system-id\">");
                    boolean isFile = systemId.startsWith("file:");
                    if (isFile) {
                        sb.append("<a href=\"").append(systemId).append("\">");
                    }
                    sb.append(systemId);
                    if (isFile) {
                        sb.append("</a>");
                    }
                    sb.append("</font>\n");
                    sb.append("&nbsp;[<font class=\"line-number\">").append(detail.getLineNumber()).append("</font>])<br>");
                }
            }
            catch (Exception exc) {
                if (!Util.THIS.isLoggable()) break block5;
                Util.THIS.debug(exc);
            }
        }
        return sb.toString();
    }

    private String preferFileName(String systemId) {
        String name;
        block3: {
            name = systemId;
            try {
                URL url = new URL(systemId);
                FileObject fo = NbfsURLConnection.decodeURL((URL)url);
                if (fo != null) {
                    name = TransformUtil.getURLName(fo);
                }
            }
            catch (Exception exc) {
                if (!Util.THIS.isLoggable()) break block3;
                Util.THIS.debug(exc);
            }
        }
        return name;
    }

    private String levelName(int level) {
        if (level == 3) {
            return "fatal-error";
        }
        if (level == 2) {
            return "error";
        }
        if (level == 1) {
            return "warning";
        }
        return "informational";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Observer
    implements CookieObserver {
        private final List msgList = new Vector();

        public void receive(CookieMessage msg) {
            this.msgList.add(msg);
        }

        public List getList() {
            return this.msgList;
        }
    }
}

