/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.transform.Source;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.ui.Util;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.UserCancelException;

public final class TransformPanel
extends JPanel {
    private static final long serialVersionUID = -3449709794133206327L;
    private URL baseURL;
    private Data data;
    private boolean initialized = false;
    private DataObject xmlDataObject;
    private String xml_stylesheet;
    private DataObject xslDataObject;
    private TransformHistory xmlHistory;
    private TransformHistory xslHistory;
    private boolean userSetOutput = false;
    private boolean userSetProcess = false;
    private String lastOutputFileExt = "html";
    private Object lastXSLObject = new Object();
    private static final String[] SHOW_NAMES = new String[]{Util.THIS.getString("NAME_process_output_do_nothing"), Util.THIS.getString("NAME_process_output_apply_default_action"), Util.THIS.getString("NAME_process_output_open_in_browser")};
    private static final Object JUST_PREVIEW = new Preview();
    private JLabel transformLabel;
    private JCheckBox overwriteCheckBox;
    private JLabel outputLabel;
    private JComboBox outputComboBox;
    private JComboBox inputComboBox;
    private JLabel inputLabel;
    private JLabel showLabel;
    private JButton browseXSLTButton;
    private JComboBox showComboBox;
    private JButton browseInputButton;
    private JComboBox transformComboBox;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public TransformPanel(DataObject xml, String xml_ss, DataObject xsl) throws MalformedURLException, FileStateInvalidException {
        this.initComponents();
        this.init(xml, xml_ss, xsl);
        this.initAccessibility();
    }

    private void init(DataObject xml, String xml_ss, DataObject xsl) throws MalformedURLException, FileStateInvalidException {
        this.data = new Data();
        this.xmlDataObject = xml;
        this.xml_stylesheet = xml_ss;
        this.xslDataObject = xsl;
        if (this.xmlDataObject != null) {
            this.data.xml = TransformUtil.getURLName(this.xmlDataObject.getPrimaryFile());
            FileObject xmlFileObject = this.xmlDataObject.getPrimaryFile();
            this.xmlHistory = (TransformHistory)xmlFileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (this.xmlHistory != null) {
                this.data.xsl = this.xmlHistory.getLastXSL();
            }
            if (this.data.xsl == null && this.xml_stylesheet != null) {
                this.data.xsl = this.xml_stylesheet;
            }
            try {
                this.baseURL = xmlFileObject.getParent().getURL();
            }
            catch (FileStateInvalidException exc) {
                // empty catch block
            }
        }
        if (this.xslDataObject != null) {
            this.data.xsl = TransformUtil.getURLName(this.xslDataObject.getPrimaryFile());
            FileObject xslFileObject = this.xslDataObject.getPrimaryFile();
            this.xslHistory = (TransformHistory)xslFileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (this.data.xml == null && this.xslHistory != null) {
                this.data.xml = this.xslHistory.getLastXML();
            }
            if (this.baseURL == null) {
                try {
                    this.baseURL = xslFileObject.getParent().getURL();
                }
                catch (FileStateInvalidException exc) {
                    // empty catch block
                }
            }
        }
        if (this.xmlHistory != null || this.xslHistory != null) {
            if (this.xmlHistory != null) {
                this.data.output = this.xmlHistory.getLastXSLOutput();
            }
            if (this.data.output == null && this.xslHistory != null) {
                this.data.output = this.xslHistory.getLastXMLOutput();
            }
            if (this.data.output == null) {
                this.data.output = TransformPanel.JUST_PREVIEW;
            }
        }
        if (this.xmlHistory != null) {
            this.data.overwrite = new Boolean(this.xmlHistory.isOverwriteOutput());
            this.data.process = new Integer(this.xmlHistory.getProcessOutput());
        } else if (this.xslHistory != null) {
            this.data.overwrite = new Boolean(this.xslHistory.isOverwriteOutput());
            this.data.process = new Integer(this.xslHistory.getProcessOutput());
        }
        this.ownInitComponents();
    }

    private void ownInitComponents() {
        this.updateXMLComboBoxModel(null);
        this.updateXSLComboBoxModel(null);
        this.updateComponents();
        this.setCaretPosition(this.inputComboBox);
        this.setCaretPosition(this.transformComboBox);
        this.setCaretPosition(this.outputComboBox);
    }

    private void setCaretPosition(JComboBox comboBox) {
        ComboBoxEditor cbEditor = comboBox.getEditor();
        final Component editorComponent = cbEditor.getEditorComponent();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TransformPanel.setCaretPosition: " + comboBox);
            Util.THIS.debug("    editorComponent = " + editorComponent);
        }
        if (editorComponent instanceof JTextField) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTextField textField = (JTextField)editorComponent;
                    int length = textField.getText().length();
                    textField.setCaretPosition(length);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    text[" + length + "]='" + textField.getText() + "' - " + textField.getCaretPosition());
                    }
                }
            });
        }
    }

    private void updateXMLComboBoxModel(Object prefItem) {
        String[] history = null;
        if (this.xmlDataObject == null && this.xslHistory != null) {
            history = this.xslHistory.getXMLs();
        }
        Vector<Object> cbModel = new Vector<Object>();
        if (prefItem != null) {
            cbModel.add(prefItem);
        }
        if (history != null) {
            int i = 0;
            while (i < history.length) {
                cbModel.add(history[i]);
                ++i;
            }
        }
        this.inputComboBox.setModel(new DefaultComboBoxModel(cbModel));
    }

    private void updateXSLComboBoxModel(Object prefItem) {
        String[] history = null;
        if (this.xslDataObject == null && this.xmlHistory != null) {
            history = this.xmlHistory.getXSLs();
        }
        Vector<Object> cbModel = new Vector<Object>();
        if (prefItem != null) {
            cbModel.add(prefItem);
        }
        if (this.xml_stylesheet != null) {
            cbModel.add(this.xml_stylesheet);
        }
        if (history != null) {
            int i = 0;
            while (i < history.length) {
                if (history[i] != null && !history[i].equals(this.xml_stylesheet)) {
                    cbModel.add(history[i]);
                }
                ++i;
            }
        }
        this.transformComboBox.setModel(new DefaultComboBoxModel(cbModel));
    }

    private boolean isInitialized() {
        Data data = this.data;
        synchronized (data) {
            boolean bl = this.initialized;
            return bl;
        }
    }

    private void setInitialized(boolean init) {
        Data data = this.data;
        synchronized (data) {
            this.initialized = init;
        }
    }

    private static String guessFileName(String xml) {
        String fileName = null;
        int slashIndex = xml.lastIndexOf(47);
        fileName = slashIndex != -1 ? xml.substring(slashIndex + 1) : xml;
        return fileName;
    }

    private String guessOutputFileExt() {
        String ext;
        block4: {
            ext = this.lastOutputFileExt;
            String xslObject = this.getXSL();
            if (xslObject != this.lastXSLObject) {
                try {
                    Source xslSource = TransformUtil.createSource(this.baseURL, xslObject);
                    ext = TransformUtil.guessOutputExt(xslSource);
                    this.lastXSLObject = xslObject;
                    this.lastOutputFileExt = ext;
                }
                catch (Exception exc) {
                    if (!Util.THIS.isLoggable()) break block4;
                    Util.THIS.debug("[TransformPanel] Cannot guess extension!", exc);
                }
            }
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("[TransformPanel] I guess output has '" + ext + "' extension.");
        }
        return ext;
    }

    private Object guessOutputFile() {
        Object output = this.data.output;
        if (output == null || JUST_PREVIEW.equals(output)) {
            String origName = TransformPanel.guessFileName(this.data.xml);
            String origExt = "";
            int dotIndex = origName.lastIndexOf(46);
            if (dotIndex != -1) {
                origExt = origName.substring(dotIndex + 1);
                origName = origName.substring(0, dotIndex);
            }
            String ext = this.guessOutputFileExt();
            String plusName = "";
            if (ext.equals(origExt)) {
                plusName = Util.THIS.getString("NAME_plusNameIfSameName");
            }
            output = origName + plusName + "." + ext;
        }
        return output;
    }

    private void initOutputComboBox(Object defaultOutput) {
        this.outputComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{defaultOutput, JUST_PREVIEW}));
    }

    private void updateComponents() {
        boolean notXML;
        this.setInitialized(false);
        boolean bl = notXML = this.xmlDataObject == null;
        if (this.data.xml != null) {
            this.inputComboBox.setSelectedItem(this.data.xml);
            this.inputComboBox.setEditable(this.data.xml instanceof String);
        }
        this.inputComboBox.setEnabled(notXML);
        this.browseInputButton.setEnabled(notXML);
        boolean notXSL = this.xslDataObject == null;
        this.transformComboBox.setEnabled(notXSL);
        this.browseXSLTButton.setEnabled(notXSL);
        if (this.data.xsl != null) {
            this.transformComboBox.setSelectedItem(this.data.xsl);
            this.transformComboBox.setEditable(this.data.xsl instanceof String);
        }
        boolean canOutput = true;
        if (this.data.xml == null || this.data.xsl == null || this.data.xml.length() == 0 || this.data.xsl.length() == 0) {
            canOutput = false;
        }
        boolean notPreview = true;
        this.outputComboBox.setEnabled(canOutput);
        if (canOutput) {
            Object output = this.guessOutputFile();
            this.initOutputComboBox(output);
            if (this.data.output != null) {
                output = this.data.output;
            }
            this.outputComboBox.setSelectedItem(output);
            notPreview = !JUST_PREVIEW.equals(output);
            this.outputComboBox.setEditable(notPreview);
        }
        if (this.data.overwrite != null) {
            this.overwriteCheckBox.setSelected(this.data.overwrite);
        }
        this.overwriteCheckBox.setEnabled(canOutput && notPreview);
        if (this.data.process != null) {
            this.showComboBox.setSelectedIndex(this.data.process);
        } else {
            String ext = this.guessOutputFileExt().toLowerCase();
            if (ext.equals("html") || ext.equals("htm")) {
                this.showComboBox.setSelectedIndex(2);
            } else {
                this.showComboBox.setSelectedIndex(1);
            }
        }
        this.showComboBox.setEnabled(canOutput && notPreview);
        this.setInitialized(true);
    }

    public Data getData() {
        return new Data(this.getInput(), this.getXSL(), this.getOutput(), this.isOverwriteOutput(), this.getProcessOutput());
    }

    private String getInput() {
        return (String)this.inputComboBox.getSelectedItem();
    }

    private String getXSL() {
        return (String)this.transformComboBox.getSelectedItem();
    }

    private String getOutput() {
        Object output = this.outputComboBox.getSelectedItem();
        if (JUST_PREVIEW.equals(output)) {
            return null;
        }
        return (String)output;
    }

    private boolean isOverwriteOutput() {
        return this.overwriteCheckBox.isSelected();
    }

    private int getProcessOutput() {
        return this.showComboBox.getSelectedIndex();
    }

    private void initComponents() {
        this.inputLabel = new JLabel();
        this.inputLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_XML_input_mnemonic"));
        this.inputComboBox = new JComboBox();
        this.browseInputButton = new JButton();
        this.transformLabel = new JLabel();
        this.transformLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_XSL_transform_mnemonic"));
        this.transformComboBox = new JComboBox();
        this.browseXSLTButton = new JButton();
        this.outputLabel = new JLabel();
        this.outputLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_trans_output_mnemonic"));
        this.outputComboBox = new JComboBox();
        this.overwriteCheckBox = new JCheckBox();
        this.overwriteCheckBox.setMnemonic(Util.THIS.getChar("LBL_over_write_mnemonic"));
        this.showLabel = new JLabel();
        this.showLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_show_output_mnemonic"));
        this.showComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 155));
        this.inputLabel.setLabelFor(this.inputComboBox);
        this.inputLabel.setText(Util.THIS.getString("LBL_XML_input"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.inputLabel, gridBagConstraints);
        this.inputComboBox.setEditable(true);
        this.inputComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.inputComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.inputComboBox, gridBagConstraints);
        this.browseInputButton.setMnemonic(Util.THIS.getChar("LBL_browse_file_mnemonic"));
        this.browseInputButton.setText(Util.THIS.getString("LBL_browse_file"));
        this.browseInputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.browseInputButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.browseInputButton, gridBagConstraints);
        this.transformLabel.setLabelFor(this.transformComboBox);
        this.transformLabel.setText(Util.THIS.getString("LBL_XSL_transform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.transformLabel, gridBagConstraints);
        this.transformComboBox.setEditable(true);
        this.transformComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.transformComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.transformComboBox, gridBagConstraints);
        this.browseXSLTButton.setMnemonic(Util.THIS.getChar("LBL_browse_xslt_mnemonic"));
        this.browseXSLTButton.setText(Util.THIS.getString("LBL_browse_xslt"));
        this.browseXSLTButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.browseXSLTButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.browseXSLTButton, gridBagConstraints);
        this.outputLabel.setLabelFor(this.outputComboBox);
        this.outputLabel.setText(Util.THIS.getString("LBL_trans_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.outputLabel, gridBagConstraints);
        this.outputComboBox.setEditable(true);
        this.outputComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.outputComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.outputComboBox, gridBagConstraints);
        this.overwriteCheckBox.setSelected(true);
        this.overwriteCheckBox.setText(Util.THIS.getString("LBL_over_write"));
        this.overwriteCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.overwriteCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.overwriteCheckBox, gridBagConstraints);
        this.showLabel.setText(Util.THIS.getString("LBL_show_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.showLabel, gridBagConstraints);
        this.showComboBox.setModel(new DefaultComboBoxModel<String>(SHOW_NAMES));
        this.showComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TransformPanel.this.showComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 6, 0);
        this.add((Component)this.showComboBox, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TransformPanel"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_overwriteCheckBox"));
        this.outputComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_outputComboBox"));
        this.inputComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_inputComboBox"));
        this.browseXSLTButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_browseXSLTButton"));
        this.showComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_showComboBox"));
        this.browseInputButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_browseInputButton"));
        this.transformComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_transformComboBox"));
    }

    private void browseXSLTButtonActionPerformed(ActionEvent evt) {
        try {
            Node[] nodes = TopManager.getDefault().getNodeOperation().select(Util.THIS.getString("LBL_select_xslt_script"), Util.THIS.getString("LBL_select_node"), TopManager.getDefault().getPlaces().nodes().repository(), new NodeAcceptor(){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes.length != 1) {
                        return false;
                    }
                    DataObject dataObject = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 9.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dataObject == null) {
                        return false;
                    }
                    return TransformUtil.isXSLTransformation(dataObject);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            DataObject dataObject = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TransformPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            this.data.xsl = TransformUtil.getURLName(dataObject.getPrimaryFile());
            if (!this.userSetOutput && this.xmlHistory != null) {
                this.data.output = this.xmlHistory.getXSLOutput(this.data.xsl);
            }
            if (!this.userSetProcess) {
                this.data.process = null;
            }
            this.updateXSLComboBoxModel(this.data.xsl);
            this.updateComponents();
            this.setCaretPosition(this.transformComboBox);
        }
        catch (UserCancelException exc) {
            Util.THIS.debug(exc);
        }
        catch (IOException exc) {
            Util.THIS.debug(exc);
        }
    }

    private void browseInputButtonActionPerformed(ActionEvent evt) {
        try {
            Node[] nodes = TopManager.getDefault().getNodeOperation().select(Util.THIS.getString("LBL_select_xml_document"), Util.THIS.getString("LBL_select_node"), TopManager.getDefault().getPlaces().nodes().repository(), new NodeAcceptor(){
                static /* synthetic */ Class class$org$netbeans$api$xml$cookies$TransformableCookie;

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes.length != 1) {
                        return false;
                    }
                    Node.Cookie transformable = nodes[0].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? (class$org$netbeans$api$xml$cookies$TransformableCookie = 10.class$("org.netbeans.api.xml.cookies.TransformableCookie")) : class$org$netbeans$api$xml$cookies$TransformableCookie);
                    return transformable != null;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            DataObject dataObject = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TransformPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            this.data.xml = TransformUtil.getURLName(dataObject.getPrimaryFile());
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPanel.browseInputButtonActionPerformed:");
                Util.THIS.debug("    dataObject = " + dataObject);
                Util.THIS.debug("    dataObject.getPrimaryFile() = " + dataObject.getPrimaryFile());
            }
            if (!this.userSetOutput && this.xslHistory != null) {
                this.data.output = this.xslHistory.getXMLOutput(this.data.xml);
            }
            if (!this.userSetProcess) {
                this.data.process = null;
            }
            this.updateXMLComboBoxModel(this.data.xml);
            this.updateComponents();
            this.setCaretPosition(this.inputComboBox);
        }
        catch (UserCancelException exc) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPanel.browseInputButtonActionPerformed: EXCEPTION", exc);
            }
        }
        catch (IOException exc) {
            Util.THIS.debug(exc);
        }
    }

    private void showComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            this.data.process = new Integer(this.showComboBox.getSelectedIndex());
            this.userSetProcess = true;
            this.updateComponents();
        }
    }

    private void overwriteCheckBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            this.data.overwrite = new Boolean(this.overwriteCheckBox.isSelected());
            this.updateComponents();
        }
    }

    private void transformComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            String item = (String)this.transformComboBox.getSelectedItem();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPanel.transformComboBoxActionPerformed: getSelectedItem = " + item);
            }
            if (item == null) {
                return;
            }
            this.data.xsl = item.trim();
            if (!this.userSetOutput && this.xmlHistory != null) {
                this.data.output = this.xmlHistory.getXSLOutput(this.data.xsl);
            }
            if (!this.userSetProcess) {
                this.data.process = null;
            }
            this.updateComponents();
        }
    }

    private void inputComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            String item = (String)this.inputComboBox.getSelectedItem();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPanel.inputComboBoxActionPerformed: getSelectedItem = " + item);
            }
            if (item == null) {
                return;
            }
            this.data.xml = item.trim();
            if (!this.userSetOutput && this.xslHistory != null) {
                this.data.output = this.xslHistory.getXMLOutput(this.data.xml);
            }
            if (!this.userSetProcess) {
                this.data.process = null;
            }
            this.updateComponents();
        }
    }

    private void outputComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            Object item = this.outputComboBox.getSelectedItem();
            if (item instanceof String) {
                String str = ((String)item).trim();
                if (str.length() == 0) {
                    str = null;
                }
                item = str;
            }
            this.data.output = item;
            this.userSetOutput = true;
            this.updateComponents();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Preview {
        private Preview() {
        }

        public String toString() {
            return Util.THIS.getString("NAME_output_just_preview");
        }
    }

    public static final class Data {
        private String xml;
        private String xsl;
        private Object output;
        private Boolean overwrite;
        private Integer process;

        private Data() {
            this.xml = null;
            this.xsl = null;
            this.output = null;
            this.overwrite = null;
            this.process = null;
        }

        private Data(String xml, String xsl, String output, boolean overwrite, int process) {
            this.xml = xml;
            this.xsl = xsl;
            this.output = output;
            this.overwrite = new Boolean(overwrite);
            this.process = new Integer(process);
        }

        public String getInput() {
            return this.xml;
        }

        public String getXSL() {
            return this.xsl;
        }

        public String getOutput() {
            return (String)this.output;
        }

        public boolean isOverwriteOutput() {
            return this.overwrite;
        }

        public int getProcessOutput() {
            return this.process;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append("[input='").append(this.xml).append("'; ");
            sb.append("xsl='").append(this.xsl).append("'; ");
            sb.append("output='").append(this.output).append("'; ");
            sb.append("overwrite='").append(this.overwrite).append("'; ");
            sb.append("process='").append(this.process).append("]");
            return sb.toString();
        }
    }
}

