/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.openide.modules.SpecificationVersion;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PreparedModules {
    private static final String ELEMENT_MODULES = "module_updates";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private List modules = new ArrayList();
    private boolean pError = false;
    private static PreparedModules preparedModules;

    PreparedModules() {
    }

    static PreparedModules getPrepared() {
        if (preparedModules == null) {
            PreparedModules.readPrepared();
        }
        return preparedModules;
    }

    static void readPrepared() {
        preparedModules = new PreparedModules();
        preparedModules.read();
    }

    List getModules() {
        return this.modules;
    }

    void addModule(ModuleUpdate moduleUpdate) {
        Module module = new Module();
        module.setCodenamebase(moduleUpdate.getCodeNameBase());
        module.setName(moduleUpdate.getName());
        module.setSize(moduleUpdate.getDownloadSize());
        SpecificationVersion specificationVersion = moduleUpdate.getRemoteModule().getSpecificationVersion();
        module.setSpec_version(specificationVersion == null ? null : specificationVersion.toString());
        module.setNbm_name(moduleUpdate.getDistributionFilename());
        module.setFrom_user_dir(!moduleUpdate.isToInstallDir());
        this.modules.add(module);
    }

    void removeModule(String string) {
        int n = 0;
        while (n < this.modules.size()) {
            Module module = (Module)this.modules.get(n);
            if (module.getCodenamebase().equals(string)) {
                this.modules.remove(n);
                return;
            }
            ++n;
        }
    }

    String getPreparedVersion(String string) {
        int n = 0;
        while (n < this.modules.size()) {
            Module module = (Module)this.modules.get(n);
            if (module.getCodenamebase().equals(string)) {
                return module.getSpec_version();
            }
            ++n;
        }
        return null;
    }

    boolean hasNBM(String string) {
        int n = 0;
        while (n < this.modules.size()) {
            Module module = (Module)this.modules.get(n);
            if (module.getNbm_name().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void delete() {
        this.getInstall_Later(true).delete();
        this.getInstall_Later(false).delete();
    }

    private File getInstall_Later(boolean bl) {
        return Autoupdater.Support.getInstall_Later(bl);
    }

    void write() {
        this.write(true);
        this.write(false);
    }

    private void write(boolean bl) {
        Object object;
        Document document = XMLUtil.createDocument((String)ELEMENT_MODULES, null, null, null);
        Element element = document.getDocumentElement();
        Element element2 = null;
        Iterator iterator = this.modules.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            object = (Module)iterator.next();
            if ((!bl || !((Module)object).isFrom_user_dir()) && (bl || ((Module)object).isFrom_user_dir())) continue;
            element2 = document.createElement(ELEMENT_MODULE);
            element2.setAttribute(ATTR_CODENAMEBASE, ((Module)object).getCodenamebase());
            element2.setAttribute(ATTR_NAME, ((Module)object).getName());
            element2.setAttribute(ATTR_SPEC_VERSION, ((Module)object).getSpec_version());
            element2.setAttribute(ATTR_SIZE, Long.toString(((Module)object).getSize()));
            element2.setAttribute(ATTR_NBM_NAME, ((Module)object).getNbm_name());
            element.appendChild(element2);
            bl2 = false;
        }
        if (bl2) {
            return;
        }
        document.getDocumentElement().normalize();
        try {
            object = new FileOutputStream(this.getInstall_Later(bl));
            XMLUtil.write((Document)document, (OutputStream)object, null);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void read() {
        this.modules.clear();
        this.read(true);
        this.read(false);
    }

    private void read(boolean bl) {
        Document document;
        Object object;
        try {
            File file = this.getInstall_Later(bl);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)object, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), null);
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println("Bad install_later");
                sAXException.printStackTrace();
            }
            return;
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println("Missing install_later");
                iOException.printStackTrace();
            }
            return;
        }
        object = document.getDocumentElement();
        if (object != null && object.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_module_updates((Element)object, bl);
        }
    }

    private void scanElement_module_updates(Element element, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getTagName().equals(ELEMENT_MODULE)) {
                this.scanElement_module(element2, bl);
            }
            ++n;
        }
    }

    private void scanElement_module(Element element, boolean bl) {
        Module module = new Module();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (attr.getName().equals(ATTR_CODENAMEBASE)) {
                module.setCodenamebase(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SPEC_VERSION)) {
                module.setSpec_version(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NAME)) {
                module.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SIZE)) {
                try {
                    module.setSize(Long.parseLong(attr.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    module.setSize(0L);
                }
            }
            if (attr.getName().equals(ATTR_NBM_NAME)) {
                module.setNbm_name(attr.getValue());
            }
            module.setFrom_user_dir(bl);
            ++n;
        }
        this.modules.add(module);
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            PreparedModules.this.pError = true;
        }

        public void error(SAXParseException sAXParseException) {
            PreparedModules.this.pError = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            PreparedModules.this.pError = true;
        }
    }

    class Module {
        private String name;
        private String codenamebase;
        private String spec_version;
        private long size;
        private String nbm_name;
        private boolean from_user_dir;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getCodenamebase() {
            return this.codenamebase;
        }

        public void setCodenamebase(String string) {
            this.codenamebase = string;
        }

        public String getSpec_version() {
            return this.spec_version;
        }

        public void setSpec_version(String string) {
            this.spec_version = string;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }

        public String getNbm_name() {
            return this.nbm_name;
        }

        public void setNbm_name(String string) {
            this.nbm_name = string;
        }

        public boolean isFrom_user_dir() {
            return this.from_user_dir;
        }

        public void setFrom_user_dir(boolean bl) {
            this.from_user_dir = bl;
        }
    }
}

