/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.autoupdate.CertificateDialog;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class ResultsPanel
extends JPanel {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle");
    private static final String SPACE = " ";
    private static final String BAD_DOWNLOAD = " " + bundle.getString("CTL_BAD_DOWNLOAD") + " ";
    private static final String CORRUPTED = " " + bundle.getString("CTL_CORRUPTED") + " ";
    private static final String NOT_SIGNED = " " + bundle.getString("CTL_NOT_SIGNED") + " ";
    private static final String SIGNED = " " + bundle.getString("CTL_SIGNED") + " ";
    private static final String TRUSTED = " " + bundle.getString("CTL_TRUSTED") + " ";
    private Wizard.Validator validator;
    private int modulesOK;
    private Dimension preferredDimension = null;
    private char includeMnem;
    private char globalMnem;
    private JTable table;
    private ResultsTableModel model;
    private static String yesToAll = bundle.getString("CTL_Yes_All");
    private boolean includeAll = false;
    private boolean globalAll = false;
    static final long serialVersionUID = -6053101371836354161L;
    private JButton certificateButton;
    private JScrollPane jScrollPane1;
    private ButtonGroup buttonGroup1;
    private JTextArea jTextArea1;

    public ResultsPanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(3));
        this.setName(bundle.getString("LBL_View"));
        this.initComponents();
        this.validator = validator;
        this.model = new ResultsTableModel();
        this.table = new JTable(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new BooleanRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ResultsCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new BooleanRenderer());
        this.table.setRowHeight(2 * this.table.getRowHeight());
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(48);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(480);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(48);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ResultsPanel.this.selectionChange();
            }
        });
        this.selectionChange();
        this.getAccessibleContext().setAccessibleName(bundle.getString("LBL_View"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_41"));
        this.certificateButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_View"));
        this.table.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Module_List"));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.certificateButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setFont(new Font("Dialog", 0, 11));
        this.jTextArea1.setText(bundle.getString("LBL_41"));
        this.jTextArea1.setBackground(this.getBackground());
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.certificateButton.setMnemonic(bundle.getString("BTN_View_Mnem").charAt(0));
        this.certificateButton.setText(bundle.getString("BTN_View"));
        this.certificateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.certificateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.certificateButton, gridBagConstraints);
    }

    private void certificateButtonActionPerformed(ActionEvent actionEvent) {
        int n = CertificateDialog.showDialog(this.getListSelection().getCerts(), this.getListSelection().getSecurity());
        this.doCertAction(n);
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    private void doInclude() {
        if (this.getListSelection().isDepending() && Downloader.bannedWriteToInstall()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(bundle.getString("MSG_CannotInstall_2"), this.getListSelection().getName()));
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (this.getListSelection().getSecurity() == 2) {
            if (this.getListSelection().isInstallApproved()) {
                this.getListSelection().setInstallApproved(false);
                this.checkValidity();
            } else {
                Object object = null;
                if (!this.includeAll) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)bundle.getString("MSG_NotSignedConfirmation"), bundle.getString("CTL_NotSignedConfirmation"), 0);
                    confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, yesToAll});
                    object = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object.equals(yesToAll)) {
                        this.includeAll = true;
                    }
                }
                if (this.includeAll || object.equals(NotifyDescriptor.YES_OPTION)) {
                    this.getListSelection().setInstallApproved(true);
                    this.checkValidity();
                }
            }
        } else if (this.getListSelection().getSecurity() == 3 || this.getListSelection().getSecurity() == 4) {
            this.doCertAction(CertificateDialog.showDialog(this.getListSelection().getCerts(), this.getListSelection().getSecurity()));
        } else if (this.getListSelection().getSecurity() == 1) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)bundle.getString("MSG_CorruptedJAR"));
            TopManager.getDefault().notify((NotifyDescriptor)message);
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)bundle.getString("MSG_BadDownload"));
            TopManager.getDefault().notify((NotifyDescriptor)message);
        }
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    private void doGlobal() {
        if (this.getListSelection().isDepending()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(bundle.getString("MSG_InstallDepending"), this.getListSelection().getName()));
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (Downloader.bannedWriteToInstall()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)bundle.getString("MSG_InstallNoWrite"));
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (this.getListSelection().isToInstallDir()) {
            this.getListSelection().setToInstallDir(false);
        } else {
            Object object = null;
            if (!this.globalAll) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(bundle.getString("MSG_InstallConfirmation"), this.getListSelection().getName()), 0);
                confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, yesToAll});
                object = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (object.equals(yesToAll)) {
                    this.globalAll = true;
                }
            }
            if (this.globalAll || object.equals(NotifyDescriptor.YES_OPTION)) {
                this.getListSelection().setToInstallDir(true);
            }
        }
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    void doCertAction(int n) {
        switch (n) {
            case 1: {
                this.setApproved4All(this.getListSelection().getCerts(), true, -1);
                this.checkValidity();
                break;
            }
            case 4: {
                this.setApproved4All(this.getListSelection().getCerts(), false, -1);
                this.checkValidity();
                break;
            }
            case 3: {
                this.setApproved4All(this.getListSelection().getCerts(), false, 3);
                this.checkValidity();
                try {
                    SignVerifier.removeCertificates(this.getListSelection().getCerts());
                }
                catch (CertificateException certificateException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + certificateException);
                }
                catch (KeyStoreException keyStoreException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + keyStoreException);
                }
                catch (IOException iOException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + noSuchAlgorithmException);
                }
                break;
            }
            case 2: {
                this.setApproved4All(this.getListSelection().getCerts(), true, 4);
                this.checkValidity();
                try {
                    SignVerifier.addCertificates(this.getListSelection().getCerts());
                }
                catch (CertificateException certificateException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + certificateException);
                }
                catch (KeyStoreException keyStoreException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + keyStoreException);
                }
                catch (IOException iOException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + noSuchAlgorithmException);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setApproved4All(Collection collection, boolean bl, int n) {
        if (collection == null) {
            return;
        }
        boolean bl2 = Downloader.bannedWriteToInstall();
        int n2 = 0;
        while (n2 < this.model.getRowCount()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)this.model.getValueAt(n2, 1);
            if (!(bl && moduleUpdate.isDepending() && bl2 || moduleUpdate.getCerts() == null || !collection.containsAll(moduleUpdate.getCerts()))) {
                moduleUpdate.setInstallApproved(bl);
                if (n == 4 || n == 3) {
                    moduleUpdate.setSecurity(n);
                }
            }
            ++n2;
        }
    }

    int generateResults() {
        ModuleUpdate moduleUpdate;
        this.modulesOK = 0;
        boolean bl = Downloader.bannedWriteToInstall();
        ArrayList<ModuleUpdate> arrayList = new ArrayList<ModuleUpdate>();
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        int n = -1;
        while (iterator.hasNext()) {
            moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected()) continue;
            arrayList.add(moduleUpdate);
            if (moduleUpdate.isDownloadOK()) {
                ++this.modulesOK;
                if (n == -1 && !moduleUpdate.isInstallApproved()) {
                    n = arrayList.size() - 1;
                }
            }
            if (!moduleUpdate.isDepending()) continue;
            if (bl) {
                moduleUpdate.setInstallApproved(false);
                bl2 = true;
            }
            moduleUpdate.setToInstallDir(true);
        }
        if (bl2) {
            moduleUpdate = new NotifyDescriptor.Message((Object)bundle.getString("MSG_CannotInstall_1"));
            TopManager.getDefault().notify((NotifyDescriptor)moduleUpdate);
        }
        this.model.refreshContent(arrayList);
        if (n == -1) {
            n = 0;
        }
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        this.checkValidity();
        this.selectionChange();
        this.includeAll = false;
        this.globalAll = false;
        return this.modulesOK;
    }

    private void selectionChange() {
        ModuleUpdate moduleUpdate = this.getListSelection();
        if (moduleUpdate != null && (moduleUpdate.getSecurity() == 3 || moduleUpdate.getSecurity() == 4)) {
            this.certificateButton.setEnabled(true);
        } else {
            this.certificateButton.setEnabled(false);
        }
    }

    private ModuleUpdate getListSelection() {
        int n = this.table.getSelectionModel().getMinSelectionIndex();
        if (n < 0) {
            return null;
        }
        return (ModuleUpdate)this.model.getValueAt(n, 1);
    }

    private void checkValidity() {
        boolean bl = false;
        int n = 0;
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected() || !moduleUpdate.isInstallApproved()) continue;
            bl = true;
            ++n;
        }
        this.validator.setValid(bl);
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(new LineBorder((Color)UIManager.getDefaults().get("Button.focus")));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setBorderPainted(bl && jTable.getSelectedColumn() == n2);
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    private class ResultsCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel nameLabel;
        private JLabel securityLabel;

        public ResultsCellRenderer() {
            this.initComponents();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            if (object == null) {
                object = ResultsPanel.this.model.getValueAt(n, n2);
            }
            switch (((ModuleUpdate)object).getSecurity()) {
                case 0: {
                    string = BAD_DOWNLOAD;
                    break;
                }
                case 1: {
                    string = CORRUPTED;
                    break;
                }
                case 2: {
                    string = NOT_SIGNED;
                    break;
                }
                case 3: {
                    StringBuffer stringBuffer = new StringBuffer(SIGNED);
                    stringBuffer.append(ResultsPanel.SPACE + bundle.getString("CTL_By"));
                    Collection collection = ((ModuleUpdate)object).getCerts();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Certificate certificate = (Certificate)iterator.next();
                        if (!(certificate instanceof X509Certificate)) continue;
                        stringBuffer.append(ResultsPanel.SPACE).append(((X509Certificate)certificate).getSubjectDN().getName());
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 4: {
                    string = TRUSTED;
                }
            }
            if (bl) {
                this.setBackground((Color)UIManager.getDefaults().get("Table.selectionBackground"));
                this.nameLabel.setForeground((Color)UIManager.getDefaults().get("Table.selectionForeground"));
                this.securityLabel.setForeground((Color)UIManager.getDefaults().get("Table.selectionForeground"));
            } else {
                this.setBackground((Color)UIManager.getDefaults().get("Table.background"));
                this.nameLabel.setForeground((Color)UIManager.getDefaults().get("Table.Foreground"));
                this.securityLabel.setForeground((Color)UIManager.getDefaults().get("Table.Foreground"));
            }
            this.nameLabel.setText(((ModuleUpdate)object).getName() + "  " + bundle.getString("CTL_Version") + ((ModuleUpdate)object).getRemoteModule().getSpecificationVersion());
            this.securityLabel.setText(string);
            return this;
        }

        private void initComponents() {
            this.nameLabel = new JLabel();
            this.securityLabel = new JLabel();
            this.setLayout(new GridBagLayout());
            this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.add((Component)this.nameLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.securityLabel, gridBagConstraints);
        }
    }

    class ResultsTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{ResultsPanel.access$200().getString("LBL_42"), ResultsPanel.access$200().getString("LBL_43"), ResultsPanel.access$200().getString("LBL_Global")};
        private List modulelist = new ArrayList();

        ResultsTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.modulelist.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Boolean(((ModuleUpdate)this.modulelist.get(n)).isInstallApproved());
            }
            if (n2 == 1) {
                return this.modulelist.get(n);
            }
            return new Boolean(((ModuleUpdate)this.modulelist.get(n)).isToInstallDir());
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Boolean) {
                if (n2 == 0) {
                    ResultsPanel.this.doInclude();
                } else {
                    ResultsPanel.this.doGlobal();
                }
            }
        }

        void refreshContent(List list) {
            this.modulelist = list;
        }
    }
}

