/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class SafeModule {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    static final String PROP_AUTOLOAD = "autoload";
    static final String PROP_EAGER = "eager";
    private static final String PROP_SPEC = "specversion";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_JAR = "jar";
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_USER = "user";
    private static final String PROP_INSTALL = "installation";
    private static final String PROP_RELEASE = "release";
    private static final String PROP_RELOADABLE = "reloadable";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PARAM = "param";
    private static File sysmod = null;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    SafeModule() {
    }

    static boolean write(ModuleUpdate moduleUpdate) {
        boolean bl = true;
        Iterator iterator = moduleUpdate.getJarList().iterator();
        while (bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            bl = SafeModule.write(moduleUpdate, string);
        }
        return bl;
    }

    private static boolean write(ModuleUpdate moduleUpdate, String string) {
        Module module = new Module();
        try {
            SafeModule.loadManifest(string, module, moduleUpdate);
        }
        catch (IOException iOException) {
            return false;
        }
        Document document = XMLUtil.createDocument((String)ELEMENT_MODULE, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Element element = document.getDocumentElement();
        element.setAttribute(ATTR_NAME, module.getName());
        boolean bl = false;
        if (string.startsWith(PROP_AUTOLOAD)) {
            bl = true;
            string = string.substring(PROP_EAGER.length());
        }
        Element element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
        element2.setAttribute(ATTR_NAME, PROP_AUTOLOAD);
        element2.appendChild(document.createTextNode(String.valueOf(bl)));
        boolean bl2 = false;
        if (string.startsWith(PROP_EAGER)) {
            bl2 = true;
            string = string.substring(PROP_EAGER.length());
        }
        element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
        element2.setAttribute(ATTR_NAME, PROP_EAGER);
        element2.appendChild(document.createTextNode(String.valueOf(bl2)));
        if (!bl && !bl2) {
            element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
            element2.setAttribute(ATTR_NAME, PROP_ENABLED);
            element2.appendChild(document.createTextNode(String.valueOf(true)));
        }
        element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
        element2.setAttribute(ATTR_NAME, PROP_JAR);
        element2.appendChild(document.createTextNode(string));
        element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
        element2.setAttribute(ATTR_NAME, PROP_ORIGIN);
        String string2 = "";
        string2 = moduleUpdate.isToInstallDir() ? PROP_INSTALL : PROP_USER;
        if (bl) {
            string2 = string2 + '/' + PROP_AUTOLOAD;
        } else if (bl2) {
            string2 = string2 + '/' + PROP_EAGER;
        }
        element2.appendChild(document.createTextNode(string2));
        if (module.getRelease() != null) {
            element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
            element2.setAttribute(ATTR_NAME, PROP_RELEASE);
            element2.appendChild(document.createTextNode(module.getRelease()));
        }
        element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
        element2.setAttribute(ATTR_NAME, PROP_RELOADABLE);
        element2.appendChild(document.createTextNode(String.valueOf(false)));
        if (module.getSpecVersion() != null) {
            element2 = (Element)element.appendChild(document.createElement(ATTR_PARAM));
            element2.setAttribute(ATTR_NAME, PROP_SPEC);
            element2.appendChild(document.createTextNode(module.getSpecVersion()));
        }
        String string3 = module.getName().replace('.', '-');
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(sysmod, string3 + ".xml"));
            try {
                XMLUtil.write((Document)document, (OutputStream)fileOutputStream, (String)"UTF-8");
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
            {
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static void loadManifest(String string, Module module, ModuleUpdate moduleUpdate) throws IOException {
        String string2 = null;
        string2 = moduleUpdate.isToInstallDir() ? System.getProperty("netbeans.home") : System.getProperty("netbeans.user");
        string2 = string2 + FILE_SEPARATOR + "modules" + FILE_SEPARATOR + string;
        JarFile jarFile = new JarFile(string2);
        try {
            Manifest manifest = jarFile.getManifest();
            String string3 = manifest.getMainAttributes().getValue("OpenIDE-Module");
            int n = string3.indexOf(47);
            if (n > -1) {
                module.setRelease(string3.substring(n + 1));
                string3 = string3.substring(0, n);
            }
            module.setName(string3);
            String string4 = manifest.getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
            module.setSpecVersion(string4);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    static {
        sysmod = new File(new File(Autoupdater.Support.getNBDirectory(), "system"), "Modules");
        sysmod.mkdirs();
    }

    static class Module {
        private String name;
        private String specVersion;
        private String release;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getSpecVersion() {
            return this.specVersion;
        }

        public void setSpecVersion(String string) {
            this.specVersion = string;
        }

        public String getRelease() {
            return this.release;
        }

        public void setRelease(String string) {
            this.release = string;
        }
    }
}

