/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.ProgressDialog;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.NbBundle;

class SignVerifier {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$SignVerifier == null ? (class$org$netbeans$modules$autoupdate$SignVerifier = SignVerifier.class$("org.netbeans.modules.autoupdate.SignVerifier")) : class$org$netbeans$modules$autoupdate$SignVerifier));
    private static final String KS_PSSWD = "open4all";
    private static final String ENTRY_SEPARATOR = "/";
    private static final String NBM_BIN = "netbeans/bin";
    private static final String NBM_LIB = "netbeans/lib";
    private static final String NBM_MAIN = "main";
    private static final String NBM_MODULES = "netbeans/modules";
    private static final String NBM_AUTOLOAD = "netbeans/modules/autoload";
    private static final String NBM_EAGER = "netbeans/modules/eager";
    private static final String JAR_EXT = ".jar";
    public static final int NOT_CHECKED = -1;
    public static final int BAD_DOWNLOAD = 0;
    public static final int CORRUPTED = 1;
    public static final int NOT_SIGNED = 2;
    public static final int SIGNED = 3;
    public static final int TRUSTED = 4;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    ProgressDialog progressDialog;
    private Wizard.Validator validator;
    private int verifySize;
    private long totalVerified;
    private long modulesCount;
    private boolean verifyCanceled = false;
    private boolean wizardCanceled = false;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$SignVerifier;

    SignVerifier(ProgressDialog progressDialog, Wizard.Validator validator) {
        this.validator = validator;
        this.progressDialog = progressDialog;
    }

    void doVerify() {
        this.verifyCanceled = false;
        Runnable runnable = new Runnable(){

            public void run() {
                SignVerifier.this.progressDialog.setLabelText(1, bundle.getString("CTL_PreparingVerify_Label"));
                SignVerifier.this.verifySize = SignVerifier.this.getTotalVerifySize();
                if (SignVerifier.this.verifyCanceled) {
                    return;
                }
                SignVerifier.this.verifyAll();
                if (SignVerifier.this.verifyCanceled) {
                    return;
                }
                SignVerifier.this.validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(runnable);
    }

    int getTotalVerifySize() {
        long l = 0L;
        this.modulesCount = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected() || !moduleUpdate.isDownloadOK() || moduleUpdate.getSecurity() != -1 && moduleUpdate.getSecurity() != 0) continue;
            File file = Downloader.getNBM(moduleUpdate);
            l += file.length();
            ++this.modulesCount;
        }
        return (int)(l / 1024L);
    }

    void verifyAll() {
        Object object;
        this.progressDialog.setGaugeBounds(2, 0, this.verifySize);
        this.progressDialog.setGaugeValue(2, 0);
        this.progressDialog.setLabelText(2, "");
        this.progressDialog.setGaugeValue(1, 0);
        int n = 0;
        this.totalVerified = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            if (this.verifyCanceled) {
                return;
            }
            object = (ModuleUpdate)iterator.next();
            if (!((ModuleUpdate)object).isSelected() || !((ModuleUpdate)object).isDownloadOK() || ((ModuleUpdate)object).getSecurity() != -1 && ((ModuleUpdate)object).getSecurity() != 0) continue;
            if (this.verifyCanceled) {
                return;
            }
            this.progressDialog.setGaugeValue(1, 0);
            this.progressDialog.setLabelText(1, ((ModuleUpdate)object).getName() + " [" + (n + 1) + ENTRY_SEPARATOR + this.modulesCount + "]");
            File file = Downloader.getNBM((ModuleUpdate)object);
            try {
                Collection collection = this.verifyJar(file, (ModuleUpdate)object);
                if (collection == null) {
                    ((ModuleUpdate)object).setSecurity(2);
                    ((ModuleUpdate)object).setInstallApproved(false);
                } else {
                    ((ModuleUpdate)object).setCerts(collection);
                    if (this.isTrusted(collection)) {
                        ((ModuleUpdate)object).setSecurity(4);
                        ((ModuleUpdate)object).setInstallApproved(true);
                    } else {
                        ((ModuleUpdate)object).setSecurity(3);
                        ((ModuleUpdate)object).setInstallApproved(false);
                    }
                }
            }
            catch (SecurityException securityException) {
                ((ModuleUpdate)object).setSecurity(1);
                ((ModuleUpdate)object).setInstallApproved(false);
            }
            catch (IOException iOException) {
                ((ModuleUpdate)object).setSecurity(0);
                ((ModuleUpdate)object).setInstallApproved(false);
                ((ModuleUpdate)object).setDownloadOK(false);
            }
            ++n;
        }
        this.progressDialog.setGaugeValue(2, this.verifySize);
        object = MessageFormat.format(bundle.getString("FMT_VerifiedTotal"), new Integer(this.verifySize), new Integer(this.verifySize));
        this.progressDialog.setLabelText(2, (String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection verifyJar(File file, ModuleUpdate moduleUpdate) throws SecurityException, IOException {
        Object object;
        Object object2;
        Cloneable cloneable;
        LinkedList<Cloneable> linkedList;
        Manifest manifest;
        JarFile jarFile;
        int n;
        boolean bl;
        boolean bl2;
        block23: {
            block24: {
                Collection collection;
                Object var3_3 = null;
                bl2 = false;
                bl = false;
                int n2 = 0;
                n = (int)file.length();
                this.progressDialog.setGaugeBounds(1, 0, n / 1024);
                jarFile = new JarFile(file);
                manifest = jarFile.getManifest();
                Enumeration<JarEntry> enumeration = jarFile.entries();
                linkedList = new LinkedList<Cloneable>();
                byte[] byArray = new byte[8192];
                try {
                    while (true) {
                        String string;
                        Object var19_18;
                        block25: {
                            if (!enumeration.hasMoreElements()) {
                                if (!this.verifyCanceled) break block23;
                                cloneable = null;
                                break block24;
                            }
                            cloneable = enumeration.nextElement();
                            if (((ZipEntry)cloneable).getName().startsWith(NBM_LIB) || ((ZipEntry)cloneable).getName().startsWith(NBM_BIN)) {
                                moduleUpdate.setDepending(true);
                            }
                            if (((ZipEntry)cloneable).getName().startsWith(NBM_MAIN)) {
                                moduleUpdate.setSafeToInstall(false);
                            }
                            object2 = null;
                            if (((ZipEntry)cloneable).getName().startsWith(NBM_AUTOLOAD) && ((ZipEntry)cloneable).getName().endsWith(JAR_EXT)) {
                                object2 = this.getJarModuleName(((ZipEntry)cloneable).getName(), "netbeans/modules/autoload/");
                                if (object2 != null) {
                                    moduleUpdate.addToJarList((String)object2);
                                }
                            } else if (((ZipEntry)cloneable).getName().startsWith(NBM_EAGER) && ((ZipEntry)cloneable).getName().endsWith(JAR_EXT)) {
                                object2 = this.getJarModuleName(((ZipEntry)cloneable).getName(), "netbeans/modules/eager/");
                                if (object2 != null) {
                                    moduleUpdate.addToJarList((String)object2);
                                }
                            } else if (((ZipEntry)cloneable).getName().startsWith(NBM_MODULES) && ((ZipEntry)cloneable).getName().endsWith(JAR_EXT) && (object2 = this.getJarModuleName(((ZipEntry)cloneable).getName(), "netbeans/modules/")) != null) {
                                moduleUpdate.addToJarList((String)object2);
                            }
                            this.progressDialog.setGaugeValue(1, n2 / 1024);
                            linkedList.add(cloneable);
                            object = jarFile.getInputStream((ZipEntry)cloneable);
                            try {
                                do {
                                    int n3;
                                    if ((n3 = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) continue;
                                    break block25;
                                } while (!this.verifyCanceled);
                                collection = null;
                                var19_18 = null;
                            }
                            catch (Throwable throwable) {
                                var19_18 = null;
                                ((InputStream)object).close();
                                this.totalVerified += ((ZipEntry)cloneable).getCompressedSize();
                                n2 = (int)((long)n2 + ((ZipEntry)cloneable).getCompressedSize());
                                string = MessageFormat.format(bundle.getString("FMT_VerifiedTotal"), new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize));
                                this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                                this.progressDialog.setLabelText(2, string);
                                this.progressDialog.setGaugeValue(1, n2 / 1024);
                                throw throwable;
                            }
                            ((InputStream)object).close();
                            this.totalVerified += ((ZipEntry)cloneable).getCompressedSize();
                            n2 = (int)((long)n2 + ((ZipEntry)cloneable).getCompressedSize());
                            string = MessageFormat.format(bundle.getString("FMT_VerifiedTotal"), new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize));
                            this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                            this.progressDialog.setLabelText(2, string);
                            this.progressDialog.setGaugeValue(1, n2 / 1024);
                            Object var22_24 = null;
                            break;
                        }
                        var19_18 = null;
                        ((InputStream)object).close();
                        this.totalVerified += ((ZipEntry)cloneable).getCompressedSize();
                        n2 = (int)((long)n2 + ((ZipEntry)cloneable).getCompressedSize());
                        string = MessageFormat.format(bundle.getString("FMT_VerifiedTotal"), new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize));
                        this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                        this.progressDialog.setLabelText(2, string);
                        this.progressDialog.setGaugeValue(1, n2 / 1024);
                    }
                }
                catch (Throwable throwable) {
                    Object var22_27 = null;
                    jarFile.close();
                    if (!this.wizardCanceled) throw throwable;
                    Downloader.getNBM(moduleUpdate).delete();
                    throw throwable;
                }
                jarFile.close();
                if (!this.wizardCanceled) return collection;
                Downloader.getNBM(moduleUpdate).delete();
                return collection;
            }
            Object var22_25 = null;
            jarFile.close();
            if (!this.wizardCanceled) return cloneable;
            Downloader.getNBM(moduleUpdate).delete();
            return cloneable;
        }
        Object var22_26 = null;
        jarFile.close();
        if (this.wizardCanceled) {
            Downloader.getNBM(moduleUpdate).delete();
        }
        cloneable = new HashSet();
        if (manifest != null) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object = (JarEntry)object2.next();
                String string = ((ZipEntry)object).getName();
                Certificate[] certificateArray = ((JarEntry)object).getCertificates();
                boolean bl3 = certificateArray != null && certificateArray.length > 0;
                bl2 |= bl3;
                if (certificateArray != null) {
                    int n4 = 0;
                    while (n4 < certificateArray.length) {
                        cloneable.add(certificateArray[n4]);
                        if (this.verifyCanceled) {
                            return null;
                        }
                        ++n4;
                    }
                    continue;
                }
                if (((ZipEntry)object).isDirectory() || string.toUpperCase().startsWith("META-INF/")) continue;
                bl = true;
            }
        }
        if (bl2 && bl) {
            throw new SecurityException(bundle.getString("EXC_NotSignedEntity"));
        }
        this.progressDialog.setGaugeValue(1, n / 1024 + 10);
        if (!bl2) return null;
        Cloneable cloneable2 = cloneable;
        return cloneable2;
    }

    public static String formatCerts(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 300);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (certificate instanceof X509Certificate) {
                try {
                    stringBuffer.append("\n\n");
                    stringBuffer.append(SignVerifier.X509CertToString((X509Certificate)certificate));
                }
                catch (Exception exception) {
                    stringBuffer.append(certificate.toString());
                }
            } else {
                stringBuffer.append(certificate.toString());
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    boolean isTrusted(Collection collection) {
        Collection collection2 = this.getTrustedCerts();
        if (collection2.size() <= 0 || collection.size() <= 0) {
            return false;
        }
        return collection2.containsAll(collection);
    }

    static void addCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (keyStore.getCertificateAlias(certificate) != null) continue;
            String string = null;
            int n = 0;
            while (n < 9999) {
                string = "genAlias" + n;
                if (!keyStore.containsAlias(string)) break;
                ++n;
            }
            if (string == null) {
                throw new KeyStoreException(bundle.getString("EXC_TooManyCertificates"));
            }
            keyStore.setCertificateEntry(string, certificate);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
    }

    static void removeCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            String string = keyStore.getCertificateAlias(certificate);
            if (string == null) continue;
            keyStore.deleteEntry(string);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
    }

    Collection getTrustedCerts() {
        ArrayList arrayList = new ArrayList(10);
        File file = Autoupdater.Support.getCentralKSFile();
        File file2 = Autoupdater.Support.getUserKSFile();
        try {
            KeyStore keyStore;
            if (file.canRead()) {
                keyStore = SignVerifier.getKeyStore(file, KS_PSSWD, null);
                arrayList.addAll(SignVerifier.getCertificates(keyStore));
            }
            if (file2.canRead() && !file2.equals(file)) {
                keyStore = SignVerifier.getKeyStore(file2, KS_PSSWD, null);
                arrayList.addAll(SignVerifier.getCertificates(keyStore));
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (IOException iOException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return arrayList;
    }

    private static KeyStore getKeyStore(File file, String string, String string2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        KeyStore keyStore = null;
        if (string2 == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, string.toCharArray());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return keyStore;
    }

    public static void saveKeyStore(KeyStore keyStore, File file, String string, String string2) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        keyStore.store(fileOutputStream, string.toCharArray());
        ((OutputStream)fileOutputStream).close();
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(10);
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }

    void cancelVerify(boolean bl) {
        this.verifyCanceled = true;
        this.wizardCanceled = bl;
    }

    private static String X509CertToString(X509Certificate x509Certificate) throws Exception {
        return bundle.getString("MSG_Owner") + SPACE + x509Certificate.getSubjectDN() + NEW_LINE + bundle.getString("MSG_Issuer") + SPACE + x509Certificate.getIssuerDN() + NEW_LINE + bundle.getString("MSG_SerNumber") + SPACE + x509Certificate.getSerialNumber().toString(16) + NEW_LINE + bundle.getString("MSG_Valid") + SPACE + x509Certificate.getNotBefore().toString() + SPACE + bundle.getString("MSG_Until") + SPACE + x509Certificate.getNotAfter().toString() + NEW_LINE + bundle.getString("MSG_CertFinger") + NEW_LINE + SPACE + TAB + bundle.getString("MSG_MD5") + SPACE + SPACE + SignVerifier.getCertFingerPrint("MD5", x509Certificate) + NEW_LINE + SPACE + TAB + bundle.getString("MSG_SHA1") + SPACE + SignVerifier.getCertFingerPrint("SHA1", x509Certificate);
    }

    private static String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return SignVerifier.toHexString(byArray2);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignVerifier.byte2hex(byArray[n2], stringBuffer);
            if (n2 < n - 1) {
                stringBuffer.append(":");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private String getJarModuleName(String string, String string2) {
        if (string.substring(string2.length()).indexOf(ENTRY_SEPARATOR) == -1) {
            String string3 = "netbeans/modules/";
            return string.substring(string3.length());
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

