/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.ModuleGroup;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUpdates
extends Updates {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$XMLUpdates == null ? (class$org$netbeans$modules$autoupdate$XMLUpdates = XMLUpdates.class$("org.netbeans.modules.autoupdate.XMLUpdates")) : class$org$netbeans$modules$autoupdate$XMLUpdates));
    private static final String TAG_MODULE_UPDATES = "module_updates";
    private static final String TAG_MODULE = "module";
    private static final String TAG_MODULE_GROUP = "module_group";
    private static final String TAG_NOTIFICATION = "notification";
    private static final String ATTR_NOTIFICATION_URL = "url";
    private static final String TAG_ERROR = "error";
    private static final String TAG_AUTH_ERROR = "auth_error";
    private static final String TAG_OTHER_ERROR = "other_error";
    private static final String ATTR_MESSAGE_ERROR = "message";
    private ArrayList modules;
    private ModuleGroup rootGroup;
    private int moduleCount;
    private int pError = 0;
    private String errorMess = null;
    private Date timeStamp = null;
    private String notificationText = null;
    private URL notificationURL = null;
    private URL xmlURL;
    private File[] files;
    private static ArrayList groupFiles = new ArrayList();
    private static boolean timerSet = false;
    private static boolean groupStarted = false;
    private static int oldGroupSize = 0;
    private Document document = null;
    private InputSource xmlInputSource = null;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$XMLUpdates;

    XMLUpdates(URL uRL) {
        this.xmlURL = uRL;
    }

    XMLUpdates(File[] fileArray) {
        this.files = fileArray;
    }

    static void startGroupUpdates(File file) {
        if (groupStarted) {
            new XMLUpdates(new File[]{file}).go();
        } else {
            groupFiles.add(file);
            XMLUpdates.setTimer();
        }
    }

    private static void setTimer() {
        if (!timerSet) {
            timerSet = true;
            oldGroupSize = groupFiles.size();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (oldGroupSize < groupFiles.size()) {
                        oldGroupSize = groupFiles.size();
                        RequestProcessor.getDefault().post((Runnable)this, 500);
                    } else {
                        timerSet = false;
                        groupStarted = true;
                        File[] fileArray = new File[groupFiles.size()];
                        Iterator iterator = ((AbstractList)groupFiles).iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            File file = (File)iterator.next();
                            if (file != null) {
                                fileArray[n] = file;
                            }
                            ++n;
                        }
                        groupFiles.clear();
                        groupStarted = false;
                        new XMLUpdates(fileArray).go();
                    }
                }
            }, 500);
        }
    }

    private void go() {
        this.checkDownloadedModules();
        HashMap<XMLUpdates, XMLUpdates> hashMap = new HashMap<XMLUpdates, XMLUpdates>();
        hashMap.put(this, this);
        Wizard.go(hashMap, 1);
    }

    public void checkUpdates(Wizard.Validator validator) {
        this.checkUpdates(validator, null);
    }

    public void checkUpdates(final Wizard.Validator validator, String string) {
        this.pError = 0;
        this.checkCanceled = false;
        final Dialog dialog = ConnectingDialog.getDialog(string);
        Runnable runnable = new Runnable(){

            public void run() {
                XMLUpdates.this.parseDocument();
                Settings.getShared().setLastCheck(new Date());
                if (XMLUpdates.this.pError == 0 && XMLUpdates.this.document != null) {
                    XMLUpdates.this.buildStructures();
                } else {
                    XMLUpdates.this.pError = 1;
                }
                if (dialog != null) {
                    ConnectingDialog.closeDialog(dialog);
                }
                validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(runnable);
        dialog.show();
        if (ConnectingDialog.isCanceled()) {
            this.cancelCheck();
        }
    }

    public void cancelCheck() {
        this.checkCanceled = true;
        if (this.xmlInputSource != null) {
            try {
                if (this.xmlInputSource.getByteStream() != null) {
                    this.xmlInputSource.getByteStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ModuleGroup getRootGroup() {
        return this.rootGroup;
    }

    public Collection getModules() {
        return this.modules;
    }

    public boolean isError() {
        return this.pError > 0;
    }

    public int getError() {
        return this.pError;
    }

    public String getErrorMessage() {
        return this.errorMess;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getNotificationText() {
        return this.notificationText;
    }

    public URL getNotificationURL() {
        return this.notificationURL;
    }

    void checkDownloadedModules() {
        this.modules = new ArrayList();
        this.rootGroup = new ModuleGroup();
        int n = 0;
        while (n < this.files.length) {
            ModuleUpdate moduleUpdate = new ModuleUpdate(this.files[n]);
            if (moduleUpdate.createFromDistribution() && moduleUpdate.isUpdateAvailable()) {
                this.modules.add(moduleUpdate);
                this.rootGroup.addItem(moduleUpdate);
            }
            ++n;
        }
    }

    private void parseDocument() {
        if (this.checkCanceled) {
            return;
        }
        String string = System.getProperty("autoupdate.show.url");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            System.out.println("URL : " + this.xmlURL);
        }
        try {
            HttpURLConnection.setFollowRedirects(true);
            this.xmlInputSource = new InputSource(this.xmlURL.toExternalForm());
            if (this.checkCanceled) {
                return;
            }
            this.document = XMLUtil.parse((InputSource)this.xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), null);
        }
        catch (SAXException sAXException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println("URL : " + this.xmlURL);
                sAXException.printStackTrace();
            }
            this.pError = 1;
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println("URL : " + this.xmlURL);
                iOException.printStackTrace();
            }
            this.pError = 1;
        }
    }

    private void buildStructures() {
        if (this.checkCanceled) {
            return;
        }
        if (this.document.getDocumentElement() != null) {
            this.modules = new ArrayList();
            this.rootGroup = new ModuleGroup();
            if (this.detectErrorType()) {
                return;
            }
            NodeList nodeList = this.document.getElementsByTagName(TAG_MODULE);
            this.moduleCount = nodeList.getLength();
            this.processElement(this.document.getDocumentElement(), this.rootGroup);
            Node node = this.document.getDocumentElement().getAttributes().getNamedItem("timestamp");
            if (node != null) {
                String string = node.getNodeValue() + "/GMT";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy/zzz");
                ParsePosition parsePosition = new ParsePosition(0);
                this.timeStamp = simpleDateFormat.parse(string, parsePosition);
            }
        }
    }

    private boolean detectErrorType() {
        NodeList nodeList = this.document.getElementsByTagName(TAG_ERROR);
        if (nodeList.getLength() > 0) {
            NodeList nodeList2 = this.document.getElementsByTagName(TAG_AUTH_ERROR);
            if (nodeList2.getLength() > 0) {
                this.pError = 2;
            } else {
                this.pError = 1;
                NodeList nodeList3 = this.document.getElementsByTagName(TAG_OTHER_ERROR);
                if (nodeList3.getLength() > 0) {
                    this.errorMess = nodeList3.item(0).getAttributes().getNamedItem(ATTR_MESSAGE_ERROR).getNodeValue();
                }
            }
        }
        return this.pError > 0;
    }

    private void processElement(Element element, ModuleGroup moduleGroup) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (this.checkCanceled) {
                return;
            }
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Object object;
                if (((Element)node).getTagName().equals(TAG_MODULE)) {
                    object = new ModuleUpdate(this.xmlURL, node, this.document.getDocumentElement());
                    if (((ModuleUpdate)object).readModuleUpdate() && ((ModuleUpdate)object).isUpdateAvailable()) {
                        this.modules.add(object);
                        moduleGroup.addItem((ModuleUpdate)object);
                    }
                } else if (((Element)node).getTagName().equals(TAG_MODULE_GROUP)) {
                    object = new ModuleGroup(node);
                    moduleGroup.addItem((ModuleGroup)object);
                    this.processElement((Element)node, (ModuleGroup)object);
                } else if (((Element)node).getTagName().equals(TAG_NOTIFICATION)) {
                    this.readNotification(node);
                }
            }
            ++n;
        }
    }

    private void readNotification(Node node) {
        Object object;
        Object object2;
        if (this.getNotificationText() != null) {
            return;
        }
        try {
            object2 = node.getAttributes().getNamedItem(ATTR_NOTIFICATION_URL);
            Object object3 = object = object2 == null ? null : object2.getNodeValue();
            if (object != null) {
                this.notificationURL = new URL((String)object);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object2 = new StringBuffer();
        object = node.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            if (object.item(n).getNodeType() == 3) {
                ((StringBuffer)object2).append(object.item(n).getNodeValue());
            }
            ++n;
        }
        this.notificationText = ((StringBuffer)object2).length() > 0 ? ((StringBuffer)object2).toString() : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            XMLUpdates.this.pError = 1;
        }

        public void error(SAXParseException sAXParseException) {
            XMLUpdates.this.pError = 1;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            XMLUpdates.this.pError = 1;
        }
    }
}

