/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.support.SecondaryDebuggerSupport;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.j2ee.impl.DefaultExecPerformer;
import org.netbeans.modules.j2ee.impl.ProgressObject;
import org.netbeans.modules.j2ee.server.DebugInfo;
import org.netbeans.modules.j2ee.server.ServerEvent;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerListener;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.netbeans.modules.j2ee.server.datamodel.ModuleChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.ModuleStandardData;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.execution.ExecutorTask;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DefaultServerInstanceManager
implements TaskListener,
ServerListener {
    private static boolean debug = false;
    static ResourceBundle bundle;
    protected static Map serverInstanceManagerMap;
    protected ServerInstance serverInstance = null;
    protected CopyMaker[] copyMakers = null;
    protected ExecutorTask executorTask = null;
    protected InputStream[] inputStreams = null;
    protected BufferedReader[] inputStreamReaders = null;
    protected CopyMakerServerInstanceListener copyMakerServerInstanceListener = null;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager;

    protected static ExecutorTask serverInstanceStartExecution(ServerInstance serverInstance, DefaultExecPerformer defaultExecPerformer) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager defaultServerInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        return defaultServerInstanceManager.startExecution(defaultExecPerformer);
    }

    protected static ExecutorTask serverInstanceDeployment(ServerInstance serverInstance, DefaultExecPerformer defaultExecPerformer) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager defaultServerInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        return defaultServerInstanceManager.startDeployment(defaultExecPerformer);
    }

    protected static void serverInstanceStartDebugging(ServerInstance serverInstance, boolean bl, DefaultExecPerformer defaultExecPerformer) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager defaultServerInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        defaultServerInstanceManager.startDebugger(defaultExecPerformer, bl);
    }

    protected static void prepareServerInstanceManagerMap(ServerInstance serverInstance) {
        if (serverInstanceManagerMap == null) {
            serverInstanceManagerMap = new HashMap(5);
        }
        if (serverInstanceManagerMap.get(serverInstance) == null) {
            serverInstanceManagerMap.put(serverInstance, new DefaultServerInstanceManager(serverInstance));
        }
    }

    protected DefaultServerInstanceManager(ServerInstance serverInstance) {
        this.serverInstance = serverInstance;
        this.copyMakerServerInstanceListener = new CopyMakerServerInstanceListener(serverInstance);
    }

    private ProgressObject doDeploy(DefaultExecPerformer defaultExecPerformer, boolean bl) throws ServerException {
        ProgressObject progressObject = defaultExecPerformer.getProgressObject();
        if (progressObject == null) {
            progressObject = new ProgressObject();
        }
        ModuleStandardData moduleStandardData = defaultExecPerformer.getModuleData();
        if (bl) {
            ModuleChangeEvent[] moduleChangeEventArray = defaultExecPerformer.getModuleEvents(progressObject);
            this.serverInstance.deploy(moduleStandardData, moduleChangeEventArray, progressObject);
        } else {
            this.serverInstance.deploy(moduleStandardData, progressObject);
        }
        defaultExecPerformer.deployCompleted();
        return progressObject;
    }

    protected ExecutorTask startExecution(DefaultExecPerformer defaultExecPerformer) {
        try {
            this.serverInstance.setMode(1);
            debug = false;
            this.copyMakerServerInstanceListener.prepare();
            ProgressObject progressObject = this.doDeploy(defaultExecPerformer, defaultExecPerformer.tryIncremental());
            this.serverInstance.ensureAvailable(progressObject);
            progressObject.finished();
            this.copyMakerServerInstanceListener.deactivate();
            defaultExecPerformer.startClient();
        }
        catch (ServerException serverException) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)serverException);
        }
        return this.executorTask;
    }

    protected ExecutorTask startDeployment(DefaultExecPerformer defaultExecPerformer) {
        try {
            this.copyMakerServerInstanceListener.prepare();
            this.doDeploy(defaultExecPerformer, false).finished();
            this.copyMakerServerInstanceListener.deactivate();
        }
        catch (ServerException serverException) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)serverException);
        }
        return this.executorTask;
    }

    protected void startDebugger(DefaultExecPerformer defaultExecPerformer, boolean bl) {
        try {
            this.serverInstance.setMode(2);
            debug = true;
            this.copyMakerServerInstanceListener.prepare();
            ProgressObject progressObject = this.doDeploy(defaultExecPerformer, defaultExecPerformer.tryIncremental());
            this.serverInstance.ensureAvailable(progressObject);
            progressObject.finished();
            this.copyMakerServerInstanceListener.deactivate();
            defaultExecPerformer.startClient();
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
        }
    }

    protected DebuggerInfo getDebuggerInfo(DebugInfo debugInfo) {
        if (debugInfo instanceof DebugInfo.SocketDebugInfo) {
            return new RemoteDebuggerInfo(((DebugInfo.SocketDebugInfo)debugInfo).getHost(), ((DebugInfo.SocketDebugInfo)debugInfo).getPort());
        }
        if (debugInfo instanceof DebugInfo.SharedMemoryDebugInfo) {
            return new RemoteDebuggerInfo(((DebugInfo.SharedMemoryDebugInfo)debugInfo).getAdress());
        }
        return null;
    }

    private void connectIDEDebugger() {
        try {
            DebugInfo debugInfo = this.serverInstance.getDebugInfo();
            DebuggerInfo debuggerInfo = this.getDebuggerInfo(debugInfo);
            Debugger debugger = TopManager.getDefault().getDebugger();
            debugger.addPropertyChangeListener((PropertyChangeListener)new DebuggerPropertyChangeListener(debuggerInfo));
            int n = 100;
            int n2 = 7;
            int n3 = 0;
            while (n3 < n2) {
                try {
                    debugger.startDebugger(debuggerInfo);
                    break;
                }
                catch (DebuggerException debuggerException) {
                    try {
                        Thread.sleep(n);
                        n *= 2;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n3 == n2 - 1) {
                        throw debuggerException;
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
        }
    }

    protected synchronized void createExecutorTask() {
        try {
            if (this.executorTask == null) {
                this.executorTask = TopManager.getDefault().getExecutionEngine().execute(this.serverInstance.getDisplayName(), (Runnable)new EmptyThread(), null);
                this.executorTask.addTaskListener((TaskListener)this);
                this.serverInstance.addServerChangeListener(this);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
        }
    }

    public synchronized void taskFinished(Task task) {
        if (this.executorTask != null) {
            task.removeTaskListener((TaskListener)this);
            this.serverInstance.removeServerChangeListener(this);
            this.serverInstance.stopExecution();
            this.executorTask.stop();
            this.clearCopyMaker();
            this.executorTask = null;
        }
    }

    public synchronized void serverStatusChanged(ServerEvent serverEvent) {
        if (serverEvent.getServerInstance().equals(this.serverInstance) && serverEvent.getServerStatus().equals(ServerStatus.STATUS_STOPPED) && this.executorTask != null) {
            this.executorTask.removeTaskListener((TaskListener)this);
            this.serverInstance.removeServerChangeListener(this);
            this.executorTask.stop();
            this.clearCopyMaker();
            this.executorTask = null;
        }
    }

    protected void createCopyMaker() {
        try {
            JavaDebugger javaDebugger = (JavaDebugger)((CoreDebugger)TopManager.getDefault().getDebugger()).getCurrentDebugger();
            ServerOutput[] serverOutputArray = this.serverInstance.getServerOutput();
            if (serverOutputArray == null) {
                serverOutputArray = new ServerOutput[]{};
            }
            if (this.copyMakers == null) {
                this.copyMakers = new CopyMaker[serverOutputArray.length];
                this.inputStreams = new InputStream[serverOutputArray.length];
                this.inputStreamReaders = new BufferedReader[serverOutputArray.length];
            }
            int n = 0;
            while (n < this.copyMakers.length) {
                if (this.copyMakers[n] == null && serverOutputArray[n] != null) {
                    InputStream inputStream = serverOutputArray[n].getStream();
                    if (this.inputStreams[n] == null || this.inputStreams[n] != inputStream) {
                        this.inputStreamReaders[n] = new BufferedReader(new InputStreamReader(inputStream), 50);
                    }
                    this.inputStreams[n] = inputStream;
                    this.copyMakers[n] = debug ? new DebugCopyMaker(this.inputStreamReaders[n], (Debugger)javaDebugger, false) : new ExecCopyMaker(this.inputStreamReaders[n], (Writer)this.executorTask.getInputOutput().getOut(), false);
                    this.copyMakers[n].start();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
        }
    }

    protected void clearCopyMaker() {
        if (this.copyMakers != null) {
            int n = 0;
            while (n < this.copyMakers.length) {
                if (this.copyMakers[n] != null) {
                    this.copyMakers[n].finishThread();
                    this.copyMakers[n].interrupt();
                    this.copyMakers[n] = null;
                }
                ++n;
            }
            this.copyMakers = null;
        }
    }

    static String getString(String string, Object object) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager == null ? (class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager = DefaultServerInstanceManager.class$("org.netbeans.modules.j2ee.impl.DefaultServerInstanceManager")) : class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager));
        }
        MessageFormat messageFormat = new MessageFormat(bundle.getString(string));
        return messageFormat.format(new Object[]{object});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        serverInstanceManagerMap = null;
    }

    protected class CopyMakerServerInstanceListener
    implements ServerListener {
        private boolean activation = false;

        public CopyMakerServerInstanceListener(ServerInstance serverInstance) {
            serverInstance.addServerChangeListener(this);
        }

        public void serverStatusChanged(ServerEvent serverEvent) {
            if (serverEvent.getServerStatus().equals(ServerStatus.STATUS_RESTART)) {
                if (this.activation) {
                    this.go();
                }
                this.activation = false;
            }
        }

        public void prepare() {
            this.activation = true;
        }

        public void deactivate() {
            if (this.activation) {
                this.activation = false;
                this.go();
            }
        }

        private void go() {
            if (debug) {
                DefaultServerInstanceManager.this.connectIDEDebugger();
            } else {
                DefaultServerInstanceManager.this.createExecutorTask();
            }
            DefaultServerInstanceManager defaultServerInstanceManager = DefaultServerInstanceManager.this;
            synchronized (defaultServerInstanceManager) {
                DefaultServerInstanceManager.this.clearCopyMaker();
                DefaultServerInstanceManager.this.createCopyMaker();
            }
        }
    }

    protected class CurrentDebuggerPropertyChangeListener
    implements PropertyChangeListener {
        protected Debugger debugger = null;

        public CurrentDebuggerPropertyChangeListener(Debugger debugger) {
            this.debugger = debugger;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("debuggerState") && propertyChangeEvent.getNewValue() == SecondaryDebuggerSupport.STATE_NOT_RUNNING) {
                this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
                if (debug) {
                    DefaultServerInstanceManager.this.serverInstance.removeServerChangeListener(DefaultServerInstanceManager.this);
                    DefaultServerInstanceManager.this.serverInstance.stopExecution();
                    DefaultServerInstanceManager.this.clearCopyMaker();
                }
            }
        }
    }

    protected class DebuggerPropertyChangeListener
    implements PropertyChangeListener {
        protected DebuggerInfo debuggerInfo = null;

        public DebuggerPropertyChangeListener(DebuggerInfo debuggerInfo) {
            this.debuggerInfo = debuggerInfo;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("currentDebugger")) {
                try {
                    DebuggerInfo debuggerInfo;
                    Debugger debugger = (Debugger)propertyChangeEvent.getNewValue();
                    if (debugger instanceof AbstractDebugger && (debuggerInfo = ((AbstractDebugger)debugger).getDebuggerInfo()) == this.debuggerInfo) {
                        debugger.addPropertyChangeListener((PropertyChangeListener)new CurrentDebuggerPropertyChangeListener(debugger));
                        TopManager.getDefault().getDebugger().removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                catch (DebuggerNotFoundException debuggerNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify(4096, (Throwable)debuggerNotFoundException);
                }
            }
        }
    }

    protected class EmptyThread
    extends Thread {
        protected EmptyThread() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected class DebugCopyMaker
    extends CopyMaker {
        Debugger debugger = null;

        public DebugCopyMaker(BufferedReader bufferedReader, Debugger debugger, boolean bl) {
            super(bufferedReader, bl);
            this.debugger = debugger;
        }

        void writeString(String string) throws Exception {
            ((JavaDebugger)this.debugger).getIOManager().println(string, 2);
            if (this.stop) {
                throw new Exception();
            }
        }
    }

    protected class ExecCopyMaker
    extends CopyMaker {
        Writer or = null;

        public ExecCopyMaker(BufferedReader bufferedReader, Writer writer, boolean bl) {
            super(bufferedReader, bl);
            this.or = writer;
        }

        void writeString(String string) throws Exception {
            this.or.write(string);
            if (this.stop) {
                throw new Exception();
            }
            this.or.write(System.getProperty("line.separator"));
            if (this.autoflush) {
                this.or.flush();
            }
        }
    }

    protected abstract class CopyMaker
    extends Thread {
        BufferedReader ir = null;
        boolean stop = false;
        boolean autoflush;

        public CopyMaker(BufferedReader bufferedReader, boolean bl) {
            super("CopyMaker");
            this.ir = bufferedReader;
            this.autoflush = bl;
        }

        public void finishThread() {
            this.stop = true;
        }

        public void run() {
            block3: {
                try {
                    String string;
                    while ((string = this.ir.readLine()) != null) {
                        this.writeString(string);
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block3;
                    exception.printStackTrace();
                }
            }
        }

        abstract void writeString(String var1) throws Exception;
    }
}

