/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InsertI18nStringAction;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class I18nManager {
    public static final String I18N_MODE = "internationalization";
    private static I18nManager manager;
    private I18nSupport support;
    private WeakReference i18nPanelWRef = new WeakReference<Object>(null);
    private WeakReference topComponentWRef = new WeakReference<Object>(null);
    private WeakReference caretWRef;
    private HardCodedString hcString;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$I18nManager;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$InsertI18nStringAction;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    private I18nManager() {
    }

    public static I18nManager getDefault() {
        if (manager == null) {
            Class clazz = class$org$netbeans$modules$i18n$I18nManager == null ? (class$org$netbeans$modules$i18n$I18nManager = I18nManager.class$("org.netbeans.modules.i18n.I18nManager")) : class$org$netbeans$modules$i18n$I18nManager;
            synchronized (clazz) {
                if (manager == null) {
                    manager = new I18nManager();
                }
            }
        }
        return manager;
    }

    private void initSupport(DataObject sourceDataObject) throws IOException {
        I18nSupport.Factory factory = FactoryRegistry.getFactory(sourceDataObject.getClass());
        this.support = factory.create(sourceDataObject);
    }

    public void internationalize(final DataObject sourceDataObject) {
        ((InsertI18nStringAction)SystemAction.get((Class)(class$org$netbeans$modules$i18n$InsertI18nStringAction == null ? (class$org$netbeans$modules$i18n$InsertI18nStringAction = I18nManager.class$("org.netbeans.modules.i18n.InsertI18nStringAction")) : class$org$netbeans$modules$i18n$InsertI18nStringAction))).cancel();
        this.closeDialog();
        try {
            this.initSupport(sourceDataObject);
        }
        catch (IOException ioe) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("I18N: Document could not be loaded for " + sourceDataObject.getName());
            }
            return;
        }
        final EditorCookie ec = (EditorCookie)sourceDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = I18nManager.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (ec == null) {
            return;
        }
        if (this.find()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    I18nManager.this.initCaret(ec);
                    I18nManager.this.highlightHCString();
                    I18nManager.this.getDialog(sourceDataObject.getName());
                    I18nManager.this.fillDialogValues();
                }
            });
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_NoInternationalizableString"), 1);
            TopManager.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private void initCaret(EditorCookie ec) {
        JEditorPane[] panes = ec.getOpenedPanes();
        if (panes == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_CouldNotOpen"), 0);
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        this.caretWRef = new WeakReference<Caret>(panes[0].getCaret());
    }

    private void highlightHCString() {
        HardCodedString hStr = this.hcString;
        if (hStr == null) {
            return;
        }
        Caret caret = (Caret)this.caretWRef.get();
        if (caret != null) {
            caret.setDot(hStr.getStartPosition().getOffset());
            caret.moveDot(hStr.getEndPosition().getOffset());
        }
    }

    private boolean find() {
        this.hcString = this.support.getFinder().findNextHardCodedString();
        return this.hcString != null;
    }

    private void fillDialogValues() {
        I18nPanel i18nPanel = (I18nPanel)this.i18nPanelWRef.get();
        i18nPanel.setI18nString(this.support.getDefaultI18nString(this.hcString));
        this.showDialog();
    }

    private void replace() {
        I18nString i18nString = null;
        try {
            i18nString = ((I18nPanel)this.i18nPanelWRef.get()).getI18nString();
        }
        catch (IllegalStateException e) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("EXC_BadKey"), 0);
            TopManager.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        this.support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), i18nString.getComment());
        if (this.support.hasAdditionalCustomizer()) {
            this.support.performAdditionalChanges();
        }
        this.support.getReplacer().replace(this.hcString, i18nString);
        this.skip();
    }

    private void skip() {
        if (this.find()) {
            this.highlightHCString();
            this.fillDialogValues();
        } else {
            this.cancel();
        }
    }

    private void showInfo() {
        JPanel infoPanel = this.support.getInfo(this.hcString);
        DialogDescriptor dd = new DialogDescriptor((Object)infoPanel, I18nUtil.getBundle().getString("CTL_InfoPanelTitle"));
        dd.setModal(true);
        dd.setOptionType(-1);
        dd.setOptions(new Object[]{NotifyDescriptor.OK_OPTION});
        dd.setAdditionalOptions(new Object[0]);
        Dialog infoDialog = TopManager.getDefault().createDialog(dd);
        ((Component)infoDialog).setVisible(true);
    }

    public void cancel() {
        this.support = null;
        this.closeDialog();
    }

    private void getDialog(String name) {
        TopComponent topComponent = (TopComponent)this.topComponentWRef.get();
        I18nPanel i18nPanel = (I18nPanel)this.i18nPanelWRef.get();
        Object createdMode = null;
        if (i18nPanel == null) {
            final I18nPanel panel = i18nPanel = new I18nPanel(this.support.getPropertyPanel());
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == panel.getReplaceButton()) {
                        I18nManager.this.replace();
                    } else if (evt.getSource() == panel.getSkipButton()) {
                        I18nManager.this.skip();
                    } else if (evt.getSource() == panel.getInfoButton()) {
                        I18nManager.this.showInfo();
                    } else if (evt.getSource() == panel.getCancelButton()) {
                        I18nManager.this.cancel();
                    }
                }
            };
            i18nPanel.getReplaceButton().addActionListener(listener);
            i18nPanel.getSkipButton().addActionListener(listener);
            i18nPanel.getInfoButton().addActionListener(listener);
            i18nPanel.getCancelButton().addActionListener(listener);
            this.i18nPanelWRef = new WeakReference<I18nPanel>(i18nPanel);
        }
        i18nPanel.setI18nString(this.support.getDefaultI18nString());
        if (topComponent == null) {
            String title = Util.getString("CTL_I18nDialogTitle");
            URL icon = this.getClass().getResource("i18nAction.gif");
            topComponent = I18nUtil.createTopComponent(i18nPanel, name, title, icon);
            this.topComponentWRef = new WeakReference<TopComponent>(topComponent);
        }
        topComponent.open();
        topComponent.requestFocus();
    }

    private void showDialog() {
        Caret caret;
        TopComponent topComponent = (TopComponent)this.topComponentWRef.get();
        if (topComponent != null && !topComponent.isOpened()) {
            topComponent.open();
            topComponent.requestFocus();
        }
        if ((caret = (Caret)this.caretWRef.get()) != null && !caret.isVisible()) {
            caret.setVisible(true);
        }
    }

    private void closeDialog() {
        TopComponent topComponent = (TopComponent)this.topComponentWRef.get();
        if (topComponent != null) {
            topComponent.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

