/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.HashMap;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;

public class I18nString {
    protected I18nSupport support;
    protected String key;
    protected String value;
    protected String comment;
    protected String replaceFormat;

    protected I18nString(I18nSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        this.support = support;
        this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
    }

    protected I18nString(I18nString copy) {
        this.key = copy.key;
        this.value = copy.value;
        this.comment = copy.comment;
        this.replaceFormat = copy.replaceFormat;
        this.support = copy.support;
    }

    public void become(I18nString copy) {
        this.key = copy.key;
        this.value = copy.value;
        this.comment = copy.comment;
        this.replaceFormat = copy.replaceFormat;
        this.support = copy.support;
    }

    public Object clone() {
        return new I18nString(this);
    }

    public I18nSupport getSupport() {
        return this.support;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (this.key == key || this.key != null && this.key.equals(key)) {
            return;
        }
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (this.value == value || this.value != null && this.value.equals(value)) {
            return;
        }
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (this.comment == comment || this.comment != null && this.comment.equals(comment)) {
            return;
        }
        this.comment = comment;
    }

    public String getReplaceFormat() {
        return this.replaceFormat;
    }

    public void setReplaceFormat(String replaceFormat) {
        this.replaceFormat = replaceFormat;
    }

    public String getReplaceString() {
        if (this.getKey() == null || this.getSupport() == null || this.getSupport().getResourceHolder().getResource() == null) {
            return null;
        }
        if (this.replaceFormat == null) {
            this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("key", this.getKey());
        map.put("bundleNameSlashes", this.getSupport().getResourceHolder().getResource().getPrimaryFile().getPackageName('/'));
        map.put("bundleNameDots", this.getSupport().getResourceHolder().getResource().getPrimaryFile().getPackageName('.'));
        DataObject sourceDataObject = this.getSupport().getSourceDataObject();
        map.put("sourceFileName", sourceDataObject == null ? "" : sourceDataObject.getPrimaryFile().getName());
        return MapFormat.format((String)this.replaceFormat, map);
    }
}

