/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nManager;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

public class InsertI18nStringAction
extends CookieAction {
    static final long serialVersionUID = -7002111874047983222L;
    private static WeakReference topComponentWRef = new WeakReference<Object>(null);
    private int position;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    protected void performAction(Node[] activatedNodes) {
        EditorCookie editorCookie = (EditorCookie)activatedNodes[0].getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = InsertI18nStringAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (editorCookie == null) {
            Util.debug(new IllegalArgumentException("Missing editor cookie!"));
            return;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = InsertI18nStringAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dataObject == null) {
            Util.debug(new IllegalArgumentException("Missing DataObject!"));
            return;
        }
        JEditorPane[] panes = editorCookie.getOpenedPanes();
        if (panes == null || panes.length == 0) {
            Util.debug(new IllegalArgumentException("Missing editor pane!"));
            return;
        }
        this.position = panes[0].getCaret().getDot();
        I18nManager.getDefault().cancel();
        try {
            this.addPanel(dataObject);
        }
        catch (IOException ex) {
            String msg = "Document loading failure " + dataObject.getName();
            Util.debug(msg, ex);
            return;
        }
        panes[0].getCaret().setVisible(true);
    }

    private JPanel createPanel(DataObject dataObject) throws IOException {
        I18nSupport.Factory factory = FactoryRegistry.getFactory(dataObject.getClass());
        if (factory == null) {
            throw new IllegalStateException("I18N: No factory registered for data object type=" + dataObject.getClass().getName());
        }
        final I18nSupport support = factory.create(dataObject);
        final I18nPanel i18nPanel = new I18nPanel(support.getPropertyPanel(), false);
        i18nPanel.setI18nString(support.getDefaultI18nString());
        JButton OKButton = new JButton(I18nUtil.getBundle().getString("CTL_OKButton"));
        OKButton.setMnemonic(I18nUtil.getBundle().getString("CTL_OKButton_Mnem").charAt(0));
        OKButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_OKButton"));
        JButton cancelButton = new JButton(I18nUtil.getBundle().getString("CTL_CancelButton"));
        cancelButton.setMnemonic(I18nUtil.getBundle().getString("CTL_CancelButton_Mnem").charAt(0));
        cancelButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_CancelButton"));
        JButton helpButton = new JButton(I18nUtil.getBundle().getString("CTL_HelpButton"));
        helpButton.setMnemonic(I18nUtil.getBundle().getString("CTL_HelpButton_Mnem").charAt(0));
        helpButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_HelpButton"));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        rightPanel.add(OKButton);
        rightPanel.add(cancelButton);
        rightPanel.add(helpButton);
        helpButton.addActionListener(new ActionListener(){
            static /* synthetic */ Class class$org$netbeans$modules$i18n$InsertI18nStringAction;

            public void actionPerformed(ActionEvent evt) {
                HelpCtx help = new HelpCtx(class$org$netbeans$modules$i18n$InsertI18nStringAction == null ? (class$org$netbeans$modules$i18n$InsertI18nStringAction = 1.class$("org.netbeans.modules.i18n.InsertI18nStringAction")) : class$org$netbeans$modules$i18n$InsertI18nStringAction);
                String sysprop = System.getProperty("org.openide.actions.HelpAction.DEBUG");
                if ("true".equals(sysprop) || "full".equals(sysprop)) {
                    System.err.println("I18n module: Help button showing: " + help);
                }
                TopManager.getDefault().showHelp(help);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        buttonPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        buttonPanel.add((Component)rightPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(17, 12, 11, 11);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        i18nPanel.add((Component)buttonPanel, gridBagConstraints);
        OKButton.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent evt) {
                block9: {
                    try {
                        block8: {
                            try {
                                I18nString i18nString = i18nPanel.getI18nString();
                                if (i18nString.key == null) {
                                    Object var5_4 = null;
                                    break block8;
                                }
                                support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), i18nString.getComment());
                                if (support.hasAdditionalCustomizer()) {
                                    support.performAdditionalChanges();
                                }
                                String code = i18nString.getReplaceString();
                                support.getDocument().insertString(InsertI18nStringAction.this.position, code, null);
                                break block9;
                            }
                            catch (IllegalStateException e) {
                                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("EXC_BadKey"), 0);
                                TopManager.getDefault().notify((NotifyDescriptor)msg);
                                Object var5_6 = null;
                                InsertI18nStringAction.this.cancel();
                                return;
                            }
                            catch (BadLocationException e) {
                                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_CantInsertInGuarded"), 1));
                                Object var5_7 = null;
                                InsertI18nStringAction.this.cancel();
                                return;
                            }
                        }
                        InsertI18nStringAction.this.cancel();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        InsertI18nStringAction.this.cancel();
                        throw throwable;
                    }
                }
                Object var5_5 = null;
                InsertI18nStringAction.this.cancel();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertI18nStringAction.this.cancel();
            }
        });
        return i18nPanel;
    }

    private void addPanel(DataObject sourceDataObject) throws IOException {
        Reuse reuse;
        String PROP_REUSE = "i18n.Reuse";
        TopComponent topComponent = (TopComponent)topComponentWRef.get();
        if (topComponent != null) {
            EditorCookie editor;
            reuse = (Reuse)topComponent.getClientProperty("i18n.Reuse");
            if (reuse.dataObject != sourceDataObject) {
                topComponent = null;
            }
            if (reuse.document != (editor = (EditorCookie)sourceDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = InsertI18nStringAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)).getDocument()) {
                topComponent = null;
            }
        }
        if (topComponent == null) {
            JPanel panel = this.createPanel(sourceDataObject);
            String title = Util.getString("CTL_I18nDialogTitle");
            URL icon = ((Object)((Object)this)).getClass().getResource("i18nAction.gif");
            String name = sourceDataObject.getName();
            topComponent = I18nUtil.createTopComponent(panel, name, title, icon);
            this.cancel();
            Reuse last = new Reuse();
            last.i18nPanel = (I18nPanel)panel;
            last.dataObject = sourceDataObject;
            EditorCookie editor = (EditorCookie)sourceDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = InsertI18nStringAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            last.document = editor.getDocument();
            topComponent.putClientProperty("i18n.Reuse", last);
            topComponentWRef = new WeakReference<TopComponent>(topComponent);
        }
        reuse = (Reuse)topComponent.getClientProperty("i18n.Reuse");
        reuse.i18nPanel.setDefaultResource(sourceDataObject);
        topComponent.open();
        topComponent.requestFocus();
    }

    public void cancel() {
        TopComponent tc = (TopComponent)topComponentWRef.get();
        if (tc != null) {
            tc.close();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes)) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = InsertI18nStringAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dataObject == null) {
            return false;
        }
        return FactoryRegistry.hasFactory(dataObject.getClass());
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = InsertI18nStringAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie};
    }

    public String getName() {
        return I18nUtil.getBundle().getString("CTL_InsertI18nString");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.maninsert");
    }

    protected String iconResource() {
        return "org/netbeans/modules/i18n/insertI18nStringAction.gif";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Reuse {
        I18nPanel i18nPanel;
        DataObject dataObject;
        Document document;

        private Reuse() {
        }
    }
}

