/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.i18n.HelpStringCustomEditor;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class PropertyPanel
extends JPanel {
    private static final String DUMMY_ACTION = "dont_proceed";
    protected I18nString i18nString;
    private JTextArea valueText;
    private JPanel jPanel1;
    private JTextArea commentText;
    private JLabel replaceFormatLabel;
    private JScrollPane valueScroll;
    private JButton replaceFormatButton;
    private JLabel keyLabel;
    private JLabel commentLabel;
    private JComboBox keyBundleCombo;
    private JScrollPane commentScroll;
    private JLabel valueLabel;
    private JTextField replaceFormatTextField;

    public PropertyPanel() {
        this.initComponents();
        this.initAccessibility();
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateAllValues();
    }

    private void updateAllValues() {
        this.updateKey();
        this.updateValue();
        this.updateComment();
        this.updateBundleKeys();
    }

    private void updateKey() {
        String key = this.i18nString.getKey();
        if (key == null || !key.equals(this.keyBundleCombo.getSelectedItem())) {
            String oldActionCommand = this.keyBundleCombo.getActionCommand();
            this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
            this.keyBundleCombo.setSelectedItem(key == null ? "" : key);
            this.keyBundleCombo.setActionCommand(oldActionCommand);
        }
        this.updateReplaceText();
    }

    private void updateValue() {
        String value = this.i18nString.getValue();
        if (!this.valueText.getText().equals(value)) {
            this.valueText.setText(value == null ? "" : value);
        }
        this.updateReplaceText();
    }

    private void updateComment() {
        String comment = this.i18nString.getComment();
        if (!this.commentText.getText().equals(comment)) {
            this.commentText.setText(comment == null ? "" : comment);
        }
    }

    protected void updateReplaceText() {
        this.replaceFormatTextField.setText(this.i18nString.getReplaceString());
    }

    void updateBundleKeys() {
        String oldActionCommand = this.keyBundleCombo.getActionCommand();
        this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
        this.keyBundleCombo.setModel(new DefaultComboBoxModel<String>(this.i18nString.getSupport().getResourceHolder().getAllKeys()));
        this.keyBundleCombo.setActionCommand(oldActionCommand);
        this.updateKey();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_PropertyPanel"));
        this.valueText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_valueText"));
        this.commentText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_commentText"));
        this.replaceFormatButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_Format"));
        this.replaceFormatTextField.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_replaceFormatTextField"));
    }

    private void initComponents() {
        this.commentLabel = new JLabel();
        this.commentScroll = new JScrollPane();
        this.commentText = new JTextArea();
        this.keyLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.valueScroll = new JScrollPane();
        this.valueText = new JTextArea();
        this.keyBundleCombo = new JComboBox();
        this.replaceFormatTextField = new JTextField();
        this.replaceFormatLabel = new JLabel();
        this.replaceFormatButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.commentLabel.setLabelFor(this.commentText);
        this.commentLabel.setText(I18nUtil.getBundle().getString("LBL_Comment"));
        this.commentLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Comment_Mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.commentLabel, gridBagConstraints);
        this.commentText.setColumns(40);
        this.commentText.setRows(3);
        this.commentText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.commentTextFocusLost(evt);
            }
        });
        this.commentScroll.setViewportView(this.commentText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.commentScroll, gridBagConstraints);
        this.keyLabel.setLabelFor(this.keyBundleCombo);
        this.keyLabel.setText(I18nUtil.getBundle().getString("LBL_Key"));
        this.keyLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Key_Mnem").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.keyLabel, gridBagConstraints);
        this.valueLabel.setLabelFor(this.valueText);
        this.valueLabel.setText(I18nUtil.getBundle().getString("LBL_Value"));
        this.valueLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Value_Mnem").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 11, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.valueText.setColumns(40);
        this.valueText.setRows(3);
        this.valueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.valueTextFocusLost(evt);
            }
        });
        this.valueScroll.setViewportView(this.valueText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.add((Component)this.valueScroll, gridBagConstraints);
        this.keyBundleCombo.setEditable(true);
        this.keyBundleCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.keyBundleComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.keyBundleCombo, gridBagConstraints);
        this.replaceFormatTextField.setColumns(40);
        this.replaceFormatTextField.setEditable(false);
        this.replaceFormatTextField.selectAll();
        this.replaceFormatTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PropertyPanel.this.replaceFormatTextFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.replaceFormatTextField, gridBagConstraints);
        this.replaceFormatLabel.setLabelFor(this.replaceFormatTextField);
        this.replaceFormatLabel.setText(I18nUtil.getBundle().getString("LBL_ReplaceFormat"));
        this.replaceFormatLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_ReplaceFormat_Mnem").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.replaceFormatLabel, gridBagConstraints);
        this.replaceFormatButton.setMnemonic(I18nUtil.getBundle().getString("CTL_Format_Mnem").charAt(0));
        this.replaceFormatButton.setText(I18nUtil.getBundle().getString("CTL_Format"));
        this.replaceFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.replaceFormatButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 5, 0, 11);
        this.add((Component)this.replaceFormatButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void replaceFormatTextFieldFocusGained(FocusEvent evt) {
        this.replaceFormatTextField.selectAll();
    }

    private void replaceFormatButtonActionPerformed(ActionEvent evt) {
        final Dialog[] dialogs = new Dialog[1];
        final HelpStringCustomEditor customPanel = new HelpStringCustomEditor(this.i18nString.getReplaceFormat(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), Util.getChar("LBL_ReplaceCodeFormat_mne"), "i18n.pe.replacestring");
        DialogDescriptor dd = new DialogDescriptor((Object)customPanel, I18nUtil.getBundle().getString("LBL_ReplaceStringFormatEditor"), true, 2, NotifyDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() == NotifyDescriptor.OK_OPTION) {
                    String newText = (String)customPanel.getPropertyValue();
                    if (!newText.equals(PropertyPanel.this.replaceFormatTextField.getText())) {
                        PropertyPanel.this.i18nString.setReplaceFormat(newText);
                        PropertyPanel.this.updateReplaceText();
                        I18nUtil.getOptions().setReplaceJavaCode(newText);
                    }
                    ((Component)dialogs[0]).setVisible(false);
                    dialogs[0].dispose();
                } else if (ev.getSource() == NotifyDescriptor.CANCEL_OPTION) {
                    ((Component)dialogs[0]).setVisible(false);
                    dialogs[0].dispose();
                }
            }
        });
        dialogs[0] = TopManager.getDefault().createDialog(dd);
        ((Component)dialogs[0]).setVisible(true);
    }

    private void keyBundleComboActionPerformed(ActionEvent evt) {
        String comment;
        if (DUMMY_ACTION.equals(evt.getActionCommand())) {
            return;
        }
        String key = (String)this.keyBundleCombo.getSelectedItem();
        this.i18nString.setKey(key);
        this.updateKey();
        String value = this.i18nString.getSupport().getResourceHolder().getValueForKey(key);
        if (value != null) {
            this.i18nString.setValue(value);
            this.updateValue();
        }
        if ((comment = this.i18nString.getSupport().getResourceHolder().getCommentForKey(key)) != null) {
            this.i18nString.setComment(comment);
            this.updateComment();
        }
    }

    private void commentTextFocusLost(FocusEvent evt) {
        this.i18nString.setComment(this.commentText.getText());
        this.updateComment();
    }

    private void valueTextFocusLost(FocusEvent evt) {
        this.i18nString.setValue(this.valueText.getText());
        this.updateValue();
    }
}

