/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.Util;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.TopManager;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

final class ResourceWizardPanel
extends JPanel {
    private final Map sourceMap = Util.createWizardSettings();
    private final AbstractTableModel tableModel = new ResourceTableModel();
    private final Panel descPanel;
    private final boolean testMode;
    private JButton addButton;
    private JScrollPane jScrollPane1;
    private JTable resourcesTable;
    private JButton addAllButton;
    private JTextArea descTextArea;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel;

    private ResourceWizardPanel(Panel descPanel, boolean testMode) {
        this.descPanel = descPanel;
        this.testMode = testMode;
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.initAccesibility();
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.tableModel.fireTableDataChanged();
        this.descPanel.fireStateChanged();
    }

    private String getPanelDescription() {
        if (!this.testMode) {
            return Util.getString("MSG_ResourcePanel_desc");
        }
        return Util.getString("MSG_ResourcePanel_test_desc");
    }

    private void postInitComponents() {
        this.addAllButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_SelectResourceAll_Mnem").charAt(0));
        this.addButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_SelectResource_Mnem").charAt(0));
    }

    private void initTable() {
        this.resourcesTable.setDefaultRenderer(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourceWizardPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DataObject dataObject = (DataObject)value;
                if (dataObject != null) {
                    label.setText(dataObject.getPrimaryFile().getPackageName('.'));
                    label.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
                } else {
                    label.setText("");
                    label.setIcon(null);
                }
                return label;
            }
        });
        this.resourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ResourceWizardPanel.this.addButton.setEnabled(!ResourceWizardPanel.this.resourcesTable.getSelectionModel().isSelectionEmpty());
            }
        });
        this.addButton.setEnabled(!this.resourcesTable.getSelectionModel().isSelectionEmpty());
    }

    private void initAccesibility() {
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("ACS_CTL_SelectResource"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("ACS_CTL_SelectResourceAll"));
        this.resourcesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("ACS_resourcesTable"));
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.resourcesTable = new JTable();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.descTextArea.setColumns(20);
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(this.getPanelDescription());
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(new JLabel().getForeground());
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.resourcesTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.resourcesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addAllButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_SelectResourceAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceWizardPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addAllButton, gridBagConstraints);
        this.addButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_SelectResource"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceWizardPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        DataObject resource = this.selectResource();
        if (resource == null) {
            return;
        }
        int[] selectedRows = this.resourcesTable.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            DataObject dataObject = (DataObject)this.resourcesTable.getValueAt(selectedRows[i], 0);
            Object support = null;
            this.sourceMap.put(dataObject, new SourceData(resource));
            this.tableModel.fireTableCellUpdated(selectedRows[i], 1);
            ++i;
        }
        this.descPanel.fireStateChanged();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        DataObject resource = this.selectResource();
        if (resource == null) {
            return;
        }
        int i = 0;
        while (i < this.resourcesTable.getRowCount()) {
            DataObject dataObject = (DataObject)this.resourcesTable.getValueAt(i, 0);
            Object support = null;
            this.sourceMap.put(dataObject, new SourceData(resource));
            this.tableModel.fireTableCellUpdated(i, 1);
            ++i;
        }
        this.descPanel.fireStateChanged();
    }

    private DataObject selectResource() {
        DataFilter dataFilter = new DataFilter(){
            static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesDataObject;

            public boolean acceptDataObject(DataObject dataObject) {
                return dataObject instanceof DataFolder || dataObject.getClass().equals(class$org$netbeans$modules$properties$PropertiesDataObject == null ? (class$org$netbeans$modules$properties$PropertiesDataObject = 5.class$("org.netbeans.modules.properties.PropertiesDataObject")) : class$org$netbeans$modules$properties$PropertiesDataObject);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        Node repositoryNode = TopManager.getDefault().getPlaces().nodes().repository(dataFilter);
        try {
            Node[] selectedNodes = TopManager.getDefault().getNodeOperation().select(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("LBL_SelectResource"), NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("LBL_Filesystems"), repositoryNode, new NodeAcceptor(){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;
                static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesDataObject;

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes == null || nodes.length != 1) {
                        return false;
                    }
                    DataObject dataObject = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 6.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dataObject == null) {
                        return false;
                    }
                    return dataObject.getClass().equals(class$org$netbeans$modules$properties$PropertiesDataObject == null ? (class$org$netbeans$modules$properties$PropertiesDataObject = 6.class$("org.netbeans.modules.properties.PropertiesDataObject")) : class$org$netbeans$modules$properties$PropertiesDataObject);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            return (DataObject)selectedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourceWizardPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        catch (UserCancelException uce) {
            if (I18nUtil.isDebug()) {
                System.err.println("I18N module: User cancelled selection");
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements I18nWizardDescriptor.ProgressMonitor {
        private final ResourceWizardPanel resourcePanel;
        private boolean testWizard;
        static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel;

        public Panel() {
            this(false);
        }

        public Panel(boolean testWizard) {
            this.testWizard = testWizard;
            this.resourcePanel = new ResourceWizardPanel(this, testWizard);
        }

        protected Component createComponent() {
            JPanel panel = new JPanel();
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("ACS_ResourceWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.testWizard) {
                panel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SelectTestResource"));
            } else {
                panel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SelectResource"));
            }
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            panel.add((Component)this.resourcePanel, constraints);
            return panel;
        }

        public boolean isValid() {
            return !this.resourcePanel.getSourceMap().containsValue(null);
        }

        public void readSettings(Object settings) {
            this.resourcePanel.setSourceMap((Map)settings);
        }

        public void storeSettings(Object settings) {
            ((Map)settings).clear();
            ((Map)settings).putAll(this.resourcePanel.getSourceMap());
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressPanel = new ProgressWizardPanel(false);
            this.showProgressPanel(progressPanel);
            progressPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_Loading"));
            progressPanel.setMainProgress(0);
            Map sourceMap = this.resourcePanel.getSourceMap();
            Iterator sourceIterator = sourceMap.keySet().iterator();
            int i = 0;
            while (sourceIterator.hasNext()) {
                block9: {
                    DataObject source = (DataObject)sourceIterator.next();
                    progressPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? Panel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel") : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_Loading") + " " + source.getPrimaryFile().getPackageName('.'));
                    SourceData sourceData = (SourceData)sourceMap.get(source);
                    I18nSupport support = sourceData.getSupport();
                    if (support == null) {
                        try {
                            support = FactoryRegistry.getFactory(source.getClass()).create(source);
                        }
                        catch (IOException ioe) {
                            if (I18nUtil.isDebug()) {
                                System.err.println("I18N: Document could not be loaded for " + source.getName());
                            }
                            sourceMap.remove(source);
                            break block9;
                        }
                        sourceData = new SourceData(sourceData.getResource(), support);
                        sourceMap.put(source, sourceData);
                    }
                    progressPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? Panel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel") : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SearchingIn") + " " + source.getPrimaryFile().getPackageName('.'));
                    Map stringMap = sourceData.getStringMap();
                    HardCodedString[] foundStrings = this.testWizard ? support.getFinder().findAllI18nStrings() : support.getFinder().findAllHardCodedStrings();
                    if (foundStrings == null) {
                        sourceData.setStringMap(new HashMap(0));
                    } else {
                        HashMap<HardCodedString, I18nString> map = new HashMap<HardCodedString, I18nString>(foundStrings.length);
                        int j = 0;
                        while (j < foundStrings.length) {
                            if (!this.testWizard || support.getResourceHolder().getValueForKey(UtilConvert.escapePropertiesSpecialChars((String)foundStrings[j].getText())) == null) {
                                map.put(foundStrings[j], support.getDefaultI18nString(foundStrings[j]));
                            }
                            ++j;
                        }
                        progressPanel.setMainProgress((int)((float)(i + 1) / (float)sourceMap.size() * 100.0f));
                        sourceData.setStringMap(map);
                    }
                }
                ++i;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressPanel) {
            ((Container)this.getComponent()).remove(this.resourcePanel);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressPanel, constraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.resourcePanel)) {
                container.removeAll();
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                container.add((Component)this.resourcePanel, constraints);
            }
        }

        public HelpCtx getHelp() {
            if (this.testWizard) {
                return new HelpCtx("internation.testing");
            }
            return new HelpCtx("internation.wizard");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ResourceTableModel
    extends AbstractTableModel {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel;

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ResourceWizardPanel.this.sourceMap.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ResourceWizardPanel.this.sourceMap.keySet().toArray()[rowIndex];
            }
            SourceData value = (SourceData)ResourceWizardPanel.this.sourceMap.values().toArray()[rowIndex];
            return value == null ? null : value.getResource();
        }

        public Class getColumnClass(int columnIndex) {
            return class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourceTableModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceTableModel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_Source");
            }
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceTableModel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_Resource");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

