/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.util.TreeMap;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.modules.web.jspparser.AnalyzerParseEventListener;
import org.openide.TopManager;

public class TagLibDataImpl
extends TagLibParseSupport.TagLibData {
    private String prefix;
    private TagLibraryInfo tagLibraryInfo;
    private TreeMap tagMap = new TreeMap();

    public TagLibDataImpl(JspInfo.TagLibraryData tagLibraryData) {
        this.prefix = tagLibraryData.getPrefix();
        this.tagLibraryInfo = tagLibraryData instanceof AnalyzerParseEventListener.TagLibraryDataImpl ? ((AnalyzerParseEventListener.TagLibraryDataImpl)tagLibraryData).getTagLibraryInfo() : null;
        this.createTagMap();
    }

    private void createTagMap() {
        if (this.tagLibraryInfo != null) {
            TagInfo[] tagInfoArray = this.tagLibraryInfo.getTags();
            if (tagInfoArray == null) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)new IllegalStateException(this.tagLibraryInfo.getURI()));
                return;
            }
            int n = 0;
            while (n < tagInfoArray.length) {
                if (tagInfoArray[n] != null) {
                    String string = tagInfoArray[n].getTagName();
                    this.tagMap.put(string, new TagData(string, tagInfoArray[n].getBodyContent()));
                } else {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)new NullPointerException(this.tagLibraryInfo.toString()));
                }
                ++n;
            }
        }
    }

    public boolean equalsColoringInformation(TagLibParseSupport.TagLibData tagLibData) {
        TagData[] tagDataArray;
        if (!(tagLibData instanceof TagLibDataImpl)) {
            return false;
        }
        TagLibDataImpl tagLibDataImpl = (TagLibDataImpl)tagLibData;
        if (!this.prefix.equals(tagLibDataImpl.prefix)) {
            return false;
        }
        TagData[] tagDataArray2 = this.getTagData();
        if (tagDataArray2.length != (tagDataArray = tagLibDataImpl.getTagData()).length) {
            return false;
        }
        int n = 0;
        while (n < tagDataArray2.length) {
            if (!tagDataArray2[n].equalsColoringInformation(tagDataArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TagData[] getTagData() {
        return this.tagMap.values().toArray(new TagData[this.tagMap.size()]);
    }

    public TagData getTagData(String string) {
        return (TagData)this.tagMap.get(string);
    }

    public Object getTagLibraryInfo() {
        return this.tagLibraryInfo;
    }

    public static class TagData {
        private String tagName;
        private String bodyContent;

        public TagData(String string, String string2) {
            this.tagName = string;
            this.bodyContent = string2;
        }

        boolean equalsColoringInformation(TagData tagData) {
            return this.tagName.equals(tagData.tagName) && this.bodyContent.equals(tagData.bodyContent);
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getBodyContent() {
            return this.bodyContent;
        }
    }
}

