/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import org.netbeans.modules.beans.PatternNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;

class EventSetInheritanceAnalyser {
    EventSetInheritanceAnalyser() {
    }

    static MemberElement detectPropertyChangeSupport(ClassElement classElement) {
        return EventSetInheritanceAnalyser.findSupport(classElement, "java.beans.PropertyChangeSupport");
    }

    static MemberElement detectVetoableChangeSupport(ClassElement classElement) {
        return EventSetInheritanceAnalyser.findSupport(classElement, "java.beans.VetoableChangeSupport");
    }

    private static MemberElement findSupport(ClassElement classElement, String string) {
        Identifier identifier = null;
        if (classElement == null || classElement.getName().getFullName().equals("java.lang.Object")) {
            return null;
        }
        Identifier identifier2 = classElement.getSuperclass();
        if (identifier2 == null) {
            return null;
        }
        ClassElement classElement2 = ClassElement.forName((String)identifier2.getFullName());
        if (classElement2 == null) {
            return classElement2;
        }
        if (identifier == null) {
            identifier = Identifier.create((String)string);
        }
        MethodElement[] methodElementArray = classElement2.getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            if (!Modifier.isPrivate(methodElementArray[n].getModifiers()) && methodElementArray[n].getParameters().length == 0 && !methodElementArray[n].getReturn().isPrimitive() && !methodElementArray[n].getReturn().isArray() && methodElementArray[n].getReturn().getClassName().compareTo(identifier, false)) {
                return methodElementArray[n];
            }
            ++n;
        }
        FieldElement[] fieldElementArray = classElement2.getFields();
        int n2 = 0;
        while (n2 < fieldElementArray.length) {
            if (!Modifier.isPrivate(fieldElementArray[n2].getModifiers()) && !fieldElementArray[n2].getType().isPrimitive() && !fieldElementArray[n2].getType().isArray() && fieldElementArray[n2].getType().getClassName().compareTo(identifier, false)) {
                return fieldElementArray[n2];
            }
            ++n2;
        }
        return EventSetInheritanceAnalyser.findSupport(classElement2, string);
    }

    static String showInheritanceEventDialog(MemberElement memberElement, String string) {
        String string2 = EventSetInheritanceAnalyser.getInheritanceEventSupportName(memberElement, string);
        if (memberElement != null) {
            Object[] objectArray = new Object[]{memberElement.getDeclaringClass().getName().getFullName(), string};
            String string3 = MessageFormat.format(PatternNode.getString("MSG_Inheritance_Found"), objectArray);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string3, 0);
            TopManager.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return string2;
            }
        }
        return null;
    }

    static String getInheritanceEventSupportName(MemberElement memberElement, String string) {
        ElementFormat elementFormat = new ElementFormat("{n}({p})");
        String string2 = null;
        if (memberElement != null) {
            string2 = memberElement instanceof MethodElement ? elementFormat.format((Element)((MethodElement)memberElement)) : memberElement.getName().getFullName();
        }
        return string2;
    }
}

