/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.Utilities;

public class EventSetPattern
extends Pattern {
    static final String[] WELL_KNOWN_LISTENERS = new String[]{"java.awt.event.ActionListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.WindowListener", "java.beans.PropertyChangeListener", "java.beans.VetoableChangeListener", "javax.swing.event.CaretListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeModelListener", "javax.swing.event.UndoableEditListener"};
    protected MethodElement addListenerMethod = null;
    protected MethodElement removeListenerMethod = null;
    private Type type;
    private boolean isUnicast = false;
    private ClassElement typeElement;
    protected String name;

    public EventSetPattern(PatternAnalyser patternAnalyser, MethodElement methodElement, MethodElement methodElement2) throws IntrospectionException {
        super(patternAnalyser);
        if (methodElement == null || methodElement2 == null) {
            throw new InternalError();
        }
        this.addListenerMethod = methodElement;
        this.removeListenerMethod = methodElement2;
        this.isUnicast = this.testUnicast();
        this.findEventSetType();
        this.name = this.findEventSetName();
        this.typeElement = ClassElement.forName((String)this.type.getClassName().getFullName());
    }

    private EventSetPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static EventSetPattern create(PatternAnalyser patternAnalyser, String string, String string2, boolean bl) throws SourceException {
        EventSetPattern eventSetPattern = new EventSetPattern(patternAnalyser);
        eventSetPattern.name = string;
        eventSetPattern.type = Type.parse((String)string2);
        eventSetPattern.isUnicast = bl;
        eventSetPattern.generateAddListenerMethod();
        eventSetPattern.generateRemoveListenerMethod();
        return eventSetPattern;
    }

    static EventSetPattern create(PatternAnalyser patternAnalyser, String string, int n, boolean bl, boolean bl2, boolean bl3) throws SourceException {
        ClassElement classElement;
        EventSetPattern eventSetPattern = new EventSetPattern(patternAnalyser);
        eventSetPattern.type = Type.parse((String)string);
        if (eventSetPattern.type == null || !eventSetPattern.type.isClass()) {
            return null;
        }
        eventSetPattern.name = Introspector.decapitalize(eventSetPattern.type.getClassName().getName());
        eventSetPattern.isUnicast = bl3;
        String string2 = null;
        if (n == 1) {
            if (bl3) {
                BeanPatternGenerator.unicastListenerField(eventSetPattern.getDeclaringClass(), eventSetPattern.type);
            } else {
                BeanPatternGenerator.listenersArrayListField(eventSetPattern.getDeclaringClass(), eventSetPattern.type);
            }
        } else if (n == 2 && !bl3) {
            string2 = BeanPatternGenerator.eventListenerListField(eventSetPattern.getDeclaringClass(), eventSetPattern.type);
        }
        if (bl3) {
            eventSetPattern.generateAddListenerMethod(BeanPatternGenerator.ucAddBody(eventSetPattern.type, n), true);
            eventSetPattern.generateRemoveListenerMethod(BeanPatternGenerator.ucRemoveBody(eventSetPattern.type, n), true);
        } else {
            eventSetPattern.generateAddListenerMethod(BeanPatternGenerator.mcAddBody(eventSetPattern.type, n, string2), true);
            eventSetPattern.generateRemoveListenerMethod(BeanPatternGenerator.mcRemoveBody(eventSetPattern.type, n, string2), true);
        }
        if (bl && (classElement = ClassElement.forName((String)string.toString())) != null) {
            MethodElement[] methodElementArray = classElement.getMethods();
            int n2 = 0;
            while (n2 < methodElementArray.length) {
                if ((methodElementArray[n2].getModifiers() & 1) != 0) {
                    if (bl3) {
                        BeanPatternGenerator.unicastFireMethod(eventSetPattern.getDeclaringClass(), eventSetPattern.type, methodElementArray[n2], n, bl2);
                    } else {
                        BeanPatternGenerator.fireMethod(eventSetPattern.getDeclaringClass(), eventSetPattern.type, methodElementArray[n2], n, string2, bl2);
                    }
                }
                ++n2;
            }
        }
        return eventSetPattern;
    }

    public ClassElement getTypeElement() {
        return this.typeElement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws SourceException {
        if (!Utilities.isJavaIdentifier((String)string) || string.indexOf("Listener") <= 0) {
            throw new SourceException("Invalid event source name");
        }
        string = Pattern.capitalizeFirstLetter(string);
        Identifier identifier = Identifier.create((String)("add" + string));
        Identifier identifier2 = Identifier.create((String)("remove" + string));
        this.addListenerMethod.setName(identifier);
        this.removeListenerMethod.setName(identifier2);
        this.name = Introspector.decapitalize(string);
    }

    protected static boolean isValidName(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            return false;
        }
        return string.indexOf("Listener") > 0;
    }

    public boolean isUnicast() {
        return this.isUnicast;
    }

    public void setIsUnicast(boolean bl) throws SourceException {
        if (bl != this.isUnicast) {
            Identifier identifier = Identifier.create((String)"java.util.TooManyListenersException");
            Identifier[] identifierArray = this.addListenerMethod.getExceptions();
            if (bl) {
                Identifier[] identifierArray2 = new Identifier[identifierArray.length + 1];
                System.arraycopy(identifierArray, 0, identifierArray2, 0, identifierArray.length);
                identifierArray2[identifierArray.length] = identifier;
                this.addListenerMethod.setExceptions(identifierArray2);
            } else {
                Identifier[] identifierArray3 = new Identifier[identifierArray.length - 1];
                int n = 0;
                int n2 = 0;
                while (n2 < identifierArray.length) {
                    if (!identifierArray[n2].compareTo(identifier, false)) {
                        identifierArray3[n2 - n] = identifierArray[n2];
                    } else {
                        n = 1;
                    }
                    ++n2;
                }
                this.addListenerMethod.setExceptions(identifierArray3);
            }
        }
        this.isUnicast = bl;
    }

    public MethodElement getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public MethodElement getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) throws SourceException {
        if (type.compareTo(this.type, true)) {
            return;
        }
        if (!PatternAnalyser.isSubclass(ClassElement.forName((String)type.getClassName().getFullName()), ClassElement.forName((String)"java.util.EventListener"))) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_InvalidListenerInterface"), 0));
            return;
        }
        MethodParameter[] methodParameterArray = this.addListenerMethod.getParameters();
        if (methodParameterArray.length > 0) {
            methodParameterArray[0].setType(type);
            this.addListenerMethod.setParameters(methodParameterArray);
        }
        if ((methodParameterArray = this.removeListenerMethod.getParameters()).length > 0) {
            methodParameterArray[0].setType(type);
            this.removeListenerMethod.setParameters(methodParameterArray);
        }
        String string = MessageFormat.format(PatternNode.getString("FMT_ChangeEventSourceName"), Pattern.capitalizeFirstLetter(type.getClassName().getName()));
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
        if (TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
            this.setName(type.getClassName().getName());
        }
        this.type = type;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (this.addListenerMethod != null) {
            return this.addListenerMethod.getCookie(clazz);
        }
        if (this.removeListenerMethod != null) {
            return this.removeListenerMethod.getCookie(clazz);
        }
        return null;
    }

    public void destroy() throws SourceException {
        ClassElement classElement;
        if (this.addListenerMethod != null) {
            classElement = this.addListenerMethod.getDeclaringClass();
            if (classElement == null) {
                throw new SourceException();
            }
            classElement.removeMethod(this.addListenerMethod);
        }
        if (this.removeListenerMethod != null) {
            classElement = this.removeListenerMethod.getDeclaringClass();
            if (classElement == null) {
                throw new SourceException();
            }
            classElement.removeMethod(this.removeListenerMethod);
        }
        classElement = this.getDeclaringClass();
        ClassElement classElement2 = ClassElement.forName((String)this.type.toString());
        boolean bl = false;
        if (classElement2 != null) {
            MethodElement[] methodElementArray = classElement2.getMethods();
            MethodElement[] methodElementArray2 = classElement.getMethods();
            int n = 0;
            while (n < methodElementArray.length) {
                String string = "fire" + Pattern.capitalizeFirstLetter(this.type.getClassName().getName()) + Pattern.capitalizeFirstLetter(methodElementArray[n].getName().getName());
                if ((methodElementArray[n].getModifiers() & 1) != 0) {
                    int n2 = 0;
                    while (n2 < methodElementArray2.length) {
                        if (methodElementArray2[n2].getName().getName().equals(string)) {
                            if (!bl) {
                                String string2 = MessageFormat.format(PatternNode.getString("FMT_DeleteFire"), new Object[0]);
                                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0);
                                if (TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.NO_OPTION)) {
                                    return;
                                }
                                bl = true;
                            }
                            classElement.removeMethod(methodElementArray2[n2]);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    EventSetPattern(EventSetPattern eventSetPattern, EventSetPattern eventSetPattern2) {
        super(eventSetPattern2.patternAnalyser);
        this.addListenerMethod = eventSetPattern2.addListenerMethod;
        this.removeListenerMethod = eventSetPattern2.removeListenerMethod;
        this.isUnicast = eventSetPattern2.isUnicast;
        this.type = eventSetPattern2.type;
        this.name = eventSetPattern2.name;
    }

    private void findEventSetType() throws IntrospectionException {
        if (this.addListenerMethod == null) {
            throw new InternalError("add method == nul in event set pattern");
        }
        this.type = this.addListenerMethod.getParameters()[0].getType();
    }

    private String findEventSetName() {
        String string = this.addListenerMethod.getName().getName().substring(3);
        this.name = Introspector.decapitalize(string);
        return this.name;
    }

    private boolean testUnicast() {
        return this.findTooManyListenersException() != null;
    }

    Identifier findTooManyListenersException() {
        Identifier identifier = Identifier.create((String)"java.util.TooManyListenersException");
        Identifier[] identifierArray = this.addListenerMethod.getExceptions();
        int n = 0;
        while (n < identifierArray.length) {
            if (identifierArray[n].compareTo(identifier, false)) {
                return identifierArray[n];
            }
            ++n;
        }
        return null;
    }

    void generateAddListenerMethod() throws SourceException {
        this.generateAddListenerMethod(null, false);
    }

    void generateAddListenerMethod(String string, boolean bl) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        MethodElement methodElement = new MethodElement();
        MethodParameter[] methodParameterArray = new MethodParameter[]{new MethodParameter("listener", this.type, false)};
        methodElement.setName(Identifier.create((String)("add" + Pattern.capitalizeFirstLetter(this.getName()))));
        methodElement.setReturn(Type.VOID);
        methodElement.setModifiers(33);
        methodElement.setParameters(methodParameterArray);
        if (classElement.isInterface()) {
            methodElement.setBody(null);
        } else if (string != null) {
            methodElement.setBody(string);
        }
        if (this.isUnicast) {
            methodElement.setExceptions(new Identifier[]{Identifier.create((String)"java.util.TooManyListenersException")});
        }
        if (bl) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_AddListenerMethod"), this.type.getClassName().getName());
            methodElement.getJavaDoc().setRawText(string2);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.addMethod(methodElement);
        this.addListenerMethod = methodElement;
    }

    void generateRemoveListenerMethod() throws SourceException {
        this.generateRemoveListenerMethod(null, false);
    }

    void generateRemoveListenerMethod(String string, boolean bl) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        MethodElement methodElement = new MethodElement();
        MethodParameter[] methodParameterArray = new MethodParameter[]{new MethodParameter("listener", this.type, false)};
        methodElement.setName(Identifier.create((String)("remove" + Pattern.capitalizeFirstLetter(this.getName()))));
        methodElement.setReturn(Type.VOID);
        methodElement.setModifiers(33);
        methodElement.setParameters(methodParameterArray);
        if (classElement.isInterface()) {
            methodElement.setBody(null);
        } else if (string != null) {
            methodElement.setBody(string);
        }
        if (bl) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_RemoveListenerMethod"), this.type.getClassName().getName());
            methodElement.getJavaDoc().setRawText(string2);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.addMethod(methodElement);
        this.removeListenerMethod = methodElement;
    }

    void copyProperties(EventSetPattern eventSetPattern) {
        boolean bl;
        boolean bl2 = bl = !eventSetPattern.getType().equals((Object)this.getType()) || !eventSetPattern.getName().equals(this.getName()) || eventSetPattern.isUnicast() != this.isUnicast();
        if (eventSetPattern.getAddListenerMethod() != this.addListenerMethod) {
            this.addListenerMethod = eventSetPattern.getAddListenerMethod();
        }
        if (eventSetPattern.getRemoveListenerMethod() != this.removeListenerMethod) {
            this.removeListenerMethod = eventSetPattern.getRemoveListenerMethod();
        }
        if (bl) {
            this.isUnicast = this.testUnicast();
            try {
                this.findEventSetType();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            this.isUnicast = this.testUnicast();
            this.name = this.findEventSetName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

