/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.beans.PatternGroupNode;
import org.netbeans.modules.beans.PatternNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class IdxPropertyPatternPanel
extends JPanel
implements ActionListener {
    private Dialog dialog;
    private PatternGroupNode groupNode;
    private boolean forInterface = false;
    private final String[] types = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "String"};
    private final String[] modes = new String[]{PatternNode.getString("LAB_ReadWriteMODE"), PatternNode.getString("LAB_ReadOnlyMODE"), PatternNode.getString("LAB_WriteOnlyMODE")};
    static final long serialVersionUID = 8551245035767258531L;
    private JLabel nameLabel;
    private JCheckBox returnCheckBox;
    private JComboBox modeComboBox;
    private JCheckBox boundCheckBox;
    private JLabel modeLabel;
    private JLabel typeLabel;
    private JCheckBox supportCheckBox;
    private JCheckBox niReturnCheckBox;
    private JCheckBox niGetterCheckBox;
    private JCheckBox fieldCheckBox;
    private JPanel optionsPanel;
    private JCheckBox niSetterCheckBox;
    private JPanel nonIndexOptionsPanel;
    private JCheckBox setCheckBox;
    private JCheckBox constrainedCheckBox;
    private JCheckBox niSetCheckBox;
    private JPanel propertyPanel;
    private JPanel jPanel4;
    private JPanel jPanel3;
    private JPanel mainPanel;
    private JComboBox typeComboBox;
    private JTextField nameTextField;

    public IdxPropertyPatternPanel() {
        this.initComponents();
        this.initAccessibility();
        int n = 0;
        while (n < this.types.length) {
            this.typeComboBox.addItem(this.types[n]);
            ++n;
        }
        this.typeComboBox.setSelectedItem("");
        int n2 = 0;
        while (n2 < this.modes.length) {
            this.modeComboBox.addItem(this.modes[n2]);
            ++n2;
        }
        this.modeComboBox.setSelectedItem(this.modes[0]);
        ((TitledBorder)this.propertyPanel.getBorder()).setTitle(PatternNode.getString("CTL_IdxPropertyPanel_propertyPanel"));
        ((TitledBorder)this.optionsPanel.getBorder()).setTitle(PatternNode.getString("CTL_IdxPropertyPanel_optionsPanel"));
        ((TitledBorder)this.nonIndexOptionsPanel.getBorder()).setTitle(PatternNode.getString("CTL_IdxPropertyPanel_niOptionsPanel"));
        this.nameLabel.setText(PatternNode.getString("CTL_IdxPropertyPanel_nameLabel"));
        this.nameLabel.setDisplayedMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_nameLabel_Mnemonic").charAt(0));
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_nameTextFieldA11yDesc"));
        this.typeLabel.setText(PatternNode.getString("CTL_IdxPropertyPanel_typeLabel"));
        this.typeLabel.setDisplayedMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_typeLabel_Mnemonic").charAt(0));
        this.typeLabel.setLabelFor(this.typeComboBox);
        this.typeComboBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_typeComboBoxA11yDesc"));
        this.modeLabel.setText(PatternNode.getString("CTL_IdxPropertyPanel_modeLabel"));
        this.modeLabel.setDisplayedMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_modeLabel_Mnemonic").charAt(0));
        this.modeLabel.setLabelFor(this.modeComboBox);
        this.modeComboBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_modeComboBoxA11yDesc"));
        this.boundCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_boundCheckBox"));
        this.boundCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_boundCheckBox_Mnemonic").charAt(0));
        this.boundCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_boundCheckBoxA11yDesc"));
        this.constrainedCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_constrainedCheckBox"));
        this.constrainedCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_constrainedCheckBox_Mnemonic").charAt(0));
        this.constrainedCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_constrainedCheckBoxA11yDesc"));
        this.fieldCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_fieldCheckBox"));
        this.fieldCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_fieldCheckBox_Mnemonic").charAt(0));
        this.fieldCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_fieldCheckBoxA11yDesc"));
        this.returnCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_returnCheckBox"));
        this.returnCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_returnCheckBox_Mnemonic").charAt(0));
        this.returnCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_returnCheckBoxA11yDesc"));
        this.setCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_setCheckBox"));
        this.setCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_setCheckBox_Mnemonic").charAt(0));
        this.setCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_setCheckBoxA11yDesc"));
        this.supportCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_supportCheckBox"));
        this.supportCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_supportCheckBox_Mnemonic").charAt(0));
        this.supportCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_supportCheckBoxA11yDesc"));
        this.niGetterCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_niGetterCheckBox"));
        this.niGetterCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_niGetterCheckBox_Mnemonic").charAt(0));
        this.niGetterCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_niGetterCheckBoxA11yDesc"));
        this.niReturnCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_niReturnCheckBox"));
        this.niReturnCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_niReturnCheckBox_Mnemonic").charAt(0));
        this.niReturnCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_niReturnCheckBoxA11yDesc"));
        this.niSetterCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_niSetterCheckBox"));
        this.niSetterCheckBox.setMnemonic(PatternNode.getString("ACS_IdxPropertyPanel_niSetterCheckBoxA11yDesc").charAt(0));
        this.niSetterCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_boundCheckBoxA11yDesc"));
        this.niSetCheckBox.setText(PatternNode.getString("CTL_IdxPropertyPanel_niSetCheckBox"));
        this.niSetCheckBox.setMnemonic(PatternNode.getString("CTL_IdxPropertyPanel_niSetCheckBox_Mnemonic").charAt(0));
        this.niSetCheckBox.setToolTipText(PatternNode.getString("ACS_IdxPropertyPanel_niSetCheckBoxA11yDesc"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"beans.properties");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACSD_PropertyPanelDialog"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_IdxPropertyPanel_nameLabelA11yDesc"));
        this.nameTextField.getAccessibleContext().setAccessibleName(PatternNode.getString("ACS_IdxPropertyPanel_nameTextFieldA11yName"));
        this.typeLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_IdxPropertyPanel_typeLabelA11yDesc"));
        this.typeComboBox.getAccessibleContext().setAccessibleName(PatternNode.getString("ACS_IdxPropertyPanel_typeComboBoxA11yName"));
        this.modeLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_IdxPropertyPanel_modeLabelA11yDesc"));
        this.modeComboBox.getAccessibleContext().setAccessibleName(PatternNode.getString("ACS_IdxPropertyPanel_modeComboBoxA11yName"));
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.propertyPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.modeLabel = new JLabel();
        this.modeComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.boundCheckBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.constrainedCheckBox = new JCheckBox();
        this.optionsPanel = new JPanel();
        this.fieldCheckBox = new JCheckBox();
        this.returnCheckBox = new JCheckBox();
        this.setCheckBox = new JCheckBox();
        this.supportCheckBox = new JCheckBox();
        this.nonIndexOptionsPanel = new JPanel();
        this.niGetterCheckBox = new JCheckBox();
        this.niReturnCheckBox = new JCheckBox();
        this.niSetterCheckBox = new JCheckBox();
        this.niSetCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.propertyPanel.setLayout(new GridBagLayout());
        this.propertyPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "propertyPanel", 0, 0, new Font("Dialog", 0, 11), Color.black));
        this.nameLabel.setText("nameLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.propertyPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.typeLabel.setText("typeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.propertyPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.typeComboBox, gridBagConstraints);
        this.modeLabel.setText("modeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.propertyPanel.add((Component)this.modeLabel, gridBagConstraints);
        this.modeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdxPropertyPatternPanel.this.modeComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.modeComboBox, gridBagConstraints);
        this.propertyPanel.add((Component)this.jPanel3, new GridBagConstraints());
        this.boundCheckBox.setText("boundCheckBox");
        this.boundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdxPropertyPatternPanel.this.boundCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.boundCheckBox, gridBagConstraints);
        this.propertyPanel.add((Component)this.jPanel4, new GridBagConstraints());
        this.constrainedCheckBox.setText("constrainedCheckBox");
        this.constrainedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdxPropertyPatternPanel.this.constrainedCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.constrainedCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.propertyPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "optionsPanel", 0, 0, new Font("Dialog", 0, 11), Color.black));
        this.fieldCheckBox.setText("fieldCheckBox");
        this.fieldCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdxPropertyPatternPanel.this.fieldCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.fieldCheckBox, gridBagConstraints);
        this.returnCheckBox.setText("returnCheckBox");
        this.returnCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.returnCheckBox, gridBagConstraints);
        this.setCheckBox.setText("setCheckBox");
        this.setCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.setCheckBox, gridBagConstraints);
        this.supportCheckBox.setText("supportCheckBox");
        this.supportCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.supportCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.nonIndexOptionsPanel.setLayout(new GridBagLayout());
        this.nonIndexOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "nonIndexOptionsPanel", 0, 0, new Font("Dialog", 0, 11), Color.black));
        this.niGetterCheckBox.setText("niGetterCheckBox");
        this.niGetterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdxPropertyPatternPanel.this.niGetterCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.nonIndexOptionsPanel.add((Component)this.niGetterCheckBox, gridBagConstraints);
        this.niReturnCheckBox.setText("niReturnCheckBox");
        this.niReturnCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.nonIndexOptionsPanel.add((Component)this.niReturnCheckBox, gridBagConstraints);
        this.niSetterCheckBox.setText("niSetterCheckBox");
        this.niSetterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdxPropertyPatternPanel.this.niSetterCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.nonIndexOptionsPanel.add((Component)this.niSetterCheckBox, gridBagConstraints);
        this.niSetCheckBox.setText("niSetCheckBox");
        this.niSetCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.nonIndexOptionsPanel.add((Component)this.niSetCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.nonIndexOptionsPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void niSetterCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void niGetterCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void fieldCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void constrainedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void boundCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void modeComboBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    Result getResult() {
        Result result = new Result();
        result.name = this.nameTextField.getText();
        result.type = this.typeComboBox.getEditor().getItem().toString();
        result.mode = this.modeComboBox.getSelectedItem().toString().equals(this.modes[1]) ? 2 : (this.modeComboBox.getSelectedItem().toString().equals(this.modes[2]) ? 4 : 1);
        if (this.boundCheckBox.isSelected()) {
            result.bound = true;
        }
        if (this.constrainedCheckBox.isSelected()) {
            result.constrained = true;
        }
        if (this.fieldCheckBox.isSelected()) {
            result.withField = true;
        }
        if (this.returnCheckBox.isSelected() && this.fieldCheckBox.isSelected()) {
            result.withReturn = true;
        }
        if (this.setCheckBox.isSelected() && this.fieldCheckBox.isSelected()) {
            result.withSet = true;
        }
        if (this.supportCheckBox.isSelected()) {
            result.withSupport = true;
        }
        if (this.niGetterCheckBox.isSelected()) {
            result.niGetter = true;
        }
        if (this.niReturnCheckBox.isSelected() && this.fieldCheckBox.isSelected()) {
            result.niWithReturn = true;
        }
        if (this.niSetterCheckBox.isSelected()) {
            result.niSetter = true;
        }
        if (this.niSetCheckBox.isSelected() && this.fieldCheckBox.isSelected()) {
            result.niWithSet = true;
        }
        return result;
    }

    private void protectControls() {
        Result result = this.getResult();
        this.fieldCheckBox.setEnabled(!this.forInterface);
        this.returnCheckBox.setEnabled((result.mode == 1 || result.mode == 2) && result.withField && !this.forInterface);
        this.setCheckBox.setEnabled((result.mode == 1 || result.mode == 4) && result.withField && !this.forInterface);
        this.supportCheckBox.setEnabled((result.bound || result.constrained) && !this.forInterface);
        this.niGetterCheckBox.setEnabled(!this.forInterface);
        this.niSetterCheckBox.setEnabled(!this.forInterface);
        this.niReturnCheckBox.setEnabled(this.fieldCheckBox.isSelected() && result.niGetter && !this.forInterface);
        this.niSetCheckBox.setEnabled(this.fieldCheckBox.isSelected() && result.niSetter && !this.forInterface);
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    void setForInterface(boolean bl) {
        this.forInterface = bl;
        this.protectControls();
    }

    void setGroupNode(PatternGroupNode patternGroupNode) {
        this.groupNode = patternGroupNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dialog != null) {
            if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                if (this.typeComboBox.getEditor().getItem().toString().trim().length() <= 0) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Type"), 0));
                    this.typeComboBox.requestFocus();
                    return;
                }
                if (!Utilities.isJavaIdentifier((String)this.nameTextField.getText())) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Identifier"), 0));
                    this.nameTextField.requestFocus();
                    return;
                }
                if (this.groupNode.propertyExists(this.nameTextField.getText())) {
                    String string = MessageFormat.format(PatternNode.getString("MSG_Property_Exists"), this.nameTextField.getText());
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                    this.nameTextField.requestFocus();
                    return;
                }
                try {
                    Type type = Type.parse((String)this.typeComboBox.getEditor().getItem().toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Type"), 0));
                    this.typeComboBox.requestFocus();
                    return;
                }
            }
            ((Component)this.dialog).setVisible(false);
            this.dialog.dispose();
        }
    }

    class Result {
        String name;
        String type;
        int mode = 1;
        boolean bound = false;
        boolean constrained = false;
        boolean withField = false;
        boolean withReturn = false;
        boolean withSet = false;
        boolean withSupport = false;
        boolean niGetter = false;
        boolean niWithReturn = false;
        boolean niSetter = false;
        boolean niWithSet = false;

        Result() {
        }
    }
}

