/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BeanInfoSource;
import org.netbeans.modules.beans.beaninfo.BiFeature;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;

public class BiAnalyser
implements Node.Cookie {
    private static final String TAB = "    ";
    private static final String TABx2 = "        ";
    private static final String TABx3 = "            ";
    private static final String TABx4 = "                ";
    private static final String ICONNAME_C16 = "iconNameC16";
    private static final String ICONNAME_C32 = "iconNameC32";
    private static final String ICONNAME_M16 = "iconNameM16";
    private static final String ICONNAME_M32 = "iconNameM32";
    private static final String DEFAULT_PROPERTY_INDEX = "defaultPropertyIndex";
    private static final String DEFAULT_EVENT_INDEX = "defaultEventIndex";
    List descriptor;
    List properties;
    List idxProperties;
    List eventSets;
    List methods;
    BeanInfoSource bis;
    private boolean nullDescriptor = false;
    private boolean nullProperties = false;
    private boolean nullEventSets = false;
    private boolean nullMethods = false;
    private boolean lazyDescriptor = true;
    private boolean lazyProperties = true;
    private boolean lazyEventSets = true;
    private boolean lazyMethods = true;
    private final boolean olderVersion;
    private boolean superClassVersion = true;
    ClassElement classElement;
    private String iconC16;
    private String iconM16;
    private String iconC32;
    private String iconM32;
    private int defaultPropertyIndex = -1;
    private int defaultEventIndex = -1;
    private boolean useSuperClass = false;

    private int getIndexOfMethod(List list, MethodElement methodElement) {
        if (methodElement == null) {
            return -1;
        }
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        int n = 0;
        while (n < list.size()) {
            MethodParameter[] methodParameterArray2;
            MethodElement methodElement2 = ((BiFeature.Method)list.get(n)).getElement();
            if (methodElement2.getDeclaringClass().getName().getFullName().equals(methodElement.getDeclaringClass().getName().getFullName()) && methodElement2.getName().getFullName().equals(methodElement.getName().getFullName()) && methodParameterArray.length == (methodParameterArray2 = methodElement2.getParameters()).length) {
                int n2 = 0;
                while (n2 < methodParameterArray.length && methodParameterArray[n2].getFullString().equals(methodParameterArray2[n2].getFullString())) {
                    ++n2;
                }
                if (n2 == methodParameterArray.length) {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    BiAnalyser(PatternAnalyser patternAnalyser, ClassElement classElement) {
        int n;
        Object object;
        this.classElement = classElement;
        this.bis = new BeanInfoSource(classElement);
        this.olderVersion = this.bis.isNbBeanInfo() && this.bis.getMethodsSection() == null;
        this.superClassVersion = this.bis.isNbSuperclass() || !this.bis.exists();
        this.descriptor = new ArrayList();
        this.descriptor.add(new BiFeature.Descriptor(patternAnalyser.getClassElement()));
        this.methods = new ArrayList();
        if (!this.olderVersion) {
            object = patternAnalyser.getClassElement();
            MethodElement[] methodElementArray = object.getMethods();
            int n2 = 0;
            while (n2 < methodElementArray.length) {
                this.methods.add(new BiFeature.Method(methodElementArray[n2]));
                ++n2;
            }
        }
        Collection collection = patternAnalyser.getPropertyPatterns();
        this.properties = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (PropertyPattern)iterator.next();
            this.properties.add(new BiFeature.Property((PropertyPattern)object));
            int n3 = 0;
            while (n3 < this.methods.size()) {
                n = this.getIndexOfMethod(this.methods, ((PropertyPattern)object).getGetterMethod());
                if (n != -1) {
                    this.methods.remove(n);
                }
                if ((n = this.getIndexOfMethod(this.methods, ((PropertyPattern)object).getSetterMethod())) != -1) {
                    this.methods.remove(n);
                }
                ++n3;
            }
        }
        collection = patternAnalyser.getIdxPropertyPatterns();
        this.idxProperties = new ArrayList(collection.size());
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (IdxPropertyPattern)iterator.next();
            if (((PropertyPattern)object).getType() != null && (!((PropertyPattern)object).getType().isArray() || !((PropertyPattern)object).getType().getElementType().equals((Object)((IdxPropertyPattern)object).getIndexedType()))) continue;
            this.idxProperties.add(new BiFeature.IdxProperty((IdxPropertyPattern)object));
            n = this.getIndexOfMethod(this.methods, ((PropertyPattern)object).getGetterMethod());
            if (n != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, ((PropertyPattern)object).getSetterMethod())) != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, ((IdxPropertyPattern)object).getIndexedGetterMethod())) != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, ((IdxPropertyPattern)object).getIndexedSetterMethod())) == -1) continue;
            this.methods.remove(n);
        }
        collection = patternAnalyser.getEventSetPatterns();
        this.eventSets = new ArrayList(collection.size());
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (EventSetPattern)iterator.next();
            this.eventSets.add(new BiFeature.EventSet((EventSetPattern)object));
            n = this.getIndexOfMethod(this.methods, ((EventSetPattern)object).getRemoveListenerMethod());
            if (n != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, ((EventSetPattern)object).getAddListenerMethod())) == -1) continue;
            this.methods.remove(n);
        }
        this.analyzeBeanInfoSource();
    }

    Collection getDescriptor() {
        return this.descriptor;
    }

    Collection getProperties() {
        return this.properties;
    }

    Collection getIdxProperties() {
        return this.idxProperties;
    }

    Collection getEventSets() {
        return this.eventSets;
    }

    Collection getMethods() {
        return this.methods;
    }

    public boolean isOlderVersion() {
        return this.olderVersion;
    }

    public boolean isSuperclassVersion() {
        return this.superClassVersion;
    }

    public String getIconC16() {
        return this.iconC16;
    }

    public void setIconC16(String string) {
        this.iconC16 = string;
    }

    public String getIconM16() {
        return this.iconM16;
    }

    public void setIconM16(String string) {
        this.iconM16 = string;
    }

    public String getIconC32() {
        return this.iconC32;
    }

    public void setIconC32(String string) {
        this.iconC32 = string;
    }

    public String getIconM32() {
        return this.iconM32;
    }

    public void setIconM32(String string) {
        this.iconM32 = string;
    }

    public int getDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    public void setDefaultPropertyIndex(int n) {
        this.defaultPropertyIndex = n;
    }

    public int getDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    public void setDefaultEventIndex(int n) {
        this.defaultEventIndex = n;
    }

    public boolean isUseSuperClass() {
        return this.useSuperClass;
    }

    public void setUseSuperClass(boolean bl) {
        this.useSuperClass = bl;
    }

    boolean isNullDescriptor() {
        return this.nullDescriptor;
    }

    boolean isNullProperties() {
        return this.nullProperties;
    }

    boolean isNullMethods() {
        return this.nullMethods;
    }

    void setNullDescriptor(boolean bl) {
        this.nullDescriptor = bl;
    }

    void setNullProperties(boolean bl) {
        this.nullProperties = bl;
    }

    void setNullMethods(boolean bl) {
        this.nullMethods = bl;
    }

    boolean isNullEventSets() {
        return this.nullEventSets;
    }

    void setNullEventSets(boolean bl) {
        this.nullEventSets = bl;
    }

    public boolean isLazyDescriptor() {
        return this.lazyDescriptor;
    }

    public boolean isLazyProperties() {
        return this.lazyProperties;
    }

    public boolean isLazyMethods() {
        return this.lazyMethods;
    }

    public void setLazyDescriptor(boolean bl) {
        this.lazyDescriptor = bl;
    }

    public void setLazyProperties(boolean bl) {
        this.lazyProperties = bl;
    }

    public void setLazyMethods(boolean bl) {
        this.lazyMethods = bl;
    }

    public boolean isLazyEventSets() {
        return this.lazyEventSets;
    }

    public void setLazyEventSets(boolean bl) {
        this.lazyEventSets = bl;
    }

    void regenerateSource() {
        if (this.bis.exists()) {
            if (!this.bis.isNbBeanInfo()) {
                String string = GenerateBeanInfoAction.getString("MSG_BeanInfoExists");
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    return;
                }
                try {
                    this.bis.delete();
                }
                catch (IOException iOException) {
                    string = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                    confirmation = new NotifyDescriptor.Message((Object)string);
                    TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                    return;
                }
                this.bis.createFromTemplate(this.iconBlockRequired());
            } else if (!this.bis.isNbBeanInfoDescriptor()) {
                try {
                    this.bis.delete();
                }
                catch (IOException iOException) {
                    String string = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
                    confirmation = new NotifyDescriptor.Message((Object)string);
                    TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                    return;
                }
                this.bis.createFromTemplate(this.iconBlockRequired());
            } else {
                if (!this.iconBlockRequired() && this.bis.hasIconInfo() || this.iconBlockRequired() && !this.bis.hasIconInfo()) {
                    try {
                        this.bis.delete();
                    }
                    catch (IOException iOException) {
                        String string = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
                        confirmation = new NotifyDescriptor.Message((Object)string);
                        TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                        return;
                    }
                }
                this.bis.createFromTemplate(this.iconBlockRequired());
            }
        } else {
            this.bis.createFromTemplate(this.iconBlockRequired());
            if (!this.bis.isNbBeanInfo()) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BiAnalyser.this.bis.open();
                BiAnalyser.this.regenerateBeanDescriptor();
                BiAnalyser.this.regenerateProperties();
                BiAnalyser.this.regenerateEvents();
                if (!BiAnalyser.this.olderVersion) {
                    BiAnalyser.this.regenerateMethods();
                }
                BiAnalyser.this.regenerateIcons();
                BiAnalyser.this.regenerateDefaultIdx();
                BiAnalyser.this.regenerateSuperclass();
            }
        });
    }

    private void regenerateBeanDescriptor() {
        StringBuffer stringBuffer = new StringBuffer(512);
        boolean bl = false;
        if (this.nullDescriptor) {
            stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullDescriptor"));
            stringBuffer.append("    private static BeanDescriptor beanDescriptor = null;\n");
            stringBuffer.append("    private static BeanDescriptor getBdescriptor(){\n\n");
            this.bis.setDescriptorSection(stringBuffer.toString(), "\n        return beanDescriptor;\n    }\n\n");
            return;
        }
        ArrayList arrayList = new ArrayList(this.getMethods().size());
        arrayList.addAll(this.getDescriptor());
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (!biFeature.isIncluded()) continue;
            stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_BeanDescriptor"));
            if (!this.lazyDescriptor) {
                stringBuffer.append("    private static BeanDescriptor beanDescriptor = ");
                stringBuffer.append(biFeature.getCreationString());
                stringBuffer.append(";\n\n");
                stringBuffer.append("    private static BeanDescriptor getBdescriptor(){\n");
                stringBuffer.append("        return beanDescriptor;\n    }\n\n");
                stringBuffer.append("    static {\n");
            } else {
                stringBuffer.append("    /*lazy BeanDescriptor*/\n");
                stringBuffer.append("    private static BeanDescriptor getBdescriptor(){\n");
                stringBuffer.append("        BeanDescriptor beanDescriptor = ");
                stringBuffer.append(biFeature.getCreationString());
                stringBuffer.append(";\n");
            }
            Collection collection = biFeature.getCustomizationStrings();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("        beanDescriptor.");
                stringBuffer.append((String)iterator2.next()).append(";\n");
            }
            if (!this.lazyDescriptor) {
                this.bis.setDescriptorSection(stringBuffer.toString(), "}\n");
                continue;
            }
            this.bis.setDescriptorSection(stringBuffer.toString(), "        return beanDescriptor;\n        }\n");
        }
    }

    private void regenerateProperties() {
        StringBuffer stringBuffer = new StringBuffer(512);
        int n = 0;
        if (this.nullProperties) {
            stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullProperties"));
            stringBuffer.append("    private static PropertyDescriptor[] properties = null;\n");
            stringBuffer.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            this.bis.setPropertiesSection(stringBuffer.toString(), "        return properties;\n    }\n\n");
            return;
        }
        ArrayList arrayList = new ArrayList(this.getProperties().size() + this.getIdxProperties().size());
        arrayList.addAll(this.getProperties());
        arrayList.addAll(this.getIdxProperties());
        stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_PropertyIdentifiers"));
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (!biFeature.isIncluded()) continue;
            stringBuffer.append("    private static final int ");
            stringBuffer.append("PROPERTY_" + biFeature.getName());
            stringBuffer.append(" = " + n++ + ";");
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_PropertyArray"));
        if (!this.lazyProperties) {
            stringBuffer.append("    private static PropertyDescriptor[] properties = new PropertyDescriptor[" + n + "];\n\n");
            stringBuffer.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            stringBuffer.append("        return properties;\n    }\n\n");
        } else {
            stringBuffer.append("    /*lazy PropertyDescriptor*/\n");
            stringBuffer.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            stringBuffer.append("        PropertyDescriptor[] properties = new PropertyDescriptor[");
            stringBuffer.append(n);
            stringBuffer.append("];\n");
        }
        if (n > 0) {
            if (!this.lazyProperties) {
                stringBuffer.append("    static {\n        try {\n");
            } else {
                stringBuffer.append("    \n        try {\n");
            }
        }
        iterator = ((AbstractList)arrayList).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (biFeature.isIncluded()) {
                stringBuffer.append("            properties[PROPERTY_").append(biFeature.getName()).append("] = ");
                stringBuffer.append(biFeature.getCreationString()).append(";\n");
                Collection collection = biFeature.getCustomizationStrings();
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("            properties[PROPERTY_").append(biFeature.getName()).append("].");
                    stringBuffer.append((String)iterator2.next()).append(";\n");
                }
            }
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append("        }\n        catch( IntrospectionException e) {}");
        }
        if (!this.lazyProperties) {
            this.bis.setPropertiesSection(stringBuffer.toString(), n > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setPropertiesSection(stringBuffer.toString(), "        return properties;\n        }\n");
        }
    }

    private void regenerateMethods() {
        StringBuffer stringBuffer = new StringBuffer(512);
        int n = 0;
        if (this.nullMethods) {
            stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullMethods"));
            stringBuffer.append("    private static MethodDescriptor[] methods = null;\n");
            stringBuffer.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            this.bis.setMethodsSection(stringBuffer.toString(), "        return methods;\n    }\n\n");
            return;
        }
        ArrayList arrayList = new ArrayList(this.getMethods().size());
        arrayList.addAll(this.getMethods());
        stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_MethodIdentifiers"));
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (!biFeature.isIncluded()) continue;
            stringBuffer.append("    private static final int ");
            stringBuffer.append("METHOD_" + biFeature.getName() + n);
            stringBuffer.append(" = " + n++ + ";");
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_MethodArray"));
        if (!this.lazyMethods) {
            stringBuffer.append("    private static MethodDescriptor[] methods = new MethodDescriptor[" + n + "];\n\n");
            stringBuffer.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            stringBuffer.append("        return methods;\n    }\n\n");
        } else {
            stringBuffer.append("    /*lazy MethodDescriptor*/\n");
            stringBuffer.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            stringBuffer.append("        MethodDescriptor[] methods = new MethodDescriptor[");
            stringBuffer.append(n);
            stringBuffer.append("];\n");
        }
        if (n > 0) {
            if (!this.lazyMethods) {
                stringBuffer.append("    static {\n        try {\n");
            } else {
                stringBuffer.append("    \n        try {\n");
            }
        }
        iterator = ((AbstractList)arrayList).iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (!biFeature.isIncluded()) continue;
            stringBuffer.append("            methods[METHOD_").append(biFeature.getName()).append(n3++ + "] = ");
            stringBuffer.append(biFeature.getCreationString()).append(";\n");
            Collection collection = biFeature.getCustomizationStrings();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("            methods[METHOD_").append(biFeature.getName()).append(n2 + "].");
                stringBuffer.append((String)iterator2.next()).append(";\n");
            }
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append("        }\n        catch( Exception e) {}");
        }
        if (!this.lazyMethods) {
            this.bis.setMethodsSection(stringBuffer.toString(), n > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setMethodsSection(stringBuffer.toString(), "        return methods;\n        }\n");
        }
    }

    private void regenerateEvents() {
        StringBuffer stringBuffer = new StringBuffer(512);
        int n = 0;
        if (this.nullEventSets) {
            stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullEventSets"));
            stringBuffer.append("    private static EventSetDescriptor[] eventSets = null;\n");
            stringBuffer.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            this.bis.setEventSetsSection(stringBuffer.toString(), "        return eventSets;\n    }\n\n");
            return;
        }
        stringBuffer.append(TAB + GenerateBeanInfoAction.getString("COMMENT_EventSetsIdentifiers"));
        Iterator iterator = this.eventSets.iterator();
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (!biFeature.isIncluded()) continue;
            stringBuffer.append("    private static final int ");
            stringBuffer.append("EVENT_" + biFeature.getName());
            stringBuffer.append(" = " + n++ + ";");
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_EventSetsArray"));
        if (!this.lazyEventSets) {
            stringBuffer.append("    private static EventSetDescriptor[] eventSets = new EventSetDescriptor[" + n + "];\n\n");
            stringBuffer.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            stringBuffer.append("        return eventSets;\n    }\n\n");
        } else {
            stringBuffer.append("    /*lazy EventSetDescriptor*/\n");
            stringBuffer.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            stringBuffer.append("        EventSetDescriptor[] eventSets = new EventSetDescriptor[");
            stringBuffer.append(n);
            stringBuffer.append("];\n");
        }
        if (n > 0) {
            if (!this.lazyEventSets) {
                stringBuffer.append("    static {\n        try {\n");
            } else {
                stringBuffer.append("    \n            try {\n");
            }
        }
        iterator = this.eventSets.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (biFeature.isIncluded()) {
                stringBuffer.append("            eventSets[EVENT_").append(biFeature.getName()).append("] = ");
                stringBuffer.append(biFeature.getCreationString()).append(";\n");
                Collection collection = biFeature.getCustomizationStrings();
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("            eventSets[EVENT_").append(biFeature.getName()).append("].");
                    stringBuffer.append((String)iterator2.next()).append(";\n");
                }
            }
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append("        }\n        catch( IntrospectionException e) {}");
        }
        if (!this.lazyEventSets) {
            this.bis.setEventSetsSection(stringBuffer.toString(), n > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setEventSetsSection(stringBuffer.toString(), "        return eventSets;\n        }\n");
        }
    }

    private void regenerateIcons() {
        if (this.iconBlockRequired()) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(BiAnalyser.getIconDeclaration(ICONNAME_C16, this.iconC16));
            stringBuffer.append(BiAnalyser.getIconDeclaration(ICONNAME_C32, this.iconC32));
            stringBuffer.append(BiAnalyser.getIconDeclaration(ICONNAME_M16, this.iconM16));
            stringBuffer.append(BiAnalyser.getIconDeclaration(ICONNAME_M32, this.iconM32));
            this.bis.setIconsSection(stringBuffer.toString());
        }
    }

    private boolean iconBlockRequired() {
        return this.iconC16 != null | this.iconC32 != null | this.iconM16 != null | this.iconM32 != null;
    }

    private static String getIconDeclaration(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("    private static String ").append(string).append(" = ");
        if (string2 == null || string2.trim().length() == 0) {
            stringBuffer.append("null;\n");
        } else {
            stringBuffer.append("\"").append(string2.trim()).append("\";\n");
        }
        return stringBuffer.toString();
    }

    private void regenerateDefaultIdx() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("    private static final int defaultPropertyIndex = ").append(this.defaultPropertyIndex).append(";\n");
        stringBuffer.append("    private static final int defaultEventIndex = ").append(this.defaultEventIndex).append(";\n");
        this.bis.setDefaultIdxSection(stringBuffer.toString());
    }

    private void regenerateSuperclass() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.isUseSuperClass()) {
            stringBuffer.append("    public BeanInfo[] getAdditionalBeanInfo() {\n");
            stringBuffer.append("        Class superclass = " + this.classElement.getName().getName() + ".class.getSuperclass();\n");
            stringBuffer.append("        BeanInfo sbi = null;\n");
            stringBuffer.append("        try {\n");
            stringBuffer.append("            sbi = Introspector.getBeanInfo(superclass);\n");
            this.bis.setSuperclassSection(stringBuffer.toString(), "            }\ncatch(IntrospectionException ex) {\n}\n\nreturn new BeanInfo[] { sbi };\n}\n");
        } else {
            this.bis.setSuperclassSection("\n", "\n");
        }
    }

    private void analyzeBeanInfoSource() {
        if (!this.bis.isNbBeanInfo()) {
            return;
        }
        String string = this.bis.getIconsSection();
        Collection collection = BiAnalyser.normalizeText(string);
        this.setIconsFromBeanInfo(collection);
        string = this.bis.getDefaultIdxSection();
        collection = BiAnalyser.normalizeText(string);
        this.setDefaultIdxFromBeanInfo(collection);
        string = this.bis.getDescriptorSection();
        collection = BiAnalyser.normalizeText(string);
        this.nullDescriptor = this.setPropertiesFromBeanInfo(this.descriptor, collection, "BeanDescriptor");
        if (!this.nullDescriptor) {
            this.setLazyDescriptor(BiAnalyser.isLazy(collection, "BeanDescriptor"));
        }
        string = this.bis.getPropertiesSection();
        collection = BiAnalyser.normalizeText(string);
        this.nullProperties = this.setPropertiesFromBeanInfo(this.properties, collection, "PropertyDescriptor[]");
        if (!this.nullProperties) {
            this.setLazyProperties(BiAnalyser.isLazy(collection, "PropertyDescriptor"));
            this.setPropertiesFromBeanInfo(this.idxProperties, collection, "PropertyDescriptor[]");
        }
        if ((string = this.bis.getMethodsSection()) == null) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)GenerateBeanInfoAction.getString("MSG_Old_Version"), 2));
            this.nullMethods = true;
        } else {
            collection = BiAnalyser.normalizeText(string);
            this.nullMethods = this.setPropertiesFromBeanInfo(this.methods, collection, "MethodDescriptor[]");
            if (!this.nullMethods) {
                this.setLazyMethods(BiAnalyser.isLazy(collection, "MethodDescriptor"));
            }
        }
        string = this.bis.getEventSetsSection();
        collection = BiAnalyser.normalizeText(string);
        this.nullEventSets = this.setPropertiesFromBeanInfo(this.eventSets, collection, "EventSetDescriptor[]");
        if (!this.nullEventSets) {
            this.setLazyEventSets(BiAnalyser.isLazy(collection, "EventSetDescriptor"));
        }
        string = this.bis.getSuperclassSection();
        collection = BiAnalyser.normalizeText(string);
        this.setUseSuperClass(BiAnalyser.hasSuperClass(collection));
    }

    static Collection normalizeText(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (string != null && n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != '\"') {
                bl3 = false;
            }
            switch (n) {
                case 0: {
                    if (!Character.isWhitespace(c)) {
                        if (c == ';') {
                            stringBuffer.append(c);
                            arrayList.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n = 1;
                            bl = false;
                            break;
                        }
                        if (c == '\\') {
                            bl3 = true;
                            stringBuffer.append(c);
                            break;
                        }
                        if (c == '\"') {
                            if (!bl3) {
                                bl2 = !bl2;
                            }
                            bl3 = false;
                            stringBuffer.append(c);
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    if (bl2) {
                        stringBuffer.append(c);
                        break;
                    }
                    bl = Character.isJavaIdentifierPart(string.charAt(n2 - 1));
                    n = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace(c)) break;
                    if (bl && Character.isJavaIdentifierStart(c)) {
                        stringBuffer.append(' ');
                    } else if (c == '\\') {
                        bl3 = true;
                        stringBuffer.append(c);
                    } else if (c == '\"') {
                        if (!bl3) {
                            bl2 = !bl2;
                        }
                        bl3 = false;
                    }
                    stringBuffer.append(c);
                    n = 0;
                }
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    static String[] getParameters(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n == -1 || n2 == -1 || ++n >= n2) {
            return new String[0];
        }
        String string2 = string.substring(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    static String getArgumentParameter(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n != -1 && n2 != -1 && ++n < n2) {
            return string.substring(n, n2);
        }
        return null;
    }

    static String getInitializer(String string) {
        int n = string.lastIndexOf(61);
        int n2 = string.lastIndexOf(59);
        if (n != -1 && n2 != -1 && ++n < n2) {
            return string.substring(n, n2).trim();
        }
        return null;
    }

    static boolean isLazy(Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf(string) == -1 || string2.indexOf("/*lazy " + string + "*/") == -1) continue;
            return true;
        }
        return false;
    }

    static boolean hasSuperClass(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf("public BeanInfo[]getAdditionalBeanInfo()") == -1) continue;
            return true;
        }
        return false;
    }

    static String removeQuotation(String string) {
        int n = string.indexOf(34);
        int n2 = string.lastIndexOf(34);
        if (n != -1 && n2 != -1 && ++n < n2) {
            return string.substring(n, n2);
        }
        return null;
    }

    boolean setPropertiesFromBeanInfo(Collection collection, Collection collection2, String string) {
        Object object;
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (((String)object).indexOf(string) == -1) continue;
            if (!"null".equals(BiAnalyser.getInitializer((String)object))) break;
            return true;
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (BiFeature)iterator.next();
            ((BiFeature)object).setBrackets(((BiFeature)object).getBrackets());
            ((BiFeature)object).analyzeCustomization(collection2);
        }
        return false;
    }

    void setIconsFromBeanInfo(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf(ICONNAME_C16) != -1) {
                this.iconC16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
                continue;
            }
            if (string.indexOf(ICONNAME_C32) != -1) {
                this.iconC32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
                continue;
            }
            if (string.indexOf(ICONNAME_M16) != -1) {
                this.iconM16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
                continue;
            }
            if (string.indexOf(ICONNAME_M32) == -1) continue;
            this.iconM32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
        }
    }

    void setDefaultIdxFromBeanInfo(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf(DEFAULT_PROPERTY_INDEX) != -1) {
                try {
                    this.defaultPropertyIndex = Integer.parseInt(BiAnalyser.getInitializer(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.defaultPropertyIndex = -1;
                }
                continue;
            }
            if (string.indexOf(DEFAULT_EVENT_INDEX) == -1) continue;
            try {
                this.defaultEventIndex = Integer.parseInt(BiAnalyser.getInitializer(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.defaultEventIndex = -1;
            }
        }
    }
}

