/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.updater.ModuleUpdater;

public class UpdaterFrame
extends JPanel {
    public static final int OS_WIN = 1;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_OS2 = 1024;
    public static final int OS_OTHER = 65536;
    private static UpdaterFrame panel;
    private static boolean bigBounds;
    private static ModuleUpdater mu;
    private static boolean fromIDE;
    private static Window splashWindow;
    private static boolean nongui;
    private JLabel textLabel;
    private JLabel jLabel3;
    private JProgressBar progressBar;
    private JTextArea jTextArea1;

    public UpdaterFrame() {
        this.initComponents();
        if (this.addBorder()) {
            this.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/updater/resources/updatersplash.gif")));
    }

    static final void center(Window window) {
        window.pack();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Dimension dimension = window.getSize();
        ((Component)window).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
    }

    static String getMainWindowTitle() {
        return ResourceBundle.getBundle("org/netbeans/updater/Bundle").getString("UpdaterFrame.Form.title");
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.textLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setBackground(this.stringToColor("UpdaterFrame.TextBackground", new Color(0, 33, 173)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(this.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.jTextArea1.setText(ResourceBundle.getBundle("org/netbeans/updater/Bundle").getString("UpdaterFrame.jTextArea1.text"));
        this.jTextArea1.setBackground(new Color(213, 204, 187));
        this.jTextArea1.setDisabledTextColor(Color.white);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 14, 0, 14);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.textLabel.setText(ResourceBundle.getBundle("org/netbeans/updater/Bundle").getString("UpdaterFrame.textLabel.text"));
        this.textLabel.setForeground(this.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.textLabel.setFont(new Font("Dialog", 1, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 14, 8, 14);
        this.add((Component)this.textLabel, gridBagConstraints);
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 14, 10, 14);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private static void showSplash() {
        splashWindow = UpdaterFrame.getOperatingSystem() == 1 || UpdaterFrame.getOperatingSystem() == 8 || UpdaterFrame.getOperatingSystem() == 1024 || UpdaterFrame.getOperatingSystem() == 16 ? new SplashWindow() : new SplashFrame();
        splashWindow.show();
        splashWindow.toFront();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals("-nodisplay")) {
            nongui = true;
        } else {
            panel = new UpdaterFrame();
            UpdaterFrame.showSplash();
        }
        mu = new ModuleUpdater();
        mu.start();
    }

    public static void runFromIDE(File[] fileArray, PropertyChangeListener propertyChangeListener) {
        fromIDE = true;
        panel = new UpdaterFrame();
        panel.addPropertyChangeListener(propertyChangeListener);
        UpdaterFrame.showSplash();
        mu = new ModuleUpdater();
        mu.setNBMFiles(fileArray);
        mu.start();
    }

    void unpackingFinished() {
        this.runningFinished();
    }

    void runningFinished() {
        if (fromIDE) {
            this.firePropertyChange("FINISHED", null, null);
            splashWindow.dispose();
        } else {
            System.exit(0);
        }
    }

    static void setLabel(final String string) {
        if (nongui) {
            return;
        }
        final JLabel jLabel = UpdaterFrame.panel.textLabel;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jLabel.setText(string);
            }
        });
    }

    static void setProgressRange(final long l, final long l2) {
        if (nongui) {
            return;
        }
        bigBounds = l2 > 65535L;
        final JProgressBar jProgressBar = UpdaterFrame.panel.progressBar;
        final boolean bl = bigBounds;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jProgressBar.setMinimum(bl ? (int)(l / 1024L) : (int)l);
                jProgressBar.setMaximum(bl ? (int)(l2 / 1024L) : (int)l2);
            }
        });
    }

    static void setProgressValue(final long l) {
        if (nongui) {
            return;
        }
        final JProgressBar jProgressBar = UpdaterFrame.panel.progressBar;
        final boolean bl = bigBounds;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jProgressBar.setValue(bl ? (int)(l / 1024L) : (int)l);
            }
        });
    }

    public static final int getOperatingSystem() {
        int n = -1;
        String string = System.getProperty("os.name");
        n = string != null && string.startsWith("Windows") ? 1 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : ("Linux".equals(string) ? 16 : ("OS/2".equals(string) ? 1024 : 65536))));
        return n;
    }

    static boolean isFromIDE() {
        return fromIDE;
    }

    static UpdaterFrame getUpdaterFrame() {
        return panel;
    }

    private Color stringToColor(String string, Color color) {
        try {
            String string2 = this.getBrandingString(string + "_R");
            int n = Integer.parseInt(string2);
            string2 = this.getBrandingString(string + "_G");
            int n2 = Integer.parseInt(string2);
            string2 = this.getBrandingString(string + "_B");
            int n3 = Integer.parseInt(string2);
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            return color;
        }
    }

    private boolean addBorder() {
        return "true".equals(this.getBrandingString("UpdaterFrame.hasBorder"));
    }

    private String getBrandingString(String string) {
        try {
            return ResourceBundle.getBundle("org/netbeans/updater/resources/Branding").getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    static {
        bigBounds = false;
        mu = null;
        fromIDE = false;
        nongui = false;
    }

    static class SplashWindow
    extends Window {
        public SplashWindow() {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            UpdaterFrame.center(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 280);
        }
    }

    static class SplashFrame
    extends JFrame {
        public SplashFrame() {
            super(UpdaterFrame.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(panel);
            UpdaterFrame.center(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 280);
        }
    }
}

