/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.IOException;
import java.io.ObjectInput;
import java.text.MessageFormat;
import org.netbeans.modules.openfile.Server;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

public class Settings
extends SystemOption {
    private static final long serialVersionUID = 7655861665922160177L;
    private static final String PROP_ACCESS = "access";
    private static final String PROP_ACTUAL_RUNNING = "actualRunning";
    private static final String PROP_ACTUAL_PORT = "actualPort";
    private static boolean running;
    private static boolean actualRunning;
    private static int port;
    private static int actualPort;
    private static boolean inited;
    private static boolean pendingRunning;
    static final int ACCESS_LOCAL = 0;
    static final int ACCESS_ANY = 1;
    private static Settings defaultSettings;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$Settings;

    public static Settings getDefault() {
        if (defaultSettings == null) {
            defaultSettings = (Settings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$openfile$Settings == null ? (class$org$netbeans$modules$openfile$Settings = Settings.class$("org.netbeans.modules.openfile.Settings")) : class$org$netbeans$modules$openfile$Settings), (boolean)true);
        }
        return defaultSettings;
    }

    public String displayName() {
        return SettingsBeanInfo.getString("LBL_openFileSettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$openfile$Settings == null ? (class$org$netbeans$modules$openfile$Settings = Settings.class$("org.netbeans.modules.openfile.Settings")) : class$org$netbeans$modules$openfile$Settings);
    }

    protected void initialize() {
        super.initialize();
        running = false;
        inited = false;
        port = 7318;
        this.putProperty(PROP_ACCESS, new Integer(0), false);
        actualRunning = false;
        actualPort = 0;
    }

    public boolean isRunning() {
        Settings settings = this;
        synchronized (settings) {
            if (!inited) {
                inited = true;
                this.setRunning(Utilities.isWindows());
            }
            boolean bl = running;
            return bl;
        }
    }

    public void setRunning(boolean bl) {
        if (bl == running) {
            return;
        }
        Settings settings = this;
        synchronized (settings) {
            if (this.isReadExternal()) {
                pendingRunning = bl;
            } else {
                boolean bl2 = running;
                running = bl;
                if (bl2 && !bl) {
                    Server.shutdown();
                } else if (!bl2 && bl) {
                    Server.startup();
                }
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Settings settings = this;
        synchronized (settings) {
            super.readExternal(objectInput);
            inited = true;
            this.setRunning(pendingRunning);
        }
    }

    public int getPort() {
        return port;
    }

    public void setPort(int n) {
        Object object;
        if (n <= 0 || n > 65535) {
            String string = MessageFormat.format(SettingsBeanInfo.getString("MSG_portOutOfRange"), new Integer(n), new Integer(1), new Integer(65535));
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            return;
        }
        if (n < 1024 && n != port && inited && Utilities.isUnix()) {
            object = SettingsBeanInfo.getString("MSG_onlyRootOnUnix");
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object, 2));
        }
        object = this;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = n != port && this.isActualRunning();
            if (bl) {
                Server.shutdown();
            }
            int n2 = port;
            port = n;
            if (bl && running) {
                Server.startup();
            }
        }
    }

    public int getAccess() {
        return (Integer)this.getProperty(PROP_ACCESS);
    }

    public void setAccess(int n) {
        this.putProperty(PROP_ACCESS, new Integer(n), true);
    }

    public boolean isActualRunning() {
        return actualRunning;
    }

    void setActualRunning0(boolean bl) {
        Settings settings = this;
        synchronized (settings) {
            boolean bl2 = actualRunning;
            actualRunning = bl;
            this.firePropertyChange(PROP_ACTUAL_RUNNING, new Boolean(bl2), new Boolean(bl));
        }
    }

    public int getActualPort() {
        return actualPort;
    }

    void setActualPort0(int n) {
        Settings settings = this;
        synchronized (settings) {
            int n2 = actualPort;
            actualPort = n;
            this.firePropertyChange(PROP_ACTUAL_PORT, new Integer(n2), new Integer(n));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

