/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.TopManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class LocationInfoPanel
extends JPanel {
    private FileSystem fileSystem = null;
    private String path = null;
    private Node selectedNode = null;
    private DataObject selectedDO = null;
    private JLabel pathLabel;
    private JLabel fileSystemLabel;
    private JTextField fileSystemNameLabel;
    private JButton showButton;
    private JTextField packageNameLabel;
    private JLabel resultLabel;
    static /* synthetic */ Class class$org$netbeans$modules$search$LocationInfoPanel;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public LocationInfoPanel() {
        this.initComponents();
        this.initAccessibility();
        this.resultLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_LABEL_LOCATION"));
        this.fileSystemLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_LABEL_FILESYSTEM"));
        this.pathLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_LABEL_PATH"));
        this.showButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_BUTTON_SHOW"));
        this.showButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_BUTTON_SHOW_MNEM").charAt(0));
    }

    private void initAccessibility() {
        this.fileSystemNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("ACS_FileSystemName"));
        this.packageNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("ACS_PackageName"));
        this.showButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("ACS_TEXT_BUTTON_SHOW"));
    }

    private void initComponents() {
        this.resultLabel = new JLabel();
        this.fileSystemLabel = new JLabel();
        this.pathLabel = new JLabel();
        this.showButton = new JButton();
        this.fileSystemNameLabel = new JTextField();
        this.packageNameLabel = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.fileSystemLabel.setLabelFor(this.fileSystemNameLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.fileSystemLabel, gridBagConstraints);
        this.pathLabel.setLabelFor(this.packageNameLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.showButton.setText("jButton1");
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocationInfoPanel.this.showButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.add((Component)this.showButton, gridBagConstraints);
        this.fileSystemNameLabel.setEditable(false);
        this.fileSystemNameLabel.selectAll();
        this.fileSystemNameLabel.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LocationInfoPanel.this.fileSystemNameLabelFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.add((Component)this.fileSystemNameLabel, gridBagConstraints);
        this.packageNameLabel.setEditable(false);
        this.packageNameLabel.selectAll();
        this.packageNameLabel.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LocationInfoPanel.this.packageNameLabelFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.add((Component)this.packageNameLabel, gridBagConstraints);
    }

    private void packageNameLabelFocusGained(FocusEvent focusEvent) {
        this.packageNameLabel.selectAll();
    }

    private void fileSystemNameLabelFocusGained(FocusEvent focusEvent) {
        this.fileSystemNameLabel.selectAll();
    }

    private void showButtonActionPerformed(ActionEvent actionEvent) {
        this.showInExplorer();
    }

    public void showInfo(Node node) {
        String string = "";
        String string2 = "";
        if (node != null) {
            this.selectedNode = node;
            this.fileSystem = null;
            this.selectedDO = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LocationInfoPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.selectedDO != null) {
                FileObject fileObject = this.selectedDO.getPrimaryFile().getParent();
                if (fileObject != null) {
                    try {
                        this.fileSystem = fileObject.getFileSystem();
                        string = this.fileSystem.getDisplayName();
                        this.path = string2 = fileObject.getPackageName('/') + "/";
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        string = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_NO_FILESYSTEM");
                    }
                }
                this.resultLabel.setVisible(true);
                this.fileSystemLabel.setVisible(true);
                this.pathLabel.setVisible(true);
                this.showButton.setVisible(true);
                this.showButton.setEnabled(true);
            }
        } else {
            this.selectedNode = null;
            this.fileSystem = null;
            this.showButton.setEnabled(false);
        }
        this.fileSystemNameLabel.setText(string);
        this.packageNameLabel.setText(string2);
    }

    private void showInExplorer() {
        if (this.fileSystem == null || this.selectedNode == null || this.selectedDO == null) {
            return;
        }
        Object[] objectArray = TopComponent.getRegistry().getOpened().toArray();
        boolean bl = false;
        Node node = TopManager.getDefault().getPlaces().nodes().repository();
        int n = 0;
        while (n < objectArray.length) {
            Node node2;
            ExplorerPanel explorerPanel;
            ExplorerManager explorerManager;
            if (objectArray[n] instanceof ExplorerPanel && (explorerManager = (explorerPanel = (ExplorerPanel)objectArray[n]).getExplorerManager()) != null && (node2 = explorerManager.getRootContext()) != null && node.equals(node2)) {
                Node node3 = this.findNodeInRepository();
                if (node3 == null) break;
                try {
                    explorerManager.setSelectedNodes(new Node[]{node3});
                    explorerPanel.open();
                    explorerPanel.requestFocus();
                    bl = true;
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            ++n;
        }
        if (!bl) {
            this.showButton.setEnabled(false);
        }
    }

    private Node findNodeInRepository() {
        Object object;
        Node node = TopManager.getDefault().getPlaces().nodes().repository();
        Node node2 = null;
        Node[] nodeArray = node.getChildren().getNodes();
        String string = this.fileSystem.getDisplayName();
        int n = 0;
        while (n < nodeArray.length) {
            if (nodeArray[n].getDisplayName().equals(string)) {
                node2 = nodeArray[n];
                break;
            }
            ++n;
        }
        if (this.path != null && !this.path.equals("")) {
            object = new StringTokenizer(this.path, "/");
            while (node2 != null && ((StringTokenizer)object).hasMoreTokens()) {
                node2 = node2.getChildren().findChild(((StringTokenizer)object).nextToken());
            }
        }
        if (node2 == null) {
            return null;
        }
        object = this.selectedNode.getName();
        Children children = node2.getChildren();
        if ((node2 = children.findChild((String)object)) == null) {
            return null;
        }
        Enumeration enumeration = null;
        block2: do {
            DataObject dataObject;
            if ((dataObject = (DataObject)node2.getCookie(class$org$openide$loaders$DataObject == null ? LocationInfoPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) != null && dataObject == this.selectedDO) {
                return node2;
            }
            node2 = null;
            if (enumeration == null) {
                enumeration = children.nodes();
            }
            while (enumeration.hasMoreElements()) {
                Node node3 = (Node)enumeration.nextElement();
                if (!((String)object).equals(node3.getName())) continue;
                node2 = node3;
                continue block2;
            }
        } while (node2 != null);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

