/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.SearchDisplayer;
import org.netbeans.modules.search.SearchTask;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class ResultModel
implements TaskListener {
    private static final ErrorManager em = TopManager.getDefault().getErrorManager().getInstance("org.netbeans.modules.search");
    private final ChangeEvent EVENT;
    public final String PROP_SORTED = "sorted";
    private ResultRootNode root;
    private SearchTask searchTask = null;
    private boolean done = false;
    private HashSet listeners = new HashSet();
    private List searchTypeList;
    private boolean useDisp = false;
    private SearchDisplayer disp = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SearchGroup searchGroup;
    private PropertyChangeListener propListener;
    static /* synthetic */ Class class$org$netbeans$modules$search$ResultModel;

    public ResultModel(List list, SearchGroup searchGroup) {
        this.searchTypeList = list;
        this.searchGroup = searchGroup;
        this.EVENT = new ChangeEvent(this);
        this.root = new ResultRootNode();
    }

    public synchronized boolean acceptFoundObjects(Object[] objectArray) {
        this.root.addFoundObjects(objectArray);
        if (!this.done) {
            this.root.setDisplayName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TXT_RootSearchedNodes"), Integer.toString(this.getFound())));
        }
        return true;
    }

    public SearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    public void fillOutput() {
        if (this.useDisp) {
            this.disp.resetOutput();
        } else {
            this.disp = new SearchDisplayer();
            this.useDisp = true;
        }
        Node[] nodeArray = this.root.getChildren().getNodes();
        SearchType[] searchTypeArray = this.searchGroup.getSearchTypes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length * searchTypeArray.length * 3);
        int n = 0;
        while (n < searchTypeArray.length) {
            int n2 = 0;
            while (n2 < nodeArray.length) {
                Node[] nodeArray2 = searchTypeArray[n].getDetails(nodeArray[n2]);
                if (nodeArray2 != null) {
                    arrayList.addAll(Arrays.asList(nodeArray2));
                }
                ++n2;
            }
            ++n;
        }
        this.disp.acceptNodes(arrayList.toArray(new Node[arrayList.size()]));
    }

    public boolean isDone() {
        return this.done;
    }

    public void setTask(SearchTask searchTask) {
        this.searchTask = searchTask;
        this.searchTask.addTaskListener(this);
    }

    public Node getRoot() {
        return this.root;
    }

    public List getEnabledSearchTypes() {
        return this.searchTypeList;
    }

    public int getFound() {
        return this.root == null ? 0 : this.root.getNumberOfFoundNodes();
    }

    public boolean isSorted() {
        return this.root == null ? false : this.root.isSorted();
    }

    public Node sortNodes(boolean bl) {
        boolean bl2 = this.root.isSorted();
        if (bl == bl2) {
            return this.root;
        }
        this.root.setDisplayName(this.getRootDisplayName());
        this.root.sort(bl);
        return this.root;
    }

    public void taskFinished(Task task) {
        this.done = true;
        this.root.setDisplayName(this.getRootDisplayName());
        this.fireChange();
        this.registerListening();
    }

    private void registerListening() {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.openidex.search.result".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() == null) {
                        ResultModel.this.root.removeFoundObject(propertyChangeEvent.getOldValue());
                    } else {
                        ResultModel.this.root.addFoundObjects(new Object[]{propertyChangeEvent.getNewValue()});
                    }
                }
            }
        };
        this.searchGroup.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)this.searchGroup));
    }

    private String getRootDisplayName() {
        if (!this.isDone()) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_SEARCHING___");
        }
        int n = this.getFound();
        return ResultModel.getRootDisplayNameHelp(n);
    }

    private static String getRootDisplayNameHelp(int n) {
        if (n == 1) {
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_MSG_FOUND_A_NODE"), new Integer(n));
        }
        if (n > 1) {
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_MSG_FOUND_X_NODES"), new Integer(n));
        }
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_MSG_NO_NODE_FOUND");
    }

    public void stop() {
        if (this.searchTask != null) {
            this.searchTask.stop();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)iterator.next();
            changeListener.stateChanged(this.EVENT);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FoundNode
    extends FilterNode
    implements PropertyChangeListener {
        private DataObject originalDataObject;
        private Object foundObject;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$netbeans$modules$search$ResultModel;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$netbeans$modules$search$RemoveFromSearchAction;

        public FoundNode(Object object) {
            super(ResultModel.this.searchGroup.getNodeForFoundObject(object));
            this.foundObject = object;
            this.originalDataObject = (DataObject)this.getOriginal().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FoundNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.originalDataObject == null) {
                return;
            }
            this.originalDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            FileObject fileObject = this.originalDataObject.getPrimaryFile().getParent();
            if (fileObject != null) {
                String string = fileObject.getPackageName('.');
                String string2 = string.equals("") ? NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = FoundNode.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("HINT_result_default_package") : MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = FoundNode.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("HINT_result_package"), string);
                this.disableDelegation(48);
                this.setShortDescription(string2);
            }
        }

        public SystemAction[] getActions() {
            ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(Arrays.asList(super.getActions()));
            int n = arrayList.indexOf(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = FoundNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
            SystemAction systemAction = SystemAction.get((Class)(class$org$netbeans$modules$search$RemoveFromSearchAction == null ? (class$org$netbeans$modules$search$RemoveFromSearchAction = FoundNode.class$("org.netbeans.modules.search.RemoveFromSearchAction")) : class$org$netbeans$modules$search$RemoveFromSearchAction));
            if (n != -1) {
                arrayList.add(n, systemAction);
            } else {
                arrayList.add(null);
                arrayList.add(systemAction);
            }
            return arrayList.toArray(new SystemAction[arrayList.size()]);
        }

        public void removeFromSearch() {
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultModel.this.root.removeFoundObject(this.foundObject);
        }

        public void destroy() throws IOException {
            super.destroy();
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultModel.this.root.removeFoundObject(this.foundObject);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("valid".equals(propertyChangeEvent.getPropertyName()) && !this.originalDataObject.isValid()) {
                if (this.originalDataObject != null) {
                    this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                ResultModel.this.root.removeFoundObject(this.foundObject);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class ResultRootChildren
    extends Children.Keys {
        private Set keys;
        private final Comparator comparator;
        private boolean sorted = false;

        public ResultRootChildren() {
            this.keys = ResultModel.this.searchGroup.getResultObjects();
            this.comparator = new Comparator(this){
                private final /* synthetic */ ResultRootChildren this$1;
                {
                    this.this$1 = resultRootChildren;
                }

                public int compare(Object object, Object object2) {
                    Node node;
                    if (object == object2) {
                        return 0;
                    }
                    if (object == null) {
                        return 1;
                    }
                    if (object2 == null) {
                        return -1;
                    }
                    Node node2 = ResultModel.access$200(ResultRootChildren.access$300(this.this$1)).getNodeForFoundObject(object);
                    if (node2 == (node = ResultModel.access$200(ResultRootChildren.access$300(this.this$1)).getNodeForFoundObject(object2))) {
                        return 0;
                    }
                    if (node2 == null) {
                        return 1;
                    }
                    if (node == null) {
                        return -1;
                    }
                    int n = node2.getDisplayName().compareTo(node.getDisplayName());
                    return n == 0 ? -1 : n;
                }
            };
        }

        protected void addNotify() {
            this.setKeys(Collections.EMPTY_SET);
            RequestProcessor.postRequest((Runnable)new Runnable(this){
                private final /* synthetic */ ResultRootChildren this$1;
                {
                    this.this$1 = resultRootChildren;
                }

                public void run() {
                    ResultRootChildren.access$501(this.this$1, ResultRootChildren.access$400(this.this$1));
                }
            });
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new FoundNode(object)};
        }

        public void addFoundObjects(Object[] objectArray) {
            if (em.isLoggable(1)) {
                em.log("addFoundObjects: " + Arrays.asList(objectArray));
                em.notify((Throwable)new RuntimeException("++ addFoundObjects"));
            }
            this.keys.addAll(Arrays.asList(objectArray));
            this.setKeys(this.keys);
        }

        public void removeFoundObject(Object object) {
            if (em.isLoggable(1)) {
                em.log("removeFoundObjects: " + object);
                em.notify((Throwable)new RuntimeException("-- removeFoundObjects"));
            }
            if (this.keys.remove(object)) {
                this.sort(this.sorted);
            }
        }

        public void sort(boolean bl) {
            AbstractSet abstractSet = bl ? new TreeSet(this.comparator) : new HashSet();
            abstractSet.addAll(this.keys);
            this.setKeys(abstractSet);
            this.sorted = bl;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        static /* synthetic */ ResultModel access$300(ResultRootChildren resultRootChildren) {
            return resultRootChildren.ResultModel.this;
        }

        static /* synthetic */ Set access$400(ResultRootChildren resultRootChildren) {
            return resultRootChildren.keys;
        }

        static /* synthetic */ void access$501(ResultRootChildren resultRootChildren, Collection collection) {
            super.setKeys(collection);
        }
    }

    private class ResultRootNode
    extends AbstractNode {
        static /* synthetic */ Class class$org$netbeans$modules$search$ResultModel;

        public ResultRootNode() {
            super((Children)new ResultRootChildren());
            this.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultRootNode.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_SEARCHING___"));
        }

        public void addFoundObjects(Object[] objectArray) {
            ((ResultRootChildren)this.getChildren()).addFoundObjects(objectArray);
            ResultModel.this.root.setDisplayName(ResultModel.this.getRootDisplayName());
        }

        public void removeFoundObject(Object object) {
            ((ResultRootChildren)this.getChildren()).removeFoundObject(object);
            ResultModel.this.root.setDisplayName(ResultModel.this.getRootDisplayName());
        }

        public void sort(boolean bl) {
            ((ResultRootChildren)this.getChildren()).sort(bl);
        }

        public boolean isSorted() {
            return ((ResultRootChildren)this.getChildren()).isSorted();
        }

        public int getNumberOfFoundNodes() {
            return this.getChildren().getNodes().length;
        }

        public Image getIcon(int n) {
            return Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif");
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

