/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;

public class URLDataObject
extends MultiDataObject
implements EditCookie,
OpenCookie,
InstanceCookie {
    private static final String PROP_URL = "url";
    static final long serialVersionUID = 6829522922370124627L;
    static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject$URLPresenter;

    public URLDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add((Node.Cookie)this);
    }

    /*
     * Unable to fully structure code
     */
    String getURLString() {
        block16: {
            var1_1 = this.getPrimaryFile();
            if (!var1_1.isValid()) {
                return null;
            }
            var2_2 = "";
            var3_3 = null;
            try {
                var3_3 = var1_1.getInputStream();
                var2_2 = new BufferedReader(new InputStreamReader(var3_3)).readLine();
                var8_4 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var7_16) {
                var8_7 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var9_11) {
                        ErrorManager.getDefault().notify(1, (Throwable)var9_11);
                    }
                }
                throw var7_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException var9_8) {
                    ErrorManager.getDefault().notify(1, (Throwable)var9_8);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (FileNotFoundException var4_12) {
                    ErrorManager.getDefault().notify(16, (Throwable)var4_12);
                    var5_13 = null;
                    var8_5 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var9_9) {
                            ErrorManager.getDefault().notify(1, (Throwable)var9_9);
                        }
                    }
                    return var5_13;
                }
                catch (IOException var5_14) {
                    ErrorManager.getDefault().notify(16, (Throwable)var5_14);
                    var6_15 = null;
                    var8_6 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var9_10) {
                            ErrorManager.getDefault().notify(1, (Throwable)var9_10);
                        }
                    }
                    return var6_15;
                }
            }
        }
        if (var2_2 == null) {
            var2_2 = "";
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setURLString(String string) {
        FileObject fileObject = this.getPrimaryFile();
        if (!fileObject.isValid()) {
            return;
        }
        FileLock fileLock = null;
        try {
            try {
                fileLock = fileObject.lock();
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                outputStream.write(string.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
                Object var6_7 = null;
                if (fileLock == null) return;
                fileLock.releaseLock();
                return;
            }
            Object var6_6 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject);
    }

    protected Node createNodeDelegate() {
        return new URLNode((DataObject)this);
    }

    public void open() {
        String string = this.getURLString();
        if (string == null) {
            return;
        }
        URL uRL = URLDataObject.getURLFromString(string);
        if (uRL == null) {
            return;
        }
        TopManager.getDefault().showUrl(uRL);
    }

    public void openInNewWindow() {
        FileObject fileObject;
        String string = this.getURLString();
        if (string == null) {
            return;
        }
        URL uRL = URLDataObject.getURLFromString(string);
        if (uRL == null) {
            return;
        }
        HtmlBrowser.Factory factory = null;
        try {
            fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            DataObject[] dataObjectArray = dataFolder.getChildren();
            int n = 0;
            while (n < dataObjectArray.length) {
                Boolean bl = (Boolean)dataObjectArray[n].getPrimaryFile().getAttribute("DEFAULT_BROWSER");
                if (bl != null && bl.booleanValue()) {
                    Object object = ((InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = URLDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)).instanceCreate();
                    if (object instanceof HtmlBrowser.Factory) {
                        factory = (HtmlBrowser.Factory)object;
                    }
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        fileObject = new HtmlBrowser.BrowserComponent(factory, true, true);
        fileObject.setURL(uRL);
        fileObject.open();
        fileObject.requestFocus();
    }

    private static URL getURLFromString(String string) {
        URL uRL;
        block5: {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL("http://" + string);
                }
                catch (MalformedURLException malformedURLException2) {
                    if (string.length() > 50) {
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("MSG_MalformedURLError"), 0));
                        break block5;
                    }
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("MSG_FMT_MalformedURLError"), string), 0));
                }
            }
        }
        return uRL;
    }

    public void edit() {
        String string = this.getURLString();
        if (string == null) {
            return;
        }
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("CTL_URL"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("CTL_EditURL"));
        inputLine.setInputText(string);
        TopManager.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
            this.setURLString(inputLine.getInputText());
        }
    }

    public String instanceName() {
        return this.getName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return class$org$netbeans$modules$url$URLDataObject$URLPresenter == null ? (class$org$netbeans$modules$url$URLDataObject$URLPresenter = URLDataObject.class$("org.netbeans.modules.url.URLDataObject$URLPresenter")) : class$org$netbeans$modules$url$URLDataObject$URLPresenter;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        return this.createURLPresenter();
    }

    URLPresenter createURLPresenter() {
        return new URLPresenter((DataObject)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class URLNode
    extends DataNode {
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject;

        public URLNode(DataObject dataObject) {
            super(dataObject, Children.LEAF);
            this.setIconBase("org/netbeans/modules/url/urlObject");
            this.setName(super.getDisplayName(), false);
        }

        public String getDisplayName() {
            return Actions.cutAmpersand((String)super.getDisplayName());
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = sheet.get("properties");
            set.remove("name");
            set.put(this.createNameProperty());
            set.put(this.createURLStringProperty());
            return sheet;
        }

        private Node.Property createNameProperty() {
            return new PropertySupport.ReadWrite(this, "name", class$java$lang$String == null ? (class$java$lang$String = URLNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_Name"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_NameShortDescription")){
                private final /* synthetic */ URLNode this$0;
                {
                    this.this$0 = uRLNode;
                }

                public Object getValue() {
                    return ((FeatureDescriptor)((Object)this.this$0)).getName();
                }

                public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (!this.canWrite()) {
                        throw new IllegalAccessException();
                    }
                    if (!(object instanceof String)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        this.this$0.getDataObject().rename((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }

                public boolean canWrite() {
                    return this.this$0.getDataObject().isRenameAllowed();
                }
            };
        }

        private Node.Property createURLStringProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, URLDataObject.PROP_URL, class$java$lang$String == null ? (class$java$lang$String = URLNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_URLDisplayName"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_URLShortDescription")){
                private final /* synthetic */ URLNode this$0;
                {
                    this.this$0 = uRLNode;
                }

                public Object getValue() {
                    return ((URLDataObject)this.this$0.getDataObject()).getURLString();
                }

                public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (!this.canWrite()) {
                        throw new IllegalAccessException();
                    }
                    if (!(object instanceof String)) {
                        throw new IllegalArgumentException();
                    }
                    ((URLDataObject)this.this$0.getDataObject()).setURLString((String)object);
                }
            };
            readWrite.setPreferred(true);
            return readWrite;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class SimpleNodeButtonBridge
    implements ActionListener,
    PropertyChangeListener {
        private final DataObject dataObject;
        private final AbstractButton button;
        static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

        public SimpleNodeButtonBridge(DataObject dataObject, AbstractButton abstractButton) {
            this.dataObject = dataObject;
            this.button = abstractButton;
            this.updateText();
            Image image = Utilities.loadImage((String)"org/netbeans/modules/url/urlObject.gif");
            try {
                this.button.setIcon(new ImageIcon(this.dataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, 1, dataObject.files())));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.button.setIcon(new ImageIcon(image));
            }
            HelpCtx.setHelpIDString((JComponent)abstractButton, (String)dataObject.getHelpCtx().getHelpID());
            abstractButton.addActionListener(this);
            this.dataObject.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.dataObject));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpenCookie openCookie = (OpenCookie)this.dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = SimpleNodeButtonBridge.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
            if (openCookie != null) {
                openCookie.open();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("name".equals(propertyChangeEvent.getPropertyName())) {
                this.updateText();
            }
        }

        private void updateText() {
            String string = this.dataObject.getName();
            try {
                string = this.dataObject.getPrimaryFile().getFileSystem().getStatus().annotateName(string, this.dataObject.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            Actions.setMenuText((AbstractButton)this.button, (String)string, (boolean)true);
            this.button.setToolTipText(Actions.cutAmpersand((String)string));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class URLToolbarButton
    extends JButton {
        public URLToolbarButton(DataObject dataObject) {
            new SimpleNodeButtonBridge(dataObject, this);
        }
    }

    private static class URLMenuItem
    extends JMenuItem {
        public URLMenuItem(DataObject dataObject) {
            new SimpleNodeButtonBridge(dataObject, this);
        }
    }

    private static class URLPresenter
    implements Presenter.Menu,
    Presenter.Toolbar,
    Presenter.Popup {
        private DataObject dataObject;

        public URLPresenter(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public JMenuItem getMenuPresenter() {
            return new URLMenuItem(this.dataObject);
        }

        public JMenuItem getPopupPresenter() {
            return new URLMenuItem(this.dataObject);
        }

        public Component getToolbarPresenter() {
            return new URLToolbarButton(this.dataObject);
        }
    }
}

