/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.gj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.javac.v8.util.FileEntry;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.StaticName;
import org.netbeans.modules.java.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;

public class V8FileEntry
extends FileEntry {
    private static FileSystemCapability pool = FileSystemCapability.COMPILE;
    private final FileObject fileObject;
    private final Name name;
    private final boolean java;

    public V8FileEntry(FileObject fileObject) {
        this.fileObject = fileObject;
        this.name = StaticName.fromString((String)(fileObject.getName() + "." + fileObject.getExt()));
        this.java = fileObject.getExt().equals("java");
    }

    public InputStream open() throws IOException {
        return this.java ? Util.createInputStream((FileObject)this.fileObject, (boolean)true, (boolean)false) : this.fileObject.getInputStream();
    }

    public Name getName() {
        return this.name;
    }

    public String getPath() {
        return V8FileEntry.toString(this.fileObject);
    }

    public long length() {
        return this.fileObject.getSize();
    }

    public String toString() {
        return this.getName().toString();
    }

    protected long lastMod() {
        if (this.java && ModifiedRegistry.INSTANCE.isModified(this.fileObject)) {
            return System.currentTimeMillis();
        }
        return this.fileObject.lastModified().getTime();
    }

    public static String toString(FileObject fileObject) {
        return fileObject.getPackageNameExt(File.separatorChar, '.');
    }

    private static Name toName(FileObject fileObject) {
        return StaticName.fromString((String)V8FileEntry.toString(fileObject));
    }

    public static class ModifiedRegistry
    implements ChangeListener {
        static final ModifiedRegistry INSTANCE = new ModifiedRegistry();
        private HashMap fileObjects = null;

        ModifiedRegistry() {
            DataObject.getRegistry().addChangeListener((ChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            Collection collection = (Collection)changeEvent.getSource();
            ModifiedRegistry modifiedRegistry = this;
            synchronized (modifiedRegistry) {
                this.fileObjects = new HashMap(collection.size());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DataObject dataObject = (DataObject)iterator.next();
                    FileObject fileObject = dataObject.getPrimaryFile();
                    if (!"java".equals(fileObject.getExt())) continue;
                    this.fileObjects.put(fileObject, dataObject);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isModified(FileObject fileObject) {
            if (this.fileObjects == null) {
                return false;
            }
            ModifiedRegistry modifiedRegistry = this;
            synchronized (modifiedRegistry) {
                boolean bl = this.fileObjects.get(fileObject) != null;
                return bl;
            }
        }
    }
}

