/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.netbeans.core.AutomountSupport;
import org.netbeans.core.projects.SessionManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.modules.projects.ProjectDataNode;
import org.netbeans.modules.projects.ProjectDataObject;
import org.netbeans.modules.projects.ProjectRootFilterNode;
import org.netbeans.modules.projects.content.DiffSet;
import org.netbeans.modules.projects.content.OptionProcessor;
import org.netbeans.modules.projects.content.ProjectContent;
import org.netbeans.modules.projects.content.ProjectErrorManager;
import org.netbeans.modules.projects.content.SettingsSet;
import org.netbeans.modules.projects.content.XMLProjectContent;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.cookies.ProjectCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

public class PSupport
implements ProjectCookie {
    static final long serialVersionUID = -8907373672945248595L;
    static final String GLOBAL_METHOD_NAME = "isGlobal";
    private static final String EA_SAVE = "Project-Save";
    private static final String EA_DELETE = "Project-DeleteFiles";
    private static final boolean DELETE_DEFAULT = false;
    public static final int SAVE_CONTROL_PANEL = 1;
    public static final int SAVE_LOADERS = 2;
    public static final int SAVE_MODULES = 4;
    public static final int SAVE_REPOSITORY = 8;
    public static final int SAVE_SERVICES = 16;
    public static final int SAVE_WINDOW_MANAGER = 32;
    public static final int SAVE_ALL = 63;
    static final int SAVE_ALL_NEW = 4;
    public static final int CLEAR_REPOSITORY = 1024;
    public static final int INFO_OPEN_START = 1;
    public static final int INFO_OPEN_DONE = 2;
    public static final int INFO_OPEN_ERR = 3;
    public static final int INFO_SAVE_START = 4;
    public static final int INFO_SAVE_DONE = 5;
    public static final int INFO_SAVE_ERR = 6;
    public static final int INFO_CONTROL_PANEL = 1;
    public static final int INFO_LOADERS = 2;
    public static final int INFO_MODULES = 4;
    public static final int INFO_REPOSITORY = 8;
    public static final int INFO_SERVICES = 16;
    public static final int INFO_WINDOW_MANAGER = 32;
    private static final String ATTR_GLOBAL = "global";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_TRANSIENT = "transient";
    private static transient ProjectContent globalContent = null;
    private static transient ProjectErrorManager pem;
    private transient ProjectContent projectContent = null;
    private transient Node rootNode = null;
    private ProjectDataObject dobj;
    private transient FileSystem projectLayer = null;
    static /* synthetic */ Class class$org$netbeans$modules$projects$PSupport;
    static /* synthetic */ Class class$org$openide$options$SystemOption;

    public PSupport(ProjectDataObject projectDataObject) {
        this.dobj = projectDataObject;
        try {
            Object object = projectDataObject.getPrimaryFile().getAttribute(EA_DELETE);
            if (object != null) {
                projectDataObject.getPrimaryFile().setAttribute(EA_DELETE, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ProjectDataObject getProjectDO() {
        return this.dobj;
    }

    public Node projectDesktop() {
        if (this.rootNode == null) {
            DataFolder dataFolder = this.getProjectDO().getFilesFolder();
            Children children = dataFolder == null ? Children.LEAF : dataFolder.createNodeChildren(DataFilter.ALL);
            ProjectDataNode projectDataNode = new ProjectDataNode(this.getProjectDO(), children, true);
            this.rootNode = new ProjectRootFilterNode(projectDataNode);
        }
        return this.rootNode;
    }

    private ProjectContent getProjectContent(ProjectErrorManager projectErrorManager) {
        if (this.projectContent == null) {
            this.projectContent = new XMLProjectContent(this.getProjectDO(), PSupport.getGlobalProjectContent(projectErrorManager), projectErrorManager);
            this.projectContent.getRepository().setClear(false);
        }
        return this.projectContent;
    }

    private static ProjectContent getGlobalProjectContent(ProjectErrorManager projectErrorManager) {
        if (globalContent == null) {
            DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
            globalContent = new XMLProjectContent(dataFolder, null, projectErrorManager);
            globalContent.getRepository().setClear(true);
        }
        return globalContent;
    }

    public void projectClose() throws IOException {
        this.projectContent = null;
    }

    public void projectOpen() throws IOException {
        TopManager topManager = TopManager.getDefault();
        topManager.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$PSupport == null ? (class$org$netbeans$modules$projects$PSupport = PSupport.class$("org.netbeans.modules.projects.PSupport")) : class$org$netbeans$modules$projects$PSupport), (String)"MSG_OpenProject", (Object)this.getProjectDO().getName()));
        SessionManager.getDefault().setProjectLayer(this.getProjectDO().getProjectLayerDir());
        int n = this.getSave();
        if (n != 4) {
            this.openOldProject(n);
        }
        topManager.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$PSupport == null ? (class$org$netbeans$modules$projects$PSupport = PSupport.class$("org.netbeans.modules.projects.PSupport")) : class$org$netbeans$modules$projects$PSupport), (String)"MSG_OpenProjectDone", (Object)this.getProjectDO().getName()));
    }

    public void projectSave() throws IOException {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        windowManagerImpl.persistenceManager().writeXML();
        int n = this.getSave();
        n &= 0xFFFFFFFE;
        n &= 0xFFFFFFEF;
        n &= 0xFFFFFFF7;
        n &= 0xFFFFFFDF;
        this.setSave(n &= 0xFFFFFFFD);
        this.cleanUpFolder(this.getProjectDO());
        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        n = 4;
        int n2 = 0;
        while (n2 < dataObjectArray.length && n == 4) {
            if (dataObjectArray[n2] instanceof DataFolder) {
                Object object = dataObjectArray[n2].getPrimaryFile().getAttribute(EA_SAVE);
                n |= object == null ? 63 : (Integer)object;
            }
            ++n2;
        }
        if (n == 4) {
            this.cleanUpFolder(dataFolder);
        }
    }

    private void cleanUpFolder(DataFolder dataFolder) {
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (!(dataObjectArray[n] instanceof DataFolder) && !(dataObjectArray[n] instanceof DataShadow)) {
                try {
                    dataObjectArray[n].delete();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            ++n;
        }
    }

    private void openOldProject(int n) {
        Object object;
        ProjectContent projectContent;
        ProjectErrorManager projectErrorManager = new ProjectErrorManager();
        projectErrorManager.clear();
        ProjectContent projectContent2 = this.getProjectContent(projectErrorManager);
        OptionProcessor.Set set = new OptionProcessor.Set();
        OptionProcessor.Set set2 = new OptionProcessor.Set();
        if ((n & 8) != 0) {
            this.updateRepository(projectErrorManager);
        }
        if ((n & 2) != 0) {
            projectContent = projectContent2;
            while (projectContent != null) {
                object = projectContent.getLoaderPool();
                object.read(set2);
                set2.addAll(object.getObjects());
                projectContent = projectContent.getSuperProject();
            }
        }
        if ((n & 1) != 0) {
            projectContent = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$options$SystemOption == null ? (class$org$openide$options$SystemOption = PSupport.class$("org.openide.options.SystemOption")) : class$org$openide$options$SystemOption));
            object = projectContent.allInstances();
            ProjectContent projectContent3 = projectContent2;
            while (projectContent3 != null) {
                SettingsSet settingsSet = projectContent3.getControlPanel();
                settingsSet.read(set);
                set.addAll(settingsSet.getObjects());
                projectContent3 = projectContent3.getSuperProject();
            }
        }
        if ((n & 0x10) != 0) {
            this.updateServices(projectErrorManager);
        }
        AutomountSupport.initialize().waitFinished();
        projectContent = null;
        object = projectContent2;
        while (object != null) {
            projectContent = object.getWindowManager();
            if (projectContent != null) break;
            object = object.getSuperProject();
        }
        if ((n & 0x20) != 0) {
            this.updateWindowManager((NbMarshalledObject)projectContent, projectErrorManager);
        }
        projectErrorManager.show();
    }

    private void updateSettingsSet(SettingsSet settingsSet, SharedClassObject[] sharedClassObjectArray) {
        settingsSet.clear();
        int n = 0;
        while (n < sharedClassObjectArray.length) {
            settingsSet.add(sharedClassObjectArray[n]);
            ++n;
        }
    }

    private SharedClassObject[] getProjectObjects(SharedClassObject[] sharedClassObjectArray) {
        int n = 0;
        int n2 = 0;
        while (n < sharedClassObjectArray.length) {
            if (this.isProjectObject(sharedClassObjectArray[n].getClass(), sharedClassObjectArray[n], false)) {
                ++n2;
            }
            ++n;
        }
        SharedClassObject[] sharedClassObjectArray2 = new SharedClassObject[n2];
        n = 0;
        n2 = 0;
        while (n < sharedClassObjectArray.length) {
            if (this.isProjectObject(sharedClassObjectArray[n].getClass(), sharedClassObjectArray[n], false)) {
                sharedClassObjectArray2[n2++] = sharedClassObjectArray[n];
            }
            ++n;
        }
        return sharedClassObjectArray2;
    }

    private boolean isProjectObject(Class clazz, Object object, boolean bl) {
        try {
            if (this.hasGlobalAtrributeInBeanInfo(clazz)) {
                return !this.isGlobalFromBeanInfo(clazz);
            }
            if (object == null) {
                return bl;
            }
            Method method = clazz.getMethod(GLOBAL_METHOD_NAME, new Class[0]);
            ((AccessibleObject)method).setAccessible(true);
            Boolean bl2 = (Boolean)method.invoke(object, new Object[0]);
            return bl2 == false;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    private boolean hasGlobalAtrributeInBeanInfo(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null) {
                Object object;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                if (beanDescriptor != null && (object = beanDescriptor.getValue(ATTR_GLOBAL)) != null) {
                    return true;
                }
                object = beanInfo.getAdditionalBeanInfo();
                if (object != null) {
                    int n = 0;
                    while (n < ((BeanInfo[])object).length) {
                        Object object2;
                        BeanDescriptor beanDescriptor2 = object[n].getBeanDescriptor();
                        if (beanDescriptor2 != null && (object2 = beanDescriptor2.getValue(ATTR_GLOBAL)) != null) {
                            return true;
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    private boolean isGlobalFromBeanInfo(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null) {
                Object object;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                if (beanDescriptor != null && (object = beanDescriptor.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                    return (Boolean)object;
                }
                object = beanInfo.getAdditionalBeanInfo();
                if (object != null) {
                    int n = 0;
                    while (n < ((BeanInfo[])object).length) {
                        Object object2;
                        BeanDescriptor beanDescriptor2 = object[n].getBeanDescriptor();
                        if (beanDescriptor2 != null && (object2 = beanDescriptor2.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                            return (Boolean)object2;
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager.getDefault().notify(4096, (Throwable)introspectionException);
        }
        throw new IllegalArgumentException("Trying to get a value from beaninfo but the value is not there");
    }

    private String versionFromBeanInfo(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null) {
                Object object;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                if (beanDescriptor != null && (object = beanDescriptor.getValue(ATTR_VERSION)) instanceof String) {
                    return (String)object;
                }
                object = beanInfo.getAdditionalBeanInfo();
                if (object != null) {
                    int n = 0;
                    while (n < ((BeanInfo[])object).length) {
                        Object object2;
                        BeanDescriptor beanDescriptor2 = object[n].getBeanDescriptor();
                        if (beanDescriptor2 != null && (object2 = beanDescriptor2.getValue(ATTR_VERSION)) instanceof String) {
                            return (String)object2;
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager.getDefault().notify(4096, (Throwable)introspectionException);
        }
        return null;
    }

    private boolean isTransientFromBeanInfo(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null) {
                Object object;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                if (beanDescriptor != null && (object = beanDescriptor.getValue(ATTR_TRANSIENT)) instanceof Boolean) {
                    return (Boolean)object;
                }
                object = beanInfo.getAdditionalBeanInfo();
                if (object != null) {
                    int n = 0;
                    while (n < ((BeanInfo[])object).length) {
                        Object object2;
                        BeanDescriptor beanDescriptor2 = object[n].getBeanDescriptor();
                        if (beanDescriptor2 != null && (object2 = beanDescriptor2.getValue(ATTR_TRANSIENT)) instanceof Boolean) {
                            return (Boolean)object2;
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager.getDefault().notify(4096, (Throwable)introspectionException);
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.dobj == null && objectInputStream instanceof CompatibilityStream) {
            this.dobj = ((CompatibilityStream)((Object)objectInputStream)).getDataObject();
            if (this.dobj == null || !(this.dobj instanceof ProjectDataObject) || !this.dobj.getPrimaryFile().isValid()) {
                this.dobj = ProjectDataObject.createDefaultProject();
            }
        } else if (!(this.dobj == null || this.dobj instanceof ProjectDataObject && this.dobj.getPrimaryFile().isValid())) {
            this.dobj = ProjectDataObject.createDefaultProject();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        FileObject fileObject;
        PSupport pSupport = this;
        if (this.dobj == null && (fileObject = this.getLastProjectFile()) != null) {
            try {
                CompatibilityStream compatibilityStream = new CompatibilityStream(new BufferedInputStream(fileObject.getInputStream(), 16384));
                pSupport = (PSupport)((ObjectInputStream)((Object)compatibilityStream)).readObject();
            }
            catch (IOException iOException) {
                InvalidObjectException invalidObjectException = new InvalidObjectException("Cannot resolve object.");
                ErrorManager.getDefault().annotate((Throwable)invalidObjectException, (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                InvalidObjectException invalidObjectException = new InvalidObjectException("Cannot resolve object.");
                ErrorManager.getDefault().annotate((Throwable)invalidObjectException, (Throwable)classNotFoundException);
            }
        }
        return pSupport;
    }

    private FileObject getLastProjectFile() {
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        return fileSystem.find("", "project", "last");
    }

    private void updateWindowManager(NbMarshalledObject nbMarshalledObject, ProjectErrorManager projectErrorManager) {
        try {
            if (nbMarshalledObject != null) {
                this.resetWindowManager(false);
                nbMarshalledObject.get();
            } else {
                this.resetWindowManager(true);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            projectErrorManager.annotate(5, "Error deserializing window system.", throwable);
            this.resetWindowManager(true);
        }
    }

    private void resetWindowManager(boolean bl) {
    }

    private void updateRepository(ProjectErrorManager projectErrorManager) {
        Stack<DiffSet> stack = new Stack<DiffSet>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        DiffSet diffSet = null;
        ProjectContent projectContent = this.getProjectContent(projectErrorManager);
        while (projectContent != null) {
            diffSet = projectContent.getRepository();
            if (projectContent == this.getProjectContent(projectErrorManager) && "1.0".equals(diffSet.getVersion())) {
                diffSet.setClear(false);
            }
            stack.push(diffSet);
            if (diffSet.isClear()) break;
            projectContent = projectContent.getSuperProject();
        }
        Repository repository = TopManager.getDefault().getRepository();
        if (diffSet != null) {
            Iterator iterator;
            String string;
            Object object;
            if (!diffSet.isClear()) {
                Enumeration enumeration = repository.fileSystems();
                while (enumeration.hasMoreElements()) {
                    object = (FileSystem)enumeration.nextElement();
                    if (object.isDefault()) continue;
                    string = object.getSystemName();
                    linkedList.add(string);
                    hashMap.put(string, object);
                }
            }
            while (!stack.empty()) {
                diffSet = (DiffSet)stack.pop();
                iterator = diffSet.removedItems().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    linkedList.remove(object);
                    hashMap.remove(object);
                }
                iterator = diffSet.addedItems().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (linkedList.contains(object)) continue;
                    linkedList.add(object);
                    hashMap.put(object, diffSet.addedItem((String)object));
                }
            }
            this.clearRepository();
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (repository.findFileSystem((String)object) != null || (string = (FileSystem)hashMap.get(object)) instanceof LocalFileSystem && object.indexOf("{netbeans.user}") == 0 && repository.findFileSystem((String)(object = ((LocalFileSystem)string).getRootDirectory().getAbsolutePath().replace(File.separatorChar, '/'))) != null || string == null) continue;
                repository.addFileSystem((FileSystem)string);
            }
        }
    }

    private void clearRepository() {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (fileSystem.isDefault() || !this.isProjectObject(fileSystem.getClass(), fileSystem, true)) continue;
            repository.removeFileSystem(fileSystem);
        }
    }

    private void updateServices(ProjectErrorManager projectErrorManager) {
        Stack<DiffSet> stack = new Stack<DiffSet>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<ServiceType> linkedList2 = new LinkedList<ServiceType>();
        ProjectContent projectContent = this.getProjectContent(projectErrorManager);
        while (projectContent != null) {
            stack.push(projectContent.getServices());
            projectContent = projectContent.getSuperProject();
        }
        if (!stack.isEmpty()) {
            Object object;
            ServiceType serviceType;
            Object object2;
            Iterator iterator = null;
            Enumeration enumeration = TopManager.getDefault().getServices().services();
            while (enumeration.hasMoreElements()) {
                object2 = (ServiceType)enumeration.nextElement();
                linkedList.add(object2.getName());
            }
            iterator = ((AbstractList)stack).iterator();
            while (iterator.hasNext()) {
                object2 = (DiffSet)iterator.next();
                serviceType = object2.removedItems().iterator();
                while (serviceType.hasNext()) {
                    object = (String)serviceType.next();
                    linkedList.remove(object);
                }
                serviceType = object2.addedItems().iterator();
                while (serviceType.hasNext()) {
                    object = (String)serviceType.next();
                    if (linkedList.contains(object)) continue;
                    linkedList.add(object);
                }
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                serviceType = null;
                object = this.getProjectContent(projectErrorManager);
                while (object != null) {
                    serviceType = (ServiceType)object.getServices().addedItem((String)object2);
                    if (null != serviceType) break;
                    object = object.getSuperProject();
                }
                if (serviceType == null) {
                    serviceType = TopManager.getDefault().getServices().find((String)object2);
                }
                if (serviceType == null) continue;
                linkedList2.add(serviceType);
            }
            TopManager.getDefault().getServices().setServiceTypes(linkedList2);
        }
    }

    public int getSave() {
        Integer n = (Integer)this.dobj.getPrimaryFile().getAttribute(EA_SAVE);
        int n2 = n != null ? n : 63;
        return n2;
    }

    public void setSave(int n) throws IOException {
        this.dobj.getPrimaryFile().setAttribute(EA_SAVE, (Object)new Integer(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CompatibilityStream
    extends NbObjectInputStream {
        private ProjectDataObject dobj = null;

        public CompatibilityStream(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
        }

        protected Object resolveObject(Object object) throws IOException {
            if (object instanceof ProjectDataObject) {
                this.dobj = (ProjectDataObject)((Object)object);
            }
            return object;
        }

        public ProjectDataObject getDataObject() {
            return this.dobj;
        }
    }
}

