/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.projects.NewProjectAction;
import org.netbeans.modules.projects.ProjectDataObject;
import org.netbeans.modules.projects.ProjectManager;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.ProjectCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class ProjectManagerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener {
    public static final String PROP_CLOSE_DIALOG = "PROP_CLOSE_DIALOG";
    private ExplorerManager manager;
    private JButton deleteButton;
    private JPanel jPanel1;
    private JButton importButton;
    private JButton newButton;
    private JPanel controlPanel;
    private JButton saveAsButton;
    private JLabel projectListLabel;
    private JButton openButton;
    private ListView projectList;
    private JButton renameButton;
    static /* synthetic */ Class class$org$netbeans$modules$projects$importing$ImportProjectAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectManagerPanel;

    public ProjectManagerPanel() {
        this.initComponents();
        this.initAccessibility();
        this.updateButtonState();
        this.getExplorerManager().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.getExplorerManager()));
        ProjectManager.getDefault().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)ProjectManager.getDefault()));
        this.projectList.setDefaultProcessor((ActionListener)this);
    }

    private void setAccessible(JComponent jComponent, String string) {
        jComponent.getAccessibleContext().setAccessibleDescription(ProjectManagerPanel.getString(string));
    }

    private void initAccessibility() {
        this.projectListLabel.setLabelFor((Component)this.projectList);
        this.setAccessible(this.projectListLabel, "ACS_ProjectList");
        this.setAccessible(this.newButton, "ACS_New");
        this.setAccessible(this.openButton, "ACS_Open");
        this.setAccessible(this.importButton, "ACS_Import");
        this.setAccessible(this.saveAsButton, "ACS_SaveAs");
        this.setAccessible(this.deleteButton, "ACS_Delete");
        this.setAccessible(this.renameButton, "ACS_Rename");
        this.setAccessible(this, "ACSD_ProjectManager");
    }

    private void initComponents() {
        this.projectListLabel = new JLabel();
        this.projectListLabel.setDisplayedMnemonic(ProjectManagerPanel.getString("CTL_ExistingProjects_Mnem").charAt(0));
        this.controlPanel = new JPanel();
        this.newButton = new JButton();
        this.importButton = new JButton();
        this.projectList = new ListView();
        this.jPanel1 = new JPanel();
        this.openButton = new JButton();
        this.saveAsButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(600, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.projectListLabel.setText(ProjectManagerPanel.getString("CTL_ExistingProjects"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 11);
        this.add((Component)this.projectListLabel, gridBagConstraints);
        this.controlPanel.setLayout(new GridLayout(2, 1, 0, 5));
        this.newButton.setMnemonic('N');
        this.newButton.setText(ProjectManagerPanel.getString("CTL_New"));
        this.newButton.setMaximumSize(new Dimension(90, 27));
        this.newButton.setMinimumSize(new Dimension(90, 27));
        this.newButton.setPreferredSize(new Dimension(90, 27));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.newButton);
        this.importButton.setMnemonic('I');
        this.importButton.setText(ProjectManagerPanel.getString("CTL_Import"));
        this.importButton.setMaximumSize(new Dimension(90, 27));
        this.importButton.setMinimumSize(new Dimension(90, 27));
        this.importButton.setPreferredSize(new Dimension(90, 27));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.importButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.importButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.add((Component)this.controlPanel, gridBagConstraints);
        this.projectList.setTraversalAllowed(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectList, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(4, 1, 0, 5));
        this.openButton.setMnemonic('O');
        this.openButton.setText(ProjectManagerPanel.getString("CTL_Open"));
        this.openButton.setMaximumSize(new Dimension(90, 27));
        this.openButton.setMinimumSize(new Dimension(90, 27));
        this.openButton.setPreferredSize(new Dimension(90, 27));
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.openButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.openButton);
        this.saveAsButton.setMnemonic('V');
        this.saveAsButton.setText(ProjectManagerPanel.getString("CTL_SaveAs"));
        this.saveAsButton.setMaximumSize(new Dimension(90, 27));
        this.saveAsButton.setMinimumSize(new Dimension(90, 27));
        this.saveAsButton.setPreferredSize(new Dimension(90, 27));
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.saveAsButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.saveAsButton);
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setText(ProjectManagerPanel.getString("CTL_Delete"));
        this.deleteButton.setMaximumSize(new Dimension(90, 27));
        this.deleteButton.setMinimumSize(new Dimension(90, 27));
        this.deleteButton.setPreferredSize(new Dimension(90, 27));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.renameButton.setMnemonic('R');
        this.renameButton.setText(ProjectManagerPanel.getString("CTL_Rename"));
        this.renameButton.setMaximumSize(new Dimension(90, 27));
        this.renameButton.setMinimumSize(new Dimension(90, 27));
        this.renameButton.setPreferredSize(new Dimension(90, 27));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.renameButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.renameButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        this.importButton.setEnabled(false);
        SystemAction systemAction = SystemAction.get((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ProjectManagerPanel.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction));
        systemAction.actionPerformed(new ActionEvent(this, 1001, null));
        this.updateButtonState();
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1) {
            this.renameButton.setEnabled(false);
            SystemAction systemAction = SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = ProjectManagerPanel.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction));
            systemAction.actionPerformed(new ActionEvent(nodeArray[0], 1001, null));
            this.clearListSelection();
            this.updateButtonState();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray;
        block4: {
            this.deleteButton.setEnabled(false);
            try {
                block6: {
                    block5: {
                        nodeArray = this.getExplorerManager().getSelectedNodes();
                        if (nodeArray == null) break block5;
                        if (nodeArray.length != 0) break block6;
                    }
                    Object var5_3 = null;
                    this.updateButtonState();
                    return;
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ProjectManagerPanel.getString("MSG_ConfirmDelete"));
                if (NotifyDescriptor.YES_OPTION == TopManager.getDefault().notify((NotifyDescriptor)confirmation)) break block4;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.updateButtonState();
                throw throwable;
            }
            Object var5_4 = null;
            this.updateButtonState();
            return;
        }
        Object var5_5 = null;
        this.updateButtonState();
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;

            public void run() {
                try {
                    int n = 0;
                    while (n < nodeArray.length) {
                        ProjectDataObject projectDataObject = (ProjectDataObject)nodeArray[n].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? 7.class$("org.netbeans.modules.projects.ProjectDataObject") : class$org$netbeans$modules$projects$ProjectDataObject);
                        if (projectDataObject != null) {
                            projectDataObject.getPrimaryFile().delete();
                        }
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAsButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        ProjectDataObject projectDataObject;
        block7: {
            block8: {
                block6: {
                    this.saveAsButton.setEnabled(false);
                    try {
                        Node[] nodeArray;
                        block10: {
                            block9: {
                                nodeArray = this.getExplorerManager().getSelectedNodes();
                                if (nodeArray == null) break block9;
                                if (nodeArray.length == 1) break block10;
                            }
                            Object var6_3 = null;
                            this.updateButtonState();
                            return;
                        }
                        projectDataObject = (ProjectDataObject)nodeArray[0].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
                        if (projectDataObject == null) {
                            break block6;
                        }
                        string = NewProjectAction.getProjectName(projectDataObject.getName(), ProjectManagerPanel.getString("CTL_RenameLabel"), ProjectManagerPanel.getString("CTL_SaveAsDialogTitle"));
                        if (string != null) break block7;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        this.updateButtonState();
                        throw throwable;
                    }
                }
                Object var6_4 = null;
                this.updateButtonState();
                return;
            }
            Object var6_5 = null;
            this.updateButtonState();
            return;
        }
        Object var6_6 = null;
        this.updateButtonState();
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;

            public void run() {
                try {
                    DataFolder dataFolder;
                    if (projectDataObject.isCurrentProject()) {
                        dataFolder = (ProjectCookie)projectDataObject.getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = 8.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
                        dataFolder.projectSave();
                    }
                    dataFolder = TopManager.getDefault().getPlaces().folders().projects();
                    ProjectDataObject projectDataObject2 = ProjectDataObject.createProject(dataFolder, string);
                    ProjectDataObject.copyProjectContent(projectDataObject, projectDataObject2);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }

            static /* synthetic */ Class class$(String string2) {
                try {
                    return Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(PROP_CLOSE_DIALOG, null, null);
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$projects$NewProjectAction;

            public void run() {
                TopManager.getDefault().getActionManager().invokeAction((Action)SystemAction.get((Class)(class$org$netbeans$modules$projects$NewProjectAction == null ? (class$org$netbeans$modules$projects$NewProjectAction = 9.class$("org.netbeans.modules.projects.NewProjectAction")) : class$org$netbeans$modules$projects$NewProjectAction)), new ActionEvent(this, 1001, null));
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void openButtonActionPerformed(ActionEvent actionEvent) {
        final Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        this.firePropertyChange(PROP_CLOSE_DIALOG, null, null);
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;

            public void run() {
                try {
                    ProjectCookie projectCookie = (ProjectCookie)nodeArray[0].getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = 10.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
                    TopManager.getDefault().openProject(projectCookie);
                }
                catch (UserCancelException userCancelException) {
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void updateButtonState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateButtonStateAWT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectManagerPanel.this.updateButtonStateAWT();
                }
            });
        }
    }

    private void updateButtonStateAWT() {
        if (!ProjectManager.getDefault().isFinished()) {
            this.newButton.setEnabled(false);
            this.openButton.setEnabled(false);
            this.importButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            return;
        }
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        this.newButton.setEnabled(true);
        this.importButton.setEnabled(true);
        boolean bl = false;
        if (nodeArray != null && nodeArray.length > 0) {
            bl = true;
            int n = 0;
            while (n < nodeArray.length) {
                if (!nodeArray[n].canDestroy()) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        this.deleteButton.setEnabled(bl);
        bl = false;
        if (nodeArray != null && nodeArray.length == 1) {
            ProjectDataObject projectDataObject = (ProjectDataObject)nodeArray[0].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
            bl = !projectDataObject.isCurrentProject();
        }
        this.openButton.setEnabled(bl);
        bl = nodeArray != null && nodeArray.length == 1;
        this.renameButton.setEnabled(bl);
        this.saveAsButton.setEnabled(bl);
    }

    private void clearListSelection() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ProjectManagerPanel.this.getExplorerManager().setSelectedNodes(new Node[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            ProjectManagerPanel projectManagerPanel = this;
            synchronized (projectManagerPanel) {
                if (this.manager == null) {
                    this.manager = new ExplorerManager();
                }
            }
        }
        return this.manager;
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("finished".equals(propertyChangeEvent.getPropertyName())) {
            this.clearListSelection();
        }
        this.updateButtonState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.openButton.isEnabled()) {
            this.openButtonActionPerformed(actionEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

