/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.importing;

import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.projects.ProjectManager;
import org.netbeans.modules.projects.importing.ImportNetbeansProject;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;

public class ImportProjectAction
extends CallableSystemAction {
    private File currentDirectory = null;
    private File selection;
    static /* synthetic */ Class class$org$netbeans$modules$projects$importing$ImportProjectAction;

    protected String iconResource() {
        return "org/netbeans/modules/projects/resources/ImportProject.gif";
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ImportProjectAction.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction), (String)"ACT_ImportProject");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ImportProjectAction.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction);
    }

    public void performAction() {
        this.actionPerformed(null);
    }

    public File getFile() {
        return this.selection;
    }

    public void setFile(File file) {
        this.selection = file;
    }

    private File showFileChooser(File file) {
        DefaultPropertyModel defaultPropertyModel = new DefaultPropertyModel((Object)this, "file");
        FeatureDescriptor featureDescriptor = defaultPropertyModel.getFeatureDescriptor();
        NBProjectFileFilter nBProjectFileFilter = new NBProjectFileFilter();
        featureDescriptor.setValue("directories", Boolean.TRUE);
        featureDescriptor.setValue("files", Boolean.FALSE);
        featureDescriptor.setValue("filter", nBProjectFileFilter);
        if (file != null) {
            featureDescriptor.setValue("currentDir", file);
        }
        PropertyPanel propertyPanel = new PropertyPanel((PropertyModel)defaultPropertyModel, 2);
        String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ImportProjectAction.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction), (String)"CTL_ImportFileOk");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ImportProjectAction.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction), (String)"CTL_ImportFileMain"), true, new Object[]{string, NotifyDescriptor.CANCEL_OPTION}, (Object)string, 0, this.getHelpCtx(), null);
        Object object = TopManager.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == string) {
            try {
                return (File)defaultPropertyModel.getValue();
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        if (this.currentDirectory == null) {
            try {
                file = new File(System.getProperty("user.home"));
                if (Utilities.isUnix()) {
                    this.currentDirectory = file;
                } else if (Utilities.isWindows()) {
                    while ((file = file.getParentFile()) != null && file.getParentFile() != null) {
                    }
                    if (file != null) {
                        this.currentDirectory = file;
                    }
                }
            }
            catch (Exception exception) {
                this.currentDirectory = null;
            }
        }
        if ((file = this.showFileChooser(this.currentDirectory)) != null) {
            this.currentDirectory = file.getParentFile();
            ProjectManager.getDefault().processTask(new ImportNetbeansProject(file));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class NBProjectFileFilter
    extends FileFilter {
        private static final String[] projectFiles = new String[]{"cpanel.xml", "workspace.ser", "loaders.xml", "repository.xml", "services.xml", "Files", "system"};
        private static final LinkedList restricted = new LinkedList();
        private HashMap children = new HashMap();
        static /* synthetic */ Class class$org$netbeans$modules$projects$importing$ImportProjectAction$NBProjectFileFilter;

        private NBProjectFileFilter() {
        }

        public boolean accept(File file) {
            boolean bl = file.isDirectory();
            if (bl && restricted.contains(file.getName())) {
                File[] fileArray = this.getChildren(file.getParentFile());
                int n = 0;
                while (bl && n < fileArray.length) {
                    if (!fileArray[n].equals(file)) {
                        int n2 = 0;
                        while (n2 < projectFiles.length) {
                            if (projectFiles[n2].equals(fileArray[n].getName())) {
                                bl = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            return bl;
        }

        public String getDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction$NBProjectFileFilter == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction$NBProjectFileFilter = NBProjectFileFilter.class$("org.netbeans.modules.projects.importing.ImportProjectAction$NBProjectFileFilter")) : class$org$netbeans$modules$projects$importing$ImportProjectAction$NBProjectFileFilter), (String)"CTL_NetbeansFileFilterDescription");
        }

        private File[] getChildren(File file) {
            if (file == null) {
                return new File[0];
            }
            File[] fileArray = (File[])this.children.get(file);
            if (fileArray == null) {
                fileArray = file.listFiles();
                this.children.put(file, fileArray);
            }
            return fileArray;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static {
            restricted.add("Files");
            restricted.add("system");
        }
    }
}

