/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.tree;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.netbeans.modules.xml.core.tree.Util;
import org.openide.TopManager;
import org.openide.util.enum.SequenceEnumeration;

public final class ParserLoader
extends URLClassLoader {
    private static final String PARSER_PACKAGE = "org.apache.xerces";
    private static final String[] USER_PREFIXES = new String[]{"org.netbeans.tax.io.XNIBuilder", "org.netbeans.modules.xml.tools.action.XMLCompiler"};
    private static final String PARSER_MODULES_LIB = "/modules/autoload/ext/xerces2.jar";
    private ClassLoader parentLoader = TopManager.getDefault().systemClassLoader();
    private static ParserLoader instance = null;
    static /* synthetic */ Class class$org$netbeans$tax$io$XNIBuilder;

    private ParserLoader(URL library) {
        super(new URL[]{library});
    }

    public static synchronized ParserLoader getInstance() {
        block7: {
            if (instance != null) {
                return instance;
            }
            try {
                String prop = System.getProperty("netbeans.user");
                URL xer2url = new URL("file:" + prop + PARSER_MODULES_LIB);
                try {
                    xer2url.openStream();
                }
                catch (IOException ex) {
                    prop = System.getProperty("netbeans.home");
                    xer2url = new URL("file:" + prop + PARSER_MODULES_LIB);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Isolated jar URL=" + xer2url);
                }
                instance = new ParserLoader(xer2url);
                URL module = (class$org$netbeans$tax$io$XNIBuilder == null ? (class$org$netbeans$tax$io$XNIBuilder = ParserLoader.class$("org.netbeans.tax.io.XNIBuilder")) : class$org$netbeans$tax$io$XNIBuilder).getProtectionDomain().getCodeSource().getLocation();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Isolated module URL=" + module);
                }
                instance.addURL(module);
            }
            catch (MalformedURLException ex) {
                if (!Util.THIS.isLoggable()) break block7;
                Util.THIS.debug(ex);
            }
        }
        return instance;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name.startsWith(PARSER_PACKAGE)) {
            clazz = super.findLoadedClass(name);
            if (clazz == null) {
                clazz = super.findClass(name);
            }
        } else {
            int i = 0;
            while (i < USER_PREFIXES.length) {
                if (name.startsWith(USER_PREFIXES[i])) {
                    ParserLoader parserLoader = this;
                    synchronized (parserLoader) {
                        clazz = super.findLoadedClass(name);
                        if (clazz == null) {
                            clazz = super.findClass(name);
                        }
                    }
                }
                ++i;
            }
            if (clazz == null) {
                clazz = this.parentLoader.loadClass(name);
            }
        }
        return clazz;
    }

    public URL getResource(String name) {
        URL in = super.getResource(name);
        if (in == null) {
            in = this.parentLoader.getResource(name);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Resource: " + name + " =>" + in);
        }
        return in;
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Enumeration findResources(String name) throws IOException {
        Enumeration<URL> en1 = super.findResources(name);
        Enumeration<URL> en2 = this.parentLoader.getResources(name);
        return new SequenceEnumeration(en1, en2);
    }

    public static void main(String[] args) throws Exception {
        ParserLoader me = ParserLoader.getInstance();
        Class apache = me.loadClass("org.apache.xerces.util.QName");
        Class java = me.loadClass("java.lang.String");
        Class netbeans = me.loadClass("org.openide.util.Mutex");
        System.err.println("apache " + apache.getClassLoader());
        System.err.println("netbeans " + netbeans.getClassLoader());
        System.err.println("java " + java.getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

