/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

class Util
extends AbstractUtil {
    private static File lastDirectory;
    public static final Util THIS;

    private Util() {
    }

    public static File selectSchemaFile(final String string) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(string, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return THIS.getString("PROP_schema_mask");
            }
        });
        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }
        chooser.setDialogTitle(THIS.getString("PROP_schema_dialog_name"));
        while (chooser.showDialog(TopManager.getDefault().getWindowManager().getMainWindow(), THIS.getString("PROP_schema_select_button")) == 0) {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile()) {
                StringTokenizer token = new StringTokenizer(string, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return f;
                }
            }
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)THIS.getString("MSG_inValidFile"), 2));
        }
        return null;
    }

    public static String[] getKnownPublicIDs() {
        UserCatalog catalog = UserCatalog.getDefault();
        if (catalog != null) {
            TreeSet<String> idSet = new TreeSet<String>();
            Iterator it = catalog.getPublicIDs();
            while (it.hasNext()) {
                String next = (String)it.next();
                idSet.add(next);
            }
            return idSet.toArray(new String[idSet.size()]);
        }
        THIS.debug("Note SourceResolver not found!");
        return new String[0];
    }

    public static void performDefaultAction(DataObject dataObject) {
        Node node = dataObject.getNodeDelegate();
        SystemAction action = node.getDefaultAction();
        if (action != null) {
            TopManager.getDefault().getActionManager().invokeAction((Action)action, new ActionEvent(node, 1001, ""));
        }
    }

    static {
        THIS = new Util();
    }
}

