/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.actions.CommandActionSupporter;
import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.filesystems.FileObject;

public class VcsActionSupporter
extends CommandActionSupporter
implements Serializable {
    protected transient WeakReference fileSystem = new WeakReference<Object>(null);
    private HashMap commandMap;
    static final long serialVersionUID = -613064726657052221L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction;

    public VcsActionSupporter(VcsFileSystem vcsFileSystem) {
        this.fileSystem = new WeakReference<VcsFileSystem>(vcsFileSystem);
        this.commandMap = new HashMap();
    }

    public void setFileSystem(VcsFileSystem vcsFileSystem) {
        this.fileSystem = new WeakReference<VcsFileSystem>(vcsFileSystem);
    }

    public void addSupportForAction(Class clazz, String string) {
        HashSet<String> hashSet = (HashSet<String>)this.commandMap.get(clazz);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.commandMap.put(clazz, hashSet);
        }
        hashSet.add(string);
    }

    public void removeSupportForAction(Class clazz) {
        this.commandMap.remove(clazz);
    }

    public boolean isEnabled(GeneralCommandAction generalCommandAction, FileObject[] fileObjectArray) {
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return false;
        }
        if (((Object)((Object)generalCommandAction)).getClass().equals(class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction == null ? (class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction = VcsActionSupporter.class$("org.netbeans.modules.vcscore.actions.VersioningExplorerAction")) : class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction)) {
            return true;
        }
        HashSet hashSet = (HashSet)this.commandMap.get(((Object)((Object)generalCommandAction)).getClass());
        if (hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isEnabled(string, fileObjectArray)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabled(String string, FileObject[] fileObjectArray) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        VcsCommand vcsCommand = vcsFileSystem.getCommand(string);
        if (vcsCommand == null) {
            return false;
        }
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        int n = 0;
        while (n < fileObjectArray.length) {
            hashSet.add(fileObjectArray[n]);
            ++n;
        }
        boolean bl = this.isOnRoot(hashSet);
        boolean bl2 = this.isOnDirectory(hashSet);
        boolean bl3 = this.isOnFile(hashSet);
        Set set = this.getSelectedFileStatusAttributes(hashSet);
        if (bl2 && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "onDir") || bl3 && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "onFile") || bl && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "onRoot") || VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "hidden")) {
            return false;
        }
        boolean bl4 = VcsUtilities.isSetContainedInQuotedStrings((String)vcsCommand.getProperty("disabledOnStatus"), set);
        return !bl4;
    }

    public void performAction(GeneralCommandAction generalCommandAction, FileObject[] fileObjectArray) {
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return;
        }
        HashSet hashSet = (HashSet)this.commandMap.get(((Object)((Object)generalCommandAction)).getClass());
        if (hashSet == null) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isEnabled(string, fileObjectArray)) continue;
            VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
            VcsCommand vcsCommand = vcsFileSystem.getCommand(string);
            if (vcsCommand == null) break;
            VcsAction.performVcsCommand(vcsCommand, vcsFileSystem, Arrays.asList(fileObjectArray), false);
            break;
        }
    }

    private static Table removeDisabled(FileStatusProvider fileStatusProvider, Table table, VcsCommand vcsCommand) {
        if (fileStatusProvider == null) {
            return table;
        }
        String string = (String)vcsCommand.getProperty("disabledOnStatus");
        if (string == null) {
            return table;
        }
        Table table2 = new Table();
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = fileStatusProvider.getFileStatus(string2);
            boolean bl = VcsUtilities.isSetContainedInQuotedStrings(string, Collections.singleton(string3));
            if (bl) continue;
            table2.put(string2, table.get(string2));
        }
        return table2;
    }

    protected boolean isOnDirectory(Collection collection) {
        boolean bl = false;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (!fileObject.isFolder()) continue;
                bl = true;
            }
        }
        return bl && !this.isOnRoot(collection);
    }

    protected boolean isOnFile(Collection collection) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (fileObject.isFolder()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isOnRoot(Collection collection) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (fileObject.getPackageNameExt('/', '.').length() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private Set getSelectedFileStatusAttributes(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        FileStatusProvider fileStatusProvider = vcsFileSystem.getStatusProvider();
        boolean bl = vcsFileSystem.isProcessUnimportantFiles();
        if (fileStatusProvider != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                FileObject fileObject = (FileObject)iterator.next();
                String string2 = fileObject.getPackageNameExt('/', '.');
                if (!bl && !vcsFileSystem.isImportant(string2) || (string = fileStatusProvider.getFileStatus(string2)) == null) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private String getCommandActionDisplayName(GeneralCommandAction generalCommandAction) {
        HashSet hashSet = (HashSet)this.commandMap.get(((Object)((Object)generalCommandAction)).getClass());
        if (hashSet == null) {
            return null;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            VcsCommand vcsCommand = ((VcsFileSystem)this.fileSystem.get()).getCommand(string2);
            if (vcsCommand == null || (string = (String)vcsCommand.getProperty("generalCommandActionDisplayName")) == null) continue;
            return string;
        }
        return null;
    }

    public String getToolBarDisplayName(GeneralCommandAction generalCommandAction) {
        String string = this.getCommandActionDisplayName(generalCommandAction);
        if (string != null) {
            return string;
        }
        return super.getToolBarDisplayName(generalCommandAction);
    }

    public String getMenuDisplayName(GeneralCommandAction generalCommandAction) {
        String string = this.getCommandActionDisplayName(generalCommandAction);
        if (string != null) {
            return string;
        }
        return super.getMenuDisplayName(generalCommandAction);
    }

    public String getPopupDisplayName(GeneralCommandAction generalCommandAction) {
        String string = this.getCommandActionDisplayName(generalCommandAction);
        if (string != null) {
            return string;
        }
        return this.getPopupDisplayName(generalCommandAction);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

