/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.WeakList;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JMenuPlus;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class VcsRevisionAction
extends NodeAction
implements ActionListener {
    protected WeakReference fileSystem = new WeakReference<Object>(null);
    protected WeakReference fileObject = new WeakReference<Object>(null);
    protected Collection selectedRevisionItems = null;
    private static final long serialVersionUID = 8803248742536265293L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsRevisionAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$VcsCommand;

    public void setFileSystem(VcsFileSystem vcsFileSystem) {
        this.fileSystem = new WeakReference<VcsFileSystem>(vcsFileSystem);
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = new WeakReference<FileObject>(fileObject);
    }

    public void setSelectedRevisionItems(Collection collection) {
        if (collection == null) {
            this.selectedRevisionItems = null;
            return;
        }
        this.selectedRevisionItems = new WeakList(collection);
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsRevisionAction == null ? (class$org$netbeans$modules$vcscore$VcsRevisionAction = VcsRevisionAction.class$("org.netbeans.modules.vcscore.VcsRevisionAction")) : class$org$netbeans$modules$vcscore$VcsRevisionAction), (String)"CTL_Revision_Action");
    }

    public void performAction(Node[] nodeArray) {
    }

    public boolean enable(Node[] nodeArray) {
        return nodeArray.length > 0;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected JMenuItem createItem(VcsCommand vcsCommand) {
        JMenuItem jMenuItem = null;
        String string = vcsCommand.getDisplayName();
        jMenuItem = new JMenuItem(string);
        String[] stringArray = vcsCommand.getPropertyNames();
        if (stringArray != null && stringArray.length > 0) {
            jMenuItem.setActionCommand(vcsCommand.getName());
            jMenuItem.addActionListener(this);
        }
        return jMenuItem;
    }

    private void addMenu(Node node, JMenu jMenu, int n) {
        Children children = node.getChildren();
        Enumeration enumeration = children.nodes();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem;
            Node node2 = (Node)enumeration.nextElement();
            VcsCommand vcsCommand = (VcsCommand)node2.getCookie(class$org$netbeans$modules$vcscore$commands$VcsCommand == null ? VcsRevisionAction.class$("org.netbeans.modules.vcscore.commands.VcsCommand") : class$org$netbeans$modules$vcscore$commands$VcsCommand);
            if (vcsCommand == null) {
                jMenu.addSeparator();
                continue;
            }
            int n2 = VcsCommandIO.getIntegerPropertyAssumeZero(vcsCommand, "numRevisions");
            if (n2 != n || VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "hidden") || vcsCommand.getDisplayName() == null) continue;
            if (!node2.isLeaf()) {
                String[] stringArray = vcsCommand.getPropertyNames();
                jMenuItem = stringArray == null || stringArray.length == 0 ? new JMenuPlus(vcsCommand.getDisplayName()) : new JMenuPlus();
                this.addMenu(node2, (JMenu)jMenuItem, n);
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = this.createItem(vcsCommand);
            jMenu.add(jMenuItem);
        }
    }

    public JMenuItem getPopupPresenter() {
        JInlineMenu jInlineMenu = new JInlineMenu();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        Node node = vcsFileSystem.getCommands();
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes();
        int n = this.selectedRevisionItems.size();
        int n2 = 0;
        while (n2 < nodeArray.length) {
            JMenuItem jMenuItem;
            VcsCommand vcsCommand = (VcsCommand)nodeArray[n2].getCookie(class$org$netbeans$modules$vcscore$commands$VcsCommand == null ? VcsRevisionAction.class$("org.netbeans.modules.vcscore.commands.VcsCommand") : class$org$netbeans$modules$vcscore$commands$VcsCommand);
            if (vcsCommand != null && VcsCommandIO.getIntegerPropertyAssumeZero(vcsCommand, "numRevisions") == n && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "hidden") && vcsCommand.getDisplayName() != null && (jMenuItem = this.getPopupPresenter(nodeArray[n2], vcsCommand, n)) != null) {
                arrayList.add(jMenuItem);
            }
            ++n2;
        }
        jInlineMenu.setMenuItems(arrayList.toArray(new JMenuItem[arrayList.size()]));
        return jInlineMenu;
    }

    private JMenuItem getPopupPresenter(Node node, VcsCommand vcsCommand, int n) {
        String string = node.getDisplayName();
        Object object = new JMenuPlus(string);
        this.addMenu(node, (JMenu)object, n);
        if (object.getSubElements().length == 0) {
            object = this.createItem(vcsCommand);
        }
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        FileObject fileObject = (FileObject)this.fileObject.get();
        if (vcsFileSystem == null || fileObject == null) {
            return;
        }
        RevisionItem[] revisionItemArray = this.selectedRevisionItems.toArray(new RevisionItem[0]);
        Table table = new Table();
        String string2 = fileObject.getMIMEType();
        String string3 = fileObject.getPackageNameExt('/', '.');
        table.put(string3, fileObject);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string2 != null) {
            hashtable.put("MIMETYPE", string2);
        }
        if (revisionItemArray.length > 0) {
            hashtable.put("REVISION", revisionItemArray[0].getRevisionVCS());
        }
        int n = 0;
        while (n < revisionItemArray.length) {
            hashtable.put("REVISION" + (n + 1), revisionItemArray[n].getRevisionVCS());
            ++n;
        }
        hashtable.put("BRANCH", this.getBranch(revisionItemArray));
        VcsAction.doCommand(table, vcsFileSystem.getCommand(string), hashtable, vcsFileSystem);
    }

    private String getBranch(RevisionItem[] revisionItemArray) {
        String string = "";
        int n = 0;
        while (n < revisionItemArray.length) {
            String[] stringArray;
            if (revisionItemArray[0] != null && revisionItemArray[0].isBranch() && (stringArray = revisionItemArray[0].getTagNames()).length > 0) {
                string = stringArray[0];
            }
            ++n;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

