/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.TopManager;

public abstract class CacheDir
extends CacheFile {
    private int strategy;
    protected File dirFile;
    private boolean modified = false;
    private Map childDirs = null;
    private Map childFiles;
    private boolean local = true;
    protected FileSystemCache cacheObject;
    private ArrayList ignoreList;
    private boolean ignoreListWasSet = false;
    private RE regExp;
    private Object ignoreLock = new Object();
    protected final Object CHILD_FILES_LOCK;
    private Object createIgnoreListLock = new Object();

    public CacheDir(String string, File file, CacheFile.PersistentData persistentData) {
        super(string, persistentData);
        this.setAppliedLevel(-1);
        this.childFiles = new HashMap(20);
        this.childDirs = new HashMap(10);
        this.CHILD_FILES_LOCK = this.childFiles;
        this.modified = false;
        this.dirFile = file;
        this.setName(file.getName());
        this.cacheObject = CacheHandler.getInstance().getCache(this.getCacheName());
    }

    public CacheDir[] getSubDirs() {
        LinkedList<CacheDir> linkedList = new LinkedList<CacheDir>();
        CacheHandler cacheHandler = CacheHandler.getInstance();
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Iterator iterator = ((AbstractList)new ArrayList(this.childDirs.keySet())).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Reference reference = (Reference)this.childDirs.get(string);
                CacheDir cacheDir = (CacheDir)reference.get();
                if (cacheDir == null) {
                    CacheFile.PersistentData persistentData = cacheHandler.getReferencedData(reference);
                    cacheDir = persistentData != null ? (CacheDir)this.createChildFromData(persistentData) : this.readDirFromDisk(string);
                    cacheDir.setParent(this);
                    this.childDirs.put(string, this.createReference(cacheDir));
                }
                linkedList.add(cacheDir);
            }
        }
        return linkedList.toArray(new CacheDir[linkedList.size()]);
    }

    public String[] getSubDirNames() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            String[] stringArray = this.childDirs.keySet().toArray(new String[0]);
            return stringArray;
        }
    }

    public CacheDir getSubDir(String string) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Object object2;
            Reference reference = (Reference)this.childDirs.get(string);
            if (reference == null) {
                CacheDir cacheDir = null;
                return cacheDir;
            }
            CacheDir cacheDir = (CacheDir)reference.get();
            if (cacheDir == null) {
                object2 = CacheHandler.getInstance().getReferencedData(reference);
                cacheDir = object2 != null ? (CacheDir)this.createChildFromData((CacheFile.PersistentData)object2) : this.readDirFromDisk(string);
                cacheDir.setParent(this);
                this.childDirs.put(string, this.createReference(cacheDir));
                this.getCacheObject().registerDir(cacheDir);
            }
            object2 = cacheDir;
            return object2;
        }
    }

    protected CacheDir getSubDirIfExists(String string) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Reference reference = (Reference)this.childDirs.get(string);
            if (reference == null) {
                CacheDir cacheDir = null;
                return cacheDir;
            }
            CacheDir cacheDir = (CacheDir)reference.get();
            return cacheDir;
        }
    }

    public CacheDir addChildDir(CacheDir cacheDir, boolean bl) {
        CacheDir cacheDir2 = this.getCacheObject().getDir(cacheDir.getAbsolutePath());
        if (cacheDir2 != null && cacheDir2.getCacheName().equals(this.getCacheName())) {
            cacheDir = cacheDir2;
        } else {
            this.getCacheObject().registerDir(cacheDir);
        }
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            this.setModifiedContent(true);
            this.childDirs.put(cacheDir.getName(), this.createReference(cacheDir));
            cacheDir.setParent(this);
        }
        if (bl) {
            this.getCacheObject().fireCacheHandlerEvent(0, cacheDir);
        }
        return cacheDir;
    }

    public void removeChildDir(String string, boolean bl) {
        CacheDir cacheDir = this.getSubDir(string);
        if (cacheDir != null) {
            Object object = this.CHILD_FILES_LOCK;
            synchronized (object) {
                this.setModifiedContent(true);
                this.childDirs.remove(cacheDir.getName());
            }
            this.getCacheObject().unregisterDir(cacheDir);
            if (bl) {
                this.getCacheObject().fireCacheHandlerEvent(1, cacheDir);
            }
            cacheDir.setParent(null);
            cacheDir.setModifiedContent(false);
            cacheDir.getPersistentData().setModified(false);
        }
    }

    public void renameChild(String string, String string2, boolean bl) {
        CacheFile cacheFile = this.getFile(string);
        if (cacheFile != null) {
            Object object = this.CHILD_FILES_LOCK;
            synchronized (object) {
                cacheFile.setName(string2);
                this.childFiles.put(string2, this.childFiles.remove(string));
            }
        } else {
            CacheDir cacheDir = this.getSubDir(string);
            if (cacheDir != null) {
                Object object = this.CHILD_FILES_LOCK;
                synchronized (object) {
                    this.getCacheObject().unregisterDir(cacheDir);
                    cacheDir.setName(string2);
                    this.childDirs.remove(string);
                    this.childDirs.put(string2, this.createReference(cacheDir));
                    this.getCacheObject().registerDir(cacheDir);
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.getCacheObject().fireCacheHandlerEvent(2, this);
        }
    }

    public void renameChildDirs(CacheDir cacheDir, boolean bl) {
        CacheDir[] cacheDirArray = this.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            CacheDir cacheDir2 = cacheDirArray[n];
            this.removeChildDir(cacheDir2.getName(), bl);
            cacheDir2.rename(new File(cacheDir.getAbsolutePath() + File.separator + cacheDir2.getName()));
            cacheDir.addChildDir(cacheDir2, bl);
            cacheDir2.renameChildDirs(cacheDir2, false);
            ++n;
        }
    }

    public void rename(File file) {
        this.getCacheObject().unregisterDir(this);
        this.dirFile = file;
        this.setName(this.dirFile.getName());
        this.getCacheObject().registerDir(this);
    }

    public CacheFile[] getFiles() {
        LinkedList<CacheFile> linkedList = new LinkedList<CacheFile>();
        CacheHandler cacheHandler = CacheHandler.getInstance();
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Iterator iterator = ((AbstractList)new ArrayList(this.childFiles.keySet())).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Reference reference = (Reference)this.childFiles.get(string);
                CacheFile cacheFile = (CacheFile)reference.get();
                if (cacheFile == null) {
                    CacheFile.PersistentData persistentData = cacheHandler.getReferencedData(reference);
                    cacheFile = persistentData != null ? this.createChildFromData(persistentData) : this.readFileFromDisk(string);
                    cacheFile.setParent(this);
                    this.childFiles.put(string, this.createReference(cacheFile));
                }
                linkedList.add(cacheFile);
            }
        }
        return linkedList.toArray(new CacheFile[linkedList.size()]);
    }

    public String[] getFileNames() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            String[] stringArray = this.childFiles.keySet().toArray(new String[0]);
            return stringArray;
        }
    }

    public CacheFile getFile(String string) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Object object2;
            Reference reference = (Reference)this.childFiles.get(string);
            if (reference == null) {
                CacheFile cacheFile = null;
                return cacheFile;
            }
            CacheFile cacheFile = (CacheFile)reference.get();
            if (cacheFile == null) {
                object2 = CacheHandler.getInstance().getReferencedData(reference);
                cacheFile = object2 != null ? this.createChildFromData((CacheFile.PersistentData)object2) : this.readFileFromDisk(string);
                cacheFile.setParent(this);
                this.childFiles.put(string, this.createReference(cacheFile));
            }
            object2 = cacheFile;
            return object2;
        }
    }

    protected CacheFile getFileIfExists(String string) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Reference reference = (Reference)this.childFiles.get(string);
            if (reference == null) {
                CacheFile cacheFile = null;
                return cacheFile;
            }
            CacheFile cacheFile = (CacheFile)reference.get();
            return cacheFile;
        }
    }

    public void addFile(CacheFile cacheFile, boolean bl) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            this.setModifiedContent(true);
            this.childFiles.put(cacheFile.getName(), this.createReference(cacheFile));
            cacheFile.setParent(this);
        }
        if (bl) {
            this.getCacheObject().fireCacheHandlerEvent(0, cacheFile);
        }
    }

    public void removeFile(String string, boolean bl) {
        CacheFile cacheFile = this.getFile(string);
        if (cacheFile != null) {
            Object object = this.CHILD_FILES_LOCK;
            synchronized (object) {
                this.setModifiedContent(true);
                this.childFiles.remove(string);
            }
            if (bl) {
                this.getCacheObject().fireCacheHandlerEvent(1, cacheFile);
            }
            cacheFile.setParent(null);
            cacheFile.getPersistentData().setModified(false);
        }
    }

    public void removeFiles() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Iterator iterator = this.childFiles.values().iterator();
            while (iterator.hasNext()) {
                Reference reference = (Reference)iterator.next();
                CacheFile cacheFile = (CacheFile)reference.get();
                if (cacheFile == null) continue;
                cacheFile.setParent(null);
            }
            if (this.childFiles.size() > 0) {
                this.setModifiedContent(true);
            }
            this.childFiles.clear();
        }
    }

    public void removeAll(boolean bl) {
        this.removeFiles();
        CacheDir[] cacheDirArray = this.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            if (bl) {
                cacheDirArray[n].removeAll(true);
            }
            this.removeChildDir(cacheDirArray[n].getName(), false);
            ++n;
        }
    }

    protected abstract CacheFile createChildFromData(CacheFile.PersistentData var1);

    public final void setAppliedLevel(int n) {
        this.strategy = n;
    }

    public final int getAppliedLevel() {
        return this.strategy;
    }

    public String getName() {
        return this.dirFile.getName();
    }

    public void setName(String string) {
        super.setName(string);
        this.dirFile = new File(this.dirFile.getParentFile(), string);
    }

    public String getAbsolutePath() {
        return this.dirFile.getAbsolutePath();
    }

    public String getFilePath() {
        return this.dirFile.getPath();
    }

    public String toString() {
        return this.getName();
    }

    public final void setModifiedContent(boolean bl) {
        this.modified = bl;
    }

    public final boolean isModifiedContent() {
        return this.modified;
    }

    public boolean isEmpty() {
        return this.childDirs.size() == 0 && this.childFiles.size() == 0;
    }

    public final boolean isLocal() {
        return this.local;
    }

    public final void setLocal(boolean bl) {
        this.local = bl;
    }

    public FileSystemCache getCacheObject() {
        return this.cacheObject;
    }

    protected abstract String getCacheFileName();

    public void writeToDiskRecursively() {
        this.writeToDisk();
        CacheDir[] cacheDirArray = this.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            cacheDirArray[n].writeToDiskRecursively();
            ++n;
        }
    }

    public final void setIgnoreList(ArrayList arrayList) {
        Object object = this.ignoreLock;
        synchronized (object) {
            this.ignoreList = arrayList;
            this.regExp = null;
            this.ignoreListWasSet = true;
        }
        this.getCacheObject().fireCacheHandlerEvent(4, this);
    }

    public final ArrayList getIgnoreList() {
        return this.ignoreList;
    }

    public final boolean isIgnoreListSet() {
        return this.ignoreListWasSet;
    }

    protected void createIgnoreList() {
    }

    public final boolean isIgnored(String string) {
        Object object;
        if (!this.isIgnoreListSet()) {
            object = this.createIgnoreListLock;
            synchronized (object) {
                this.createIgnoreList();
            }
        }
        object = this.ignoreLock;
        synchronized (object) {
            if (this.ignoreList == null) {
                boolean bl = false;
                return bl;
            }
            if (this.regExp == null) {
                String string2 = CacheDir.computeRegularExpressionFromIgnoreList(this.ignoreList);
                try {
                    this.regExp = new RE(string2);
                }
                catch (RESyntaxException rESyntaxException) {
                    try {
                        this.regExp = new RE("");
                    }
                    catch (RESyntaxException rESyntaxException2) {
                        // empty catch block
                    }
                }
            }
            try {
                boolean bl = this.regExp.match(string);
                return bl;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw (StringIndexOutOfBoundsException)TopManager.getDefault().getErrorManager().annotate((Throwable)stringIndexOutOfBoundsException, "If this exception happens to you, please add this debugging message to the issue #19481:\nthe ignore list = " + this.ignoreListToString() + "\n" + "regular expression = " + CacheDir.computeRegularExpressionFromIgnoreList(this.ignoreList) + "\n" + "regular expression compiled = " + new String(this.regExp.getProgram().getInstructions()) + "\n" + "match(" + string + ")");
            }
        }
    }

    private String ignoreListToString() {
        if (this.ignoreList == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.ignoreList.size()) {
            stringBuffer.append("'" + this.ignoreList.get(n) + "', ");
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String computeRegularExpressionFromIgnoreList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            if (n != 0) {
                stringBuffer.append("|");
            }
            StringBuffer stringBuffer2 = new StringBuffer((String)list.get(n));
            int n2 = 0;
            while (n2 < stringBuffer2.length()) {
                switch (stringBuffer2.charAt(n2)) {
                    case '.': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\.");
                        ++n2;
                        break;
                    }
                    case '*': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, ".*");
                        ++n2;
                        break;
                    }
                    case '$': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\$");
                        ++n2;
                        break;
                    }
                    case '\\': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\\\");
                        ++n2;
                        break;
                    }
                    case '+': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\+");
                        ++n2;
                        break;
                    }
                    case '?': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\?");
                        ++n2;
                        break;
                    }
                    case '^': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\^");
                        ++n2;
                        break;
                    }
                    case '|': {
                        stringBuffer2 = stringBuffer2.replace(n2, n2 + 1, "\\|");
                        ++n2;
                        break;
                    }
                }
                ++n2;
            }
            stringBuffer.append(stringBuffer2.toString());
            ++n;
        }
        stringBuffer.insert(0, "^(");
        stringBuffer.append(")$");
        return stringBuffer.toString();
    }

    private Reference createReference(CacheFile cacheFile) {
        CacheHandler cacheHandler = CacheHandler.getInstance();
        WeakReference<CacheFile> weakReference = new WeakReference<CacheFile>(cacheFile, cacheHandler.getCacheFileReferenceQueue());
        cacheHandler.addReferencedData(weakReference, cacheFile.getPersistentData());
        return weakReference;
    }

    public abstract void writeToDisk();

    public abstract void populateWithLocal(Object var1);

    public abstract boolean readFromDisk(Object var1);

    protected abstract CacheFile readFileFromDisk(String var1);

    protected abstract CacheDir readDirFromDisk(String var1);

    public abstract void checkServer(Object var1);

    public abstract void checkServerRecursive(Object var1);
}

